/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws.dynamo;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.BatchGetItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.TableKeysAndAttributes;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import io.leoplatform.sdk.bus.OffloadingBot;
import io.leoplatform.sdk.config.ConnectorConfig;
import io.leoplatform.sdk.payload.EntityPayload;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DynamoReader {
    private final ObjectMapper mapper = DynamoReader.buildMapper();
    private final String cronTable;
    private final String eventTable;
    private final DynamoDB dynamoDB;

    @Inject
    public DynamoReader(ConnectorConfig config) {
        this.cronTable = config.value("Cron");
        this.eventTable = config.value("Event");
        this.dynamoDB = new DynamoDB((AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials(this.credentials(config))).withRegion(config.valueOrElse("Region", "us-east-1"))).withClientConfiguration(this.clientConfig())).build());
    }

    public Stream<EntityPayload> events(OffloadingBot bot) {
        TableKeysAndAttributes cron = new TableKeysAndAttributes(this.cronTable).addHashOnlyPrimaryKey("id", (Object)bot.name());
        BatchGetItemOutcome outcome = this.dynamoDB.batchGetItem(new TableKeysAndAttributes[]{cron});
        return outcome.getTableItems().values().stream().flatMap(Collection::stream).map(Item::toJSON).map(this::toEntityPayload);
    }

    private EntityPayload toEntityPayload(String json) {
        try {
            return (EntityPayload)this.mapper.readValue(json, EntityPayload.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid entity payload JSON", e);
        }
    }

    private ClientConfiguration clientConfig() {
        return PredefinedClientConfigurations.dynamoDefault().withConnectionTimeout(2000).withRequestTimeout(5000).withMaxErrorRetry(2);
    }

    private AWSCredentialsProvider credentials(ConnectorConfig config) {
        try {
            return Optional.of(config.valueOrElse("AwsProfile", "")).map(String::trim).filter(profile -> !profile.isEmpty()).map(ProfileCredentialsProvider::new).filter(p -> p.getCredentials() != null).map(AWSCredentialsProvider.class::cast).orElse((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
        }
        catch (Exception e) {
            return DefaultAWSCredentialsProviderChain.getInstance();
        }
    }

    private static ObjectMapper buildMapper() {
        return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.ALWAYS).registerModule((Module)new JSR353Module());
    }
}

