/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.SDKModule_ProvideConnectorConfigFactory;
import io.leoplatform.sdk.SDKModule_ProvideExecutorManagerFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisResultsFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisWriteFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideThresholdMonitorFactory;
import io.leoplatform.sdk.aws.AWSPlatform;
import io.leoplatform.sdk.aws.kinesis.KinesisProducerWriter;
import io.leoplatform.sdk.aws.kinesis.KinesisResults;
import io.leoplatform.sdk.config.ConnectorConfig;
import io.leoplatform.sdk.payload.ThresholdMonitor;
import javax.inject.Provider;

public final class DaggerAWSPlatform
implements AWSPlatform {
    private Provider<ConnectorConfig> provideConnectorConfigProvider;
    private Provider<ExecutorManager> provideExecutorManagerProvider;
    private Provider<ExecutorManager> executorManagerProvider;
    private Provider<ThresholdMonitor> provideThresholdMonitorProvider;
    private Provider<KinesisResults> provideKinesisResultsProvider;
    private Provider<KinesisProducerWriter> provideKinesisWriteProvider;

    private DaggerAWSPlatform(Builder builder) {
        this.initialize(builder);
    }

    public static AWSPlatform.Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideConnectorConfigProvider = DoubleCheck.provider((Provider)SDKModule_ProvideConnectorConfigFactory.create());
        this.provideExecutorManagerProvider = DoubleCheck.provider((Provider)SDKModule_ProvideExecutorManagerFactory.create(this.provideConnectorConfigProvider));
        this.executorManagerProvider = InstanceFactory.create((Object)builder.executorManager);
        this.provideThresholdMonitorProvider = DoubleCheck.provider((Provider)AWSModule_ProvideThresholdMonitorFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider));
        this.provideKinesisResultsProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisResultsFactory.create(this.provideThresholdMonitorProvider));
        this.provideKinesisWriteProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisWriteFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider, this.provideKinesisResultsProvider));
    }

    public ConnectorConfig connectorConfig() {
        return (ConnectorConfig)this.provideConnectorConfigProvider.get();
    }

    public ExecutorManager executorManager() {
        return (ExecutorManager)this.provideExecutorManagerProvider.get();
    }

    @Override
    public ThresholdMonitor thresholdMonitor() {
        return (ThresholdMonitor)this.provideThresholdMonitorProvider.get();
    }

    @Override
    public KinesisProducerWriter kinesisWrite() {
        return (KinesisProducerWriter)this.provideKinesisWriteProvider.get();
    }

    @Override
    public KinesisResults kinesisResults() {
        return (KinesisResults)this.provideKinesisResultsProvider.get();
    }

    private static final class Builder
    implements AWSPlatform.Builder {
        private ExecutorManager executorManager;

        private Builder() {
        }

        @Override
        public AWSPlatform build() {
            if (this.executorManager == null) {
                throw new IllegalStateException(ExecutorManager.class.getCanonicalName() + " must be set");
            }
            return new DaggerAWSPlatform(this);
        }

        @Override
        public Builder executorManager(ExecutorManager executorManager) {
            this.executorManager = (ExecutorManager)Preconditions.checkNotNull((Object)executorManager);
            return this;
        }
    }
}

