/*
 * Decompiled with CFR 0.152.
 */
package io.leoplatform.sdk.aws;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import io.leoplatform.sdk.AsyncWorkQueue;
import io.leoplatform.sdk.ExecutorManager;
import io.leoplatform.sdk.LoadingStream;
import io.leoplatform.sdk.SDKModule_ProvideConnectorConfigFactory;
import io.leoplatform.sdk.SDKModule_ProvideExecutorManagerFactory;
import io.leoplatform.sdk.aws.AWSLoadingPlatform;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisCompressionFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisQueueFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisResultsFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideKinesisWriteFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideLoadingStreamFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideS3QueueFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideS3ResultsFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideS3TransferManagerFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideS3WriterFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideStreamJsonPayloadFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideThresholdMonitorFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideTransferProxyFactory;
import io.leoplatform.sdk.aws.AWSModule_ProvideWorkQueuesFactory;
import io.leoplatform.sdk.aws.WorkQueues;
import io.leoplatform.sdk.aws.kinesis.KinesisProducerWriter;
import io.leoplatform.sdk.aws.kinesis.KinesisResults;
import io.leoplatform.sdk.aws.payload.CompressionWriter;
import io.leoplatform.sdk.aws.payload.S3JsonPayload;
import io.leoplatform.sdk.aws.s3.S3Results;
import io.leoplatform.sdk.aws.s3.S3TransferManager;
import io.leoplatform.sdk.aws.s3.S3Writer;
import io.leoplatform.sdk.bus.LoadingBot;
import io.leoplatform.sdk.config.ConnectorConfig;
import io.leoplatform.sdk.payload.ThresholdMonitor;
import javax.inject.Provider;

public final class DaggerAWSLoadingPlatform
implements AWSLoadingPlatform {
    private Provider<ConnectorConfig> provideConnectorConfigProvider;
    private Provider<ExecutorManager> provideExecutorManagerProvider;
    private Provider<ExecutorManager> executorManagerProvider;
    private Provider<ThresholdMonitor> provideThresholdMonitorProvider;
    private Provider<KinesisResults> provideKinesisResultsProvider;
    private Provider<KinesisProducerWriter> provideKinesisWriteProvider;
    private Provider<LoadingBot> loadingBotProvider;
    private Provider<S3JsonPayload> provideStreamJsonPayloadProvider;
    private Provider<CompressionWriter> provideKinesisCompressionProvider;
    private Provider<AsyncWorkQueue> provideKinesisQueueProvider;
    private Provider<S3Results> provideS3ResultsProvider;
    private Provider<S3TransferManager> provideS3TransferManagerProvider;
    private Provider<S3Writer> provideS3WriterProvider;
    private Provider<AsyncWorkQueue> provideS3QueueProvider;
    private Provider<WorkQueues> provideWorkQueuesProvider;
    private Provider<AsyncWorkQueue> provideTransferProxyProvider;
    private Provider<LoadingStream> provideLoadingStreamProvider;

    private DaggerAWSLoadingPlatform(Builder builder) {
        this.initialize(builder);
    }

    public static AWSLoadingPlatform.Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideConnectorConfigProvider = DoubleCheck.provider((Provider)SDKModule_ProvideConnectorConfigFactory.create());
        this.provideExecutorManagerProvider = DoubleCheck.provider((Provider)SDKModule_ProvideExecutorManagerFactory.create(this.provideConnectorConfigProvider));
        this.executorManagerProvider = InstanceFactory.create((Object)builder.executorManager);
        this.provideThresholdMonitorProvider = DoubleCheck.provider((Provider)AWSModule_ProvideThresholdMonitorFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider));
        this.provideKinesisResultsProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisResultsFactory.create(this.provideThresholdMonitorProvider));
        this.provideKinesisWriteProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisWriteFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider, this.provideKinesisResultsProvider));
        this.loadingBotProvider = InstanceFactory.create((Object)builder.loadingBot);
        this.provideStreamJsonPayloadProvider = DoubleCheck.provider((Provider)AWSModule_ProvideStreamJsonPayloadFactory.create(this.loadingBotProvider));
        this.provideKinesisCompressionProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisCompressionFactory.create(this.provideStreamJsonPayloadProvider));
        this.provideKinesisQueueProvider = DoubleCheck.provider((Provider)AWSModule_ProvideKinesisQueueFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider, this.provideKinesisCompressionProvider, this.provideKinesisWriteProvider));
        this.provideS3ResultsProvider = DoubleCheck.provider((Provider)AWSModule_ProvideS3ResultsFactory.create(this.provideKinesisCompressionProvider, this.provideKinesisWriteProvider, this.provideThresholdMonitorProvider));
        this.provideS3TransferManagerProvider = DoubleCheck.provider((Provider)AWSModule_ProvideS3TransferManagerFactory.create(this.provideConnectorConfigProvider, this.executorManagerProvider, this.provideS3ResultsProvider, this.loadingBotProvider));
        this.provideS3WriterProvider = DoubleCheck.provider((Provider)AWSModule_ProvideS3WriterFactory.create(this.provideConnectorConfigProvider, this.provideS3TransferManagerProvider, this.executorManagerProvider));
        this.provideS3QueueProvider = DoubleCheck.provider((Provider)AWSModule_ProvideS3QueueFactory.create(this.executorManagerProvider, this.provideKinesisCompressionProvider, this.provideS3WriterProvider));
        this.provideWorkQueuesProvider = DoubleCheck.provider((Provider)AWSModule_ProvideWorkQueuesFactory.create(this.provideConnectorConfigProvider, this.provideKinesisQueueProvider, this.provideS3QueueProvider));
        this.provideTransferProxyProvider = DoubleCheck.provider((Provider)AWSModule_ProvideTransferProxyFactory.create(this.provideWorkQueuesProvider, this.provideThresholdMonitorProvider));
        this.provideLoadingStreamProvider = DoubleCheck.provider((Provider)AWSModule_ProvideLoadingStreamFactory.create(this.provideTransferProxyProvider, this.executorManagerProvider));
    }

    public ConnectorConfig connectorConfig() {
        return (ConnectorConfig)this.provideConnectorConfigProvider.get();
    }

    public ExecutorManager executorManager() {
        return (ExecutorManager)this.provideExecutorManagerProvider.get();
    }

    @Override
    public ThresholdMonitor thresholdMonitor() {
        return (ThresholdMonitor)this.provideThresholdMonitorProvider.get();
    }

    @Override
    public KinesisProducerWriter kinesisWrite() {
        return (KinesisProducerWriter)this.provideKinesisWriteProvider.get();
    }

    @Override
    public KinesisResults kinesisResults() {
        return (KinesisResults)this.provideKinesisResultsProvider.get();
    }

    @Override
    public LoadingStream loadingStream() {
        return (LoadingStream)this.provideLoadingStreamProvider.get();
    }

    @Override
    public WorkQueues workQueues() {
        return (WorkQueues)this.provideWorkQueuesProvider.get();
    }

    @Override
    public AsyncWorkQueue transferProxy() {
        return (AsyncWorkQueue)this.provideTransferProxyProvider.get();
    }

    @Override
    public AsyncWorkQueue kinesisQueue() {
        return (AsyncWorkQueue)this.provideKinesisQueueProvider.get();
    }

    @Override
    public AsyncWorkQueue s3Queue() {
        return (AsyncWorkQueue)this.provideS3QueueProvider.get();
    }

    @Override
    public CompressionWriter kinesisCompression() {
        return (CompressionWriter)this.provideKinesisCompressionProvider.get();
    }

    @Override
    public S3JsonPayload s3JsonPayload() {
        return (S3JsonPayload)this.provideStreamJsonPayloadProvider.get();
    }

    @Override
    public S3TransferManager s3TransferManager() {
        return (S3TransferManager)this.provideS3TransferManagerProvider.get();
    }

    @Override
    public S3Writer s3Writer() {
        return (S3Writer)this.provideS3WriterProvider.get();
    }

    @Override
    public S3Results s3Results() {
        return (S3Results)this.provideS3ResultsProvider.get();
    }

    private static final class Builder
    implements AWSLoadingPlatform.Builder {
        private ExecutorManager executorManager;
        private LoadingBot loadingBot;

        private Builder() {
        }

        @Override
        public AWSLoadingPlatform build() {
            if (this.executorManager == null) {
                throw new IllegalStateException(ExecutorManager.class.getCanonicalName() + " must be set");
            }
            if (this.loadingBot == null) {
                throw new IllegalStateException(LoadingBot.class.getCanonicalName() + " must be set");
            }
            return new DaggerAWSLoadingPlatform(this);
        }

        @Override
        public Builder executorManager(ExecutorManager executorManager) {
            this.executorManager = (ExecutorManager)Preconditions.checkNotNull((Object)executorManager);
            return this;
        }

        @Override
        public Builder loadingBot(LoadingBot loadingBot) {
            this.loadingBot = (LoadingBot)Preconditions.checkNotNull((Object)loadingBot);
            return this;
        }
    }
}

