/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.ShadowedKafkaDataConsumer;
import org.apache.spark.sql.kafka010.ShadowedKafkaDataConsumer$;
import org.apache.spark.sql.kafka010.ShadowedKafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.ShadowedKafkaSourceRDDPartition;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005md!B\u0001\u0003\u0001\ta!AF*iC\u0012|w/\u001a3LC\u001a\\\u0017mU8ve\u000e,'\u000b\u0012#\u000b\u0005\r!\u0011\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0002\u0001\u001bA\u0019a\"E\n\u000e\u0003=Q!\u0001\u0005\u0004\u0002\u0007I$G-\u0003\u0002\u0013\u001f\t\u0019!\u000b\u0012#\u0011\tQYR$H\u0007\u0002+)\u0011acF\u0001\tG>t7/^7fe*\u0011\u0001$G\u0001\bG2LWM\u001c;t\u0015\tQ\u0002\"A\u0003lC\u001a\\\u0017-\u0003\u0002\u001d+\tq1i\u001c8tk6,'OU3d_J$\u0007c\u0001\u0010\"G5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001fI%\u0011Qe\b\u0002\u0005\u0005f$X\r\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003*\u0003\t\u00198m\u0001\u0001\u0011\u0005)ZS\"\u0001\u0004\n\u000512!\u0001D*qCJ\\7i\u001c8uKb$\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002'\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0011\tA*tGP\u0007\u0002c)\u0011!gM\u0001\u0005kRLGNC\u00015\u0003\u0011Q\u0017M^1\n\u0005Y\n$aA'baB\u0011\u0001h\u000f\b\u0003=eJ!AO\u0010\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u}\u0001\"a\u0010\"\u000e\u0003\u0001S!!Q\u001a\u0002\t1\fgnZ\u0005\u0003\u0007\u0002\u0013aa\u00142kK\u000e$\b\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u0019=4gm]3u%\u0006tw-Z:\u0011\u0007\u001d{%K\u0004\u0002I\u001b:\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nK\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!AT\u0010\u0002\u000fA\f7m[1hK&\u0011\u0001+\u0015\u0002\u0004'\u0016\f(B\u0001( !\t\u0019F+D\u0001\u0003\u0013\t)&AA\u0011TQ\u0006$wn^3e\u0017\u000647.Y*pkJ\u001cWM\u0015#E\u001f\u001a47/\u001a;SC:<W\r\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u00035\u0001x\u000e\u001c7US6,w.\u001e;NgB\u0011a$W\u0005\u00035~\u0011A\u0001T8oO\"AA\f\u0001B\u0001B\u0003%Q,\u0001\bgC&dwJ\u001c#bi\u0006dun]:\u0011\u0005yq\u0016BA0 \u0005\u001d\u0011un\u001c7fC:D\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006I!X\u0001\u0013e\u0016,8/Z&bM.\f7i\u001c8tk6,'\u000fC\u0003d\u0001\u0011\u0005A-\u0001\u0004=S:LGO\u0010\u000b\bK\u001a<\u0007.\u001b6l!\t\u0019\u0006\u0001C\u0003(E\u0002\u0007\u0011\u0006C\u0003/E\u0002\u0007q\u0006C\u0003FE\u0002\u0007a\tC\u0003XE\u0002\u0007\u0001\fC\u0003]E\u0002\u0007Q\fC\u0003bE\u0002\u0007Q\fC\u0003n\u0001\u0011\u0005c.A\u0004qKJ\u001c\u0018n\u001d;\u0015\u0005=\u0004X\"\u0001\u0001\t\u000bEd\u0007\u0019\u0001:\u0002\u00119,w\u000fT3wK2\u0004\"a\u001d<\u000e\u0003QT!!\u001e\u0004\u0002\u000fM$xN]1hK&\u0011q\u000f\u001e\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\u0006s\u0002!\tE_\u0001\u000eO\u0016$\b+\u0019:uSRLwN\\:\u0016\u0003m\u00042AH\u0011}!\tQS0\u0003\u0002\u007f\r\tI\u0001+\u0019:uSRLwN\u001c\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0003\u0015\u0019w.\u001e8u)\u0005A\u0006bBA\u0004\u0001\u0011\u0005\u0013\u0011B\u0001\fG>,h\u000e^!qaJ|\u0007\u0010\u0006\u0004\u0002\f\u0005u\u0011\u0011\u0005\t\u0007\u0003\u001b\t\u0019\"a\u0006\u000e\u0005\u0005=!bAA\t\r\u00059\u0001/\u0019:uS\u0006d\u0017\u0002BA\u000b\u0003\u001f\u0011Q\u0002U1si&\fGNU3tk2$\b\u0003BA\u0007\u00033IA!a\u0007\u0002\u0010\ti!i\\;oI\u0016$Gi\\;cY\u0016Dq!a\b\u0002\u0006\u0001\u0007\u0001,A\u0004uS6,w.\u001e;\t\u0015\u0005\r\u0012Q\u0001I\u0001\u0002\u0004\t)#\u0001\u0006d_:4\u0017\u000eZ3oG\u0016\u00042AHA\u0014\u0013\r\tIc\b\u0002\u0007\t>,(\r\\3\t\u000f\u00055\u0002\u0001\"\u0011\u00020\u00059\u0011n]#naRLH#A/\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005!A/Y6f)\u0011\t9$!\u000f\u0011\u0007y\t3\u0003\u0003\u0005\u0002<\u0005E\u0002\u0019AA\u001f\u0003\rqW/\u001c\t\u0004=\u0005}\u0012bAA!?\t\u0019\u0011J\u001c;\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005)r-\u001a;Qe\u00164WM\u001d:fI2{7-\u0019;j_:\u001cH\u0003BA%\u0003\u0017\u00022aR(8\u0011\u001d\ti%a\u0011A\u0002q\fQa\u001d9mSRDq!!\u0015\u0001\t\u0003\n\u0019&A\u0004d_6\u0004X\u000f^3\u0015\r\u0005U\u00131LA0!\u00119\u0015qK\n\n\u0007\u0005e\u0013K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u001d\ti&a\u0014A\u0002q\fq\u0001\u001e5f!\u0006\u0014H\u000f\u0003\u0005\u0002b\u0005=\u0003\u0019AA2\u0003\u001d\u0019wN\u001c;fqR\u00042AKA3\u0013\r\t9G\u0002\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000fC\u0004\u0002l\u0001!I!!\u001c\u0002\u0019I,7o\u001c7wKJ\u000bgnZ3\u0015\u000bI\u000by'a\u001e\t\u000fY\tI\u00071\u0001\u0002rA\u00191+a\u001d\n\u0007\u0005U$AA\rTQ\u0006$wn^3e\u0017\u000647.\u0019#bi\u0006\u001cuN\\:v[\u0016\u0014\bbBA=\u0003S\u0002\rAU\u0001\u0006e\u0006tw-\u001a")
public class ShadowedKafkaSourceRDD
extends RDD<ConsumerRecord<byte[], byte[]>> {
    private final java.util.Map<String, Object> executorKafkaParams;
    private final Seq<ShadowedKafkaSourceRDDOffsetRange> offsetRanges;
    public final long org$apache$spark$sql$kafka010$ShadowedKafkaSourceRDD$$pollTimeoutMs;
    public final boolean org$apache$spark$sql$kafka010$ShadowedKafkaSourceRDD$$failOnDataLoss;
    private final boolean reuseKafkaConsumer;

    public ShadowedKafkaSourceRDD persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return (ShadowedKafkaSourceRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.offsetRanges.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ShadowedKafkaSourceRDDPartition apply(Tuple2<ShadowedKafkaSourceRDDOffsetRange, Object> x0$1) {
                Tuple2<ShadowedKafkaSourceRDDOffsetRange, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    ShadowedKafkaSourceRDDOffsetRange o = (ShadowedKafkaSourceRDDOffsetRange)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    ShadowedKafkaSourceRDDPartition shadowedKafkaSourceRDDPartition = new ShadowedKafkaSourceRDDPartition(i, o);
                    return shadowedKafkaSourceRDDPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public long count() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.offsetRanges.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(ShadowedKafkaSourceRDDOffsetRange x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        long c = this.count();
        return new PartialResult((Object)new BoundedDouble((double)c, 1.0, (double)c, (double)c), true);
    }

    public boolean isEmpty() {
        return this.count() == 0L;
    }

    public ConsumerRecord<byte[], byte[]>[] take(int num) {
        ShadowedKafkaSourceRDDPartition[] nonEmptyPartitions = (ShadowedKafkaSourceRDDPartition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.partitions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ShadowedKafkaSourceRDDPartition apply(Partition x$2) {
                return (ShadowedKafkaSourceRDDPartition)x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ShadowedKafkaSourceRDDPartition.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ShadowedKafkaSourceRDDPartition x$3) {
                return x$3.offsetRange().size() > 0L;
            }
        });
        if (num < 1 || Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).isEmpty()) {
            return new ConsumerRecord[0];
        }
        Map parts = (Map)Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this, num){
            public static final long serialVersionUID = 0L;
            private final int num$1;

            public final Map<Object, Object> apply(Map<Object, Object> result, ShadowedKafkaSourceRDDPartition part) {
                Map map;
                int remain = this.num$1 - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if (remain > 0) {
                    long taken = Math.min((long)remain, part.offsetRange().size());
                    map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
                } else {
                    map = result;
                }
                return map;
            }
            {
                this.num$1 = num$1;
            }
        });
        ArrayBuffer buf = new ArrayBuffer();
        ConsumerRecord[][] res = (ConsumerRecord[][])this.context().runJob((RDD)this, (Function2)new Serializable(this, parts){
            public static final long serialVersionUID = 0L;
            private final Map parts$1;

            public final ConsumerRecord<byte[], byte[]>[] apply(TaskContext tc, Iterator<ConsumerRecord<byte[], byte[]>> it) {
                return (ConsumerRecord[])it.take(BoxesRunTime.unboxToInt((Object)this.parts$1.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class));
            }
            {
                this.parts$1 = parts$1;
            }
        }, (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ConsumerRecord.class)));
        Predef$.MODULE$.refArrayOps((Object[])res).foreach((Function1)new Serializable(this, buf){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer buf$1;

            public final ArrayBuffer<ConsumerRecord<byte[], byte[]>> apply(ConsumerRecord<byte[], byte[]>[] x$4) {
                return this.buf$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])x$4));
            }
            {
                this.buf$1 = buf$1;
            }
        });
        return (ConsumerRecord[])buf.toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        ShadowedKafkaSourceRDDPartition part = (ShadowedKafkaSourceRDDPartition)split;
        return (Seq)part.offsetRange().preferredLoc().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$5) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$5}));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> compute(Partition thePart, TaskContext context) {
        Object object;
        ShadowedKafkaSourceRDDPartition sourcePartition = (ShadowedKafkaSourceRDDPartition)thePart;
        String topic = sourcePartition.offsetRange().topic();
        int kafkaPartition = sourcePartition.offsetRange().partition();
        ShadowedKafkaDataConsumer consumer = ShadowedKafkaDataConsumer$.MODULE$.acquire(sourcePartition.offsetRange().topicPartition(), this.executorKafkaParams, this.reuseKafkaConsumer);
        ShadowedKafkaSourceRDDOffsetRange range = this.resolveRange(consumer, sourcePartition.offsetRange());
        Predef$.MODULE$.assert(range.fromOffset() <= range.untilOffset(), (Function0)new Serializable(this, range){
            public static final long serialVersionUID = 0L;
            private final ShadowedKafkaSourceRDDOffsetRange range$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is after the ending offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset()), BoxesRunTime.boxToLong((long)this.range$1.untilOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for topic ", " partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.topic(), BoxesRunTime.boxToInteger((int)this.range$1.partition())}))).append((Object)"You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString();
            }
            {
                this.range$1 = range$1;
            }
        });
        if (range.fromOffset() == range.untilOffset()) {
            this.logInfo((Function0)new Serializable(this, range){
                public static final long serialVersionUID = 0L;
                private final ShadowedKafkaSourceRDDOffsetRange range$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Beginning offset ", " is the same as ending offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$1.fromOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"skipping ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1.topic(), BoxesRunTime.boxToInteger((int)this.range$1.partition())}))).toString();
                }
                {
                    this.range$1 = range$1;
                }
            });
            object = package$.MODULE$.Iterator().empty();
        } else {
            NextIterator<ConsumerRecord<byte[], byte[]>> underlying = new NextIterator<ConsumerRecord<byte[], byte[]>>(this, consumer, range){
                private long requestOffset;
                private final /* synthetic */ ShadowedKafkaSourceRDD $outer;
                private final ShadowedKafkaDataConsumer consumer$1;
                private final ShadowedKafkaSourceRDDOffsetRange range$1;

                public long requestOffset() {
                    return this.requestOffset;
                }

                public void requestOffset_$eq(long x$1) {
                    this.requestOffset = x$1;
                }

                public ConsumerRecord<byte[], byte[]> getNext() {
                    ConsumerRecord<byte[], byte[]> consumerRecord;
                    if (this.requestOffset() >= this.range$1.untilOffset()) {
                        this.finished_$eq(true);
                        consumerRecord = null;
                    } else {
                        ConsumerRecord<byte[], byte[]> r = this.consumer$1.get(this.requestOffset(), this.range$1.untilOffset(), this.$outer.org$apache$spark$sql$kafka010$ShadowedKafkaSourceRDD$$pollTimeoutMs, this.$outer.org$apache$spark$sql$kafka010$ShadowedKafkaSourceRDD$$failOnDataLoss);
                        if (r == null) {
                            this.finished_$eq(true);
                            consumerRecord = null;
                        } else {
                            this.requestOffset_$eq(r.offset() + 1L);
                            consumerRecord = r;
                        }
                    }
                    return consumerRecord;
                }

                public void close() {
                    this.consumer$1.release();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.consumer$1 = consumer$1;
                    this.range$1 = range$1;
                    this.requestOffset = range$1.fromOffset();
                }
            };
            context.addTaskCompletionListener((Function1)new Serializable(this, (NextIterator)underlying){
                public static final long serialVersionUID = 0L;
                private final NextIterator underlying$1;

                public final void apply(TaskContext x$6) {
                    this.underlying$1.closeIfNeeded();
                }
                {
                    this.underlying$1 = underlying$1;
                }
            });
            object = underlying;
        }
        return object;
    }

    private ShadowedKafkaSourceRDDOffsetRange resolveRange(ShadowedKafkaDataConsumer consumer, ShadowedKafkaSourceRDDOffsetRange range) {
        ShadowedKafkaSourceRDDOffsetRange shadowedKafkaSourceRDDOffsetRange;
        if (range.fromOffset() < 0L || range.untilOffset() < 0L) {
            long l;
            long fromOffset;
            long l2;
            ShadowedKafkaDataConsumer.AvailableOffsetRange availableOffsetRange = consumer.getAvailableOffsetRange();
            if (range.fromOffset() < 0L) {
                Predef$.MODULE$.assert(range.fromOffset() == KafkaOffsetRangeLimit$.MODULE$.EARLIEST(), (Function0)new Serializable(this, range){
                    public static final long serialVersionUID = 0L;
                    private final ShadowedKafkaSourceRDDOffsetRange range$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"earliest offset ", " does not equal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$2.fromOffset()), BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST())}));
                    }
                    {
                        this.range$2 = range$2;
                    }
                });
                l2 = availableOffsetRange.earliest();
            } else {
                l2 = fromOffset = range.fromOffset();
            }
            if (range.untilOffset() < 0L) {
                Predef$.MODULE$.assert(range.untilOffset() == KafkaOffsetRangeLimit$.MODULE$.LATEST(), (Function0)new Serializable(this, range){
                    public static final long serialVersionUID = 0L;
                    private final ShadowedKafkaSourceRDDOffsetRange range$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latest offset ", " does not equal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.range$2.untilOffset()), BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST())}));
                    }
                    {
                        this.range$2 = range$2;
                    }
                });
                l = availableOffsetRange.latest();
            } else {
                l = range.untilOffset();
            }
            long untilOffset = l;
            shadowedKafkaSourceRDDOffsetRange = new ShadowedKafkaSourceRDDOffsetRange(range.topicPartition(), fromOffset, untilOffset, range.preferredLoc());
        } else {
            shadowedKafkaSourceRDDOffsetRange = range;
        }
        return shadowedKafkaSourceRDDOffsetRange;
    }

    public ShadowedKafkaSourceRDD(SparkContext sc, java.util.Map<String, Object> executorKafkaParams, Seq<ShadowedKafkaSourceRDDOffsetRange> offsetRanges, long pollTimeoutMs, boolean failOnDataLoss2, boolean reuseKafkaConsumer) {
        this.executorKafkaParams = executorKafkaParams;
        this.offsetRanges = offsetRanges;
        this.org$apache$spark$sql$kafka010$ShadowedKafkaSourceRDD$$pollTimeoutMs = pollTimeoutMs;
        this.org$apache$spark$sql$kafka010$ShadowedKafkaSourceRDD$$failOnDataLoss = failOnDataLoss2;
        this.reuseKafkaConsumer = reuseKafkaConsumer;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
    }
}

