/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.BigDecimalValue;
import io.lenses.sql.udf.value.BigIntValue;
import io.lenses.sql.udf.value.BooleanValue;
import io.lenses.sql.udf.value.ByteValue;
import io.lenses.sql.udf.value.DoubleValue;
import io.lenses.sql.udf.value.FloatValue;
import io.lenses.sql.udf.value.LongValue;
import io.lenses.sql.udf.value.Primitive;
import io.lenses.sql.udf.value.StringValue;
import io.lenses.sql.udf.value.TryConversion;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntValue
extends Primitive<Integer> {
    public IntValue(int value) {
        super(value, DataType.ltInt());
    }

    @Override
    public BigDecimalValue toBigDecimalValue() throws UdfException {
        TryConversion<BigDecimalValue> c = () -> new BigDecimalValue(new BigDecimal((Integer)this.underlying));
        return this.convert(c, DataType.ltBigDecimal());
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        TryConversion<BigIntValue> c = () -> new BigIntValue(BigInteger.valueOf(((Integer)this.underlying).longValue()));
        return this.convert(c, DataType.ltBigInt());
    }

    @Override
    public BooleanValue toBooleanValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltBoolean());
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        TryConversion<ByteValue> c = () -> new ByteValue(((Integer)this.underlying).byteValue());
        return this.convert(c, DataType.ltByte());
    }

    @Override
    public DoubleValue toDoubleValue() throws UdfException {
        TryConversion<DoubleValue> c = () -> new DoubleValue(((Integer)this.underlying).doubleValue());
        return this.convert(c, DataType.ltDouble());
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        TryConversion<FloatValue> c = () -> new FloatValue(((Integer)this.underlying).floatValue());
        return this.convert(c, DataType.ltFloat());
    }

    @Override
    public IntValue toIntValue() {
        return this;
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        TryConversion<LongValue> c = () -> new LongValue(((Integer)this.underlying).longValue());
        return this.convert(c, DataType.ltLong());
    }

    @Override
    public StringValue toStringValue() throws UdfException {
        TryConversion<StringValue> c = () -> new StringValue(((Integer)this.underlying).toString());
        return this.convert(c, DataType.ltString());
    }
}

