/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.BigDecimalValue;
import io.lenses.sql.udf.value.BigIntValue;
import io.lenses.sql.udf.value.BooleanValue;
import io.lenses.sql.udf.value.ByteValue;
import io.lenses.sql.udf.value.FloatValue;
import io.lenses.sql.udf.value.IntValue;
import io.lenses.sql.udf.value.LongValue;
import io.lenses.sql.udf.value.Primitive;
import io.lenses.sql.udf.value.StringValue;
import io.lenses.sql.udf.value.TryConversion;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DoubleValue
extends Primitive<Double> {
    public DoubleValue(double value) {
        super(value, DataType.ltDouble());
    }

    @Override
    public BigDecimalValue toBigDecimalValue() throws UdfException {
        TryConversion<BigDecimalValue> c = () -> new BigDecimalValue(new BigDecimal((Double)this.underlying));
        return this.convert(c, DataType.ltBigDecimal());
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        TryConversion<BigIntValue> c = () -> new BigIntValue(BigInteger.valueOf(((Double)this.underlying).longValue()));
        return this.convert(c, DataType.ltBigInt());
    }

    @Override
    public BooleanValue toBooleanValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltBoolean());
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        TryConversion<ByteValue> c = () -> new ByteValue(((Double)this.underlying).byteValue());
        return this.convert(c, DataType.ltByte());
    }

    @Override
    public DoubleValue toDoubleValue() {
        return this;
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        TryConversion<FloatValue> c = () -> new FloatValue(((Double)this.underlying).floatValue());
        return this.convert(c, DataType.ltFloat());
    }

    @Override
    public IntValue toIntValue() throws UdfException {
        TryConversion<IntValue> c = () -> new IntValue(((Double)this.underlying).intValue());
        return this.convert(c, DataType.ltInt());
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        TryConversion<LongValue> c = () -> new LongValue(((Double)this.underlying).longValue());
        return this.convert(c, DataType.ltLong());
    }

    @Override
    public StringValue toStringValue() throws UdfException {
        TryConversion<StringValue> c = () -> new StringValue(((Double)this.underlying).toString());
        return this.convert(c, DataType.ltString());
    }
}

