/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.datatype;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;
import java.util.Objects;

public class LTOptional<T extends DataType>
extends DataType {
    public static final String DATA_TYPE_NAME = "LTOptional";
    private final DataType inner;

    protected LTOptional(T dataType) throws UdfException {
        super(DATA_TYPE_NAME);
        this.inner = dataType;
        if (dataType.getClass().isAssignableFrom(this.getClass())) {
            throw new UdfException("Invalid use of optional. LTOptional<LTOptional<..>> is disabled.");
        }
    }

    public DataType actualType() {
        return this.inner;
    }

    @Override
    public boolean isNumber() {
        return this.inner.isBigDecimal() || this.inner.isBigInt() || this.inner.isDouble() || this.inner.isFloat() || this.inner.isInt() || this.inner.isLong();
    }

    @Override
    public boolean isBigDecimal() {
        return this.inner.isBigDecimal();
    }

    @Override
    public boolean isBigInt() {
        return this.inner.isBigInt();
    }

    @Override
    public boolean isBoolean() {
        return this.inner.isBoolean();
    }

    @Override
    public boolean isByte() {
        return this.inner.isByte();
    }

    @Override
    public boolean isDouble() {
        return this.inner.isDouble();
    }

    @Override
    public boolean isFloat() {
        return this.inner.isFloat();
    }

    @Override
    public boolean isInt() {
        return this.inner.isInt();
    }

    @Override
    public boolean isLong() {
        return this.inner.isLong();
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isRepeated() {
        return this.inner.isRepeated();
    }

    @Override
    public boolean isString() {
        return this.inner.isString();
    }

    @Override
    public boolean isStruct() {
        return this.inner.isStruct();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LTOptional)) {
            return false;
        }
        LTOptional that = (LTOptional)o;
        return this.inner.equals(that.inner);
    }

    public int hashCode() {
        return Objects.hash(this.inner);
    }
}

