/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.datatype;

import io.lenses.sql.udf.datatype.DataType;
import java.util.Arrays;
import java.util.Objects;

public class LTEnum
extends DataType {
    public static final String DATA_TYPE_NAME = "LTEnum";
    private final String[] values;
    private final String name;

    protected LTEnum(String name, String[] values) {
        super(DATA_TYPE_NAME);
        this.values = Arrays.copyOf(values, values.length);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public boolean isString() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LTEnum)) {
            return false;
        }
        LTEnum ltEnum = (LTEnum)o;
        return Arrays.equals(this.values, ltEnum.values) && Objects.equals(this.name, ltEnum.name);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

