/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;

public abstract class Container extends Value {

    public Container(DataType dt) {
        super(dt);
    }

    @Override
    public Primitive asPrimitive() throws UdfException {
        throw new UdfException("Value " + this + " is not a primitive.");
    }

    @Override
    public Container asContainer() throws UdfException {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    private UdfException failConversion(DataType to) {
        return UdfException.containerToPrimitiveConversion(this.dataType, to);
    }

    @Override
    public BigDecimalValue toBigDecimalValue() throws UdfException {
        throw failConversion(DataType.ltBigDecimal());
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        throw failConversion(DataType.ltBigInt());
    }

    @Override
    public BooleanValue toBooleanValue() throws UdfException {
        throw failConversion(DataType.ltBoolean());
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        throw failConversion(DataType.ltByte());
    }

    @Override
    public DoubleValue toDoubleValue() throws UdfException {
        throw failConversion(DataType.ltDouble());
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        throw failConversion(DataType.ltFloat());
    }

    @Override
    public IntValue toIntValue() throws UdfException {
        throw failConversion(DataType.ltInt());
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        throw failConversion(DataType.ltLong());
    }

    @Override
    public StringValue toStringValue() throws UdfException {
        throw failConversion(DataType.ltString());
    }
}
