/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;

import java.math.BigInteger;

public class ByteArrayValue extends Primitive<byte[]> {

    public ByteArrayValue(byte[] value) {
        super(value, DataType.ltByte());
    }

    @Override
    public BigDecimalValue toBigDecimalValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltBigDecimal());
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        TryConversion<BigIntValue> c = () -> new BigIntValue(new BigInteger(underlying));
        return convert(c, DataType.ltBigInt());
    }

    @Override
    public BooleanValue toBooleanValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltBoolean());
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltByte());
    }

    @Override
    public DoubleValue toDoubleValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltDouble());
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltFloat());
    }

    @Override
    public IntValue toIntValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltInt());
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltInt());
    }

    @Override
    public StringValue toStringValue() throws UdfException {
        TryConversion<StringValue> c = () -> new StringValue(new String(underlying));
        return convert(c, DataType.ltString());
    }

}
