/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;

public class BooleanValue extends Primitive<Boolean> {

    public BooleanValue(boolean value) {
        super(value, DataType.ltBoolean());
    }

    @Override
    public BigDecimalValue toBigDecimalValue() throws UdfException {
        throw UdfException.conversionNotSupported(dataType, DataType.ltBigDecimal());
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        throw UdfException.conversionNotSupported(dataType, DataType.ltBigInt());
    }

    @Override
    public BooleanValue toBooleanValue() {
        return this;
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        throw UdfException.conversionNotSupported(dataType, DataType.ltByte());
    }

    @Override
    public DoubleValue toDoubleValue() throws UdfException {
        throw UdfException.conversionNotSupported(dataType, DataType.ltDouble());
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        throw UdfException.conversionNotSupported(dataType, DataType.ltFloat());
    }

    @Override
    public IntValue toIntValue() throws UdfException {
        throw UdfException.conversionNotSupported(dataType, DataType.ltInt());
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        throw UdfException.conversionNotSupported(dataType, DataType.ltLong());
    }

    @Override
    public StringValue toStringValue() throws UdfException {
        TryConversion<StringValue> c = () -> new StringValue(underlying.toString());
        return convert(c, DataType.ltString());
    }

}
