/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;

import java.math.BigDecimal;

public class BigDecimalValue extends Primitive<BigDecimal> {

    public BigDecimalValue(BigDecimal value) {
        super(value, DataType.ltBigDecimal(value.precision(), value.scale()));
    }

    @Override
    public BigDecimalValue toBigDecimalValue() {
        return this;
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        TryConversion<BigIntValue> c = () -> new BigIntValue(underlying.toBigInteger());
        return convert(c, DataType.ltBigInt());
    }

    @Override
    public BooleanValue toBooleanValue() throws UdfException {
        throw UdfException.conversionNotSupported(dataType, DataType.ltBoolean());
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        TryConversion<ByteValue> c = () -> new ByteValue(underlying.byteValue());
        return convert(c, DataType.ltByte());
    }

    @Override
    public DoubleValue toDoubleValue() throws UdfException {
        TryConversion<DoubleValue> c = () -> new DoubleValue(underlying.doubleValue());
        return convert(c, DataType.ltDouble());
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        TryConversion<FloatValue> c = () -> new FloatValue(underlying.floatValue());
        return convert(c, DataType.ltFloat());
    }

    @Override
    public IntValue toIntValue() throws UdfException {
        TryConversion<IntValue> c = () -> new IntValue(underlying.intValue());
        return convert(c, DataType.ltInt());
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        TryConversion<LongValue> c = () -> new LongValue(underlying.longValue());
        return convert(c, DataType.ltLong());
    }

    @Override
    public StringValue toStringValue() throws UdfException {
        TryConversion<StringValue> c = () -> new StringValue(underlying.toString());
        return convert(c, DataType.ltString());
    }
}
