/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.datatype;

import java.util.Map;
import java.util.Objects;

public class LTStruct extends DataType {

    public static final String DATA_TYPE_NAME = "LTStruct";

    public final Map<String, DataType> schema;

    protected LTStruct(Map<String, DataType> schema) {
        super(DATA_TYPE_NAME);
        this.schema = schema;
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LTStruct)) return false;
        LTStruct ltStruct = (LTStruct) o;

        return schema.equals(ltStruct.schema);
    }

    @Override
    public int hashCode() {
        return Objects.hash(schema);
    }
}
