/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.datatype;

import java.util.Objects;

public class LTRepeated extends DataType {

    public static final String DATA_TYPE_NAME = "LTRepeated";

    public final DataType schema;

    protected LTRepeated(DataType schema) {
        super(DATA_TYPE_NAME);
        this.schema = schema;
    }

    @Override
    public boolean isRepeated() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LTRepeated)) return false;
        LTRepeated that = (LTRepeated) o;
        return schema.equals(that.schema);
    }

    @Override
    public int hashCode() {
        return Objects.hash(schema);
    }
}
