/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.datatype;


import java.util.Objects;

public class LTBigDecimal extends DataType {

    public static final String DATA_TYPE_NAME = "LTBigDecimal";

    // values adopted from opensql
    public static final int MAX_PRECISION = 38;
    public static final int DEFAULT_PRECISION = 18;
    public static final int DEFAULT_SCALE = 2;

    public final int precision;
    public final int scale;

    protected LTBigDecimal(int precision, int scale) {
        super(DATA_TYPE_NAME);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LTBigDecimal)) return false;
        LTBigDecimal that = (LTBigDecimal) o;
        return precision == that.precision &&
                scale == that.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hash(precision, scale);
    }
}
