/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf;

import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.Value;

/**
 * Interface for User Defined Functions taking three arguments.
 */
public interface UserDefinedFunction3 extends UserDefinedFunction {

    /**
     * Defines a mapping from input to output types.
     *
     * @param arg1Type The data type of the first argument.
     * @param arg2Type The data type of the second argument.
     * @param arg3Type The data type of the third argument.
     * @return The resulting data type.
     * @throws UdfException if one or more of the given data types are not supported by this UDF.
     */
    DataType typeMapping(DataType arg1Type, DataType arg2Type, DataType arg3Type) throws UdfException;

    /**
     * Evaluates this UDF for the given arguments.
     *
     * @param arg1 The first argument.
     * @param arg2 The second argument.
     * @param arg3 The third argument.
     * @return The result of the evaluation.
     * @throws UdfException if the evaluation failed for some reason.
     */
    Value evaluate(Value arg1, Value arg2, Value arg3) throws UdfException;

}
