/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.BigDecimalValue;
import io.lenses.sql.udf.value.BigIntValue;
import io.lenses.sql.udf.value.BooleanValue;
import io.lenses.sql.udf.value.ByteValue;
import io.lenses.sql.udf.value.Container;
import io.lenses.sql.udf.value.DoubleValue;
import io.lenses.sql.udf.value.FloatValue;
import io.lenses.sql.udf.value.IntValue;
import io.lenses.sql.udf.value.LongValue;
import io.lenses.sql.udf.value.OptionalValue;
import io.lenses.sql.udf.value.Primitive;
import io.lenses.sql.udf.value.RepeatedValue;
import io.lenses.sql.udf.value.StringValue;
import io.lenses.sql.udf.value.StructValue;
import io.lenses.sql.udf.value.TryConversion;

public abstract class Value {
    protected DataType dataType;

    protected <T extends Value> T convert(TryConversion<T> func, DataType toDataType) throws UdfException {
        try {
            return func.attemptConversion();
        }
        catch (Exception e) {
            throw UdfException.conversionError(this.dataType, toDataType, this.get());
        }
    }

    public Value(DataType dataType) {
        this.dataType = dataType;
    }

    public abstract Object get();

    public abstract Primitive asPrimitive() throws UdfException;

    public abstract Container asContainer() throws UdfException;

    public abstract RepeatedValue asRepeatedValue() throws UdfException;

    public abstract StructValue asStructValue() throws UdfException;

    public abstract boolean isPrimitive();

    public boolean isContainer() {
        return !this.isPrimitive();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public OptionalValue toOptional() throws UdfException {
        return OptionalValue.of(this);
    }

    public abstract BigDecimalValue toBigDecimalValue() throws UdfException;

    public abstract BigIntValue toBigIntValue() throws UdfException;

    public abstract BooleanValue toBooleanValue() throws UdfException;

    public abstract ByteValue toByteValue() throws UdfException;

    public abstract DoubleValue toDoubleValue() throws UdfException;

    public abstract FloatValue toFloatValue() throws UdfException;

    public abstract IntValue toIntValue() throws UdfException;

    public abstract LongValue toLongValue() throws UdfException;

    public abstract StringValue toStringValue() throws UdfException;
}

