/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.BigDecimalValue;
import io.lenses.sql.udf.value.BigIntValue;
import io.lenses.sql.udf.value.BooleanValue;
import io.lenses.sql.udf.value.ByteValue;
import io.lenses.sql.udf.value.DoubleValue;
import io.lenses.sql.udf.value.FloatValue;
import io.lenses.sql.udf.value.IntValue;
import io.lenses.sql.udf.value.LongValue;
import io.lenses.sql.udf.value.Primitive;
import io.lenses.sql.udf.value.TryConversion;
import java.math.BigDecimal;
import java.math.BigInteger;

public class StringValue
extends Primitive<String> {
    public StringValue(String value) {
        super(value, DataType.ltString());
        this.underlying = value;
    }

    @Override
    public BigDecimalValue toBigDecimalValue() throws UdfException {
        TryConversion<BigDecimalValue> c = () -> new BigDecimalValue(new BigDecimal((String)this.underlying));
        return this.convert(c, DataType.ltBigDecimal());
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        TryConversion<BigIntValue> c = () -> new BigIntValue(BigInteger.valueOf(Long.parseLong((String)this.underlying)));
        return this.convert(c, DataType.ltBigInt());
    }

    @Override
    public BooleanValue toBooleanValue() throws UdfException {
        TryConversion<BooleanValue> c = () -> new BooleanValue(Boolean.parseBoolean((String)this.underlying));
        return this.convert(c, DataType.ltBoolean());
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        throw UdfException.conversionNotSupported(this.dataType, DataType.ltByte());
    }

    @Override
    public DoubleValue toDoubleValue() throws UdfException {
        TryConversion<DoubleValue> c = () -> new DoubleValue(Double.parseDouble((String)this.underlying));
        return this.convert(c, DataType.ltDouble());
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        TryConversion<FloatValue> c = () -> new FloatValue(Float.parseFloat((String)this.underlying));
        return this.convert(c, DataType.ltFloat());
    }

    @Override
    public IntValue toIntValue() throws UdfException {
        TryConversion<IntValue> c = () -> new IntValue(Integer.parseInt((String)this.underlying));
        return this.convert(c, DataType.ltInt());
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        TryConversion<LongValue> c = () -> new LongValue(Long.parseLong((String)this.underlying));
        return this.convert(c, DataType.ltLong());
    }

    @Override
    public StringValue toStringValue() {
        return this;
    }
}

