/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.UdfRuntimeException;
import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.Container;
import io.lenses.sql.udf.value.StructValue;
import io.lenses.sql.udf.value.Value;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Vector;

public class RepeatedValue<A extends Value>
extends Container {
    private final List<A> underlying;
    private final DataType valueType;

    public RepeatedValue(List<A> values, DataType valueType) {
        super(DataType.ltRepeated(valueType));
        Optional<UdfRuntimeException> validationError = this.validate(values, valueType);
        if (validationError.isPresent()) {
            throw validationError.get();
        }
        this.underlying = values;
        this.valueType = valueType;
    }

    @Override
    public List<A> get() {
        return this.underlying;
    }

    @Override
    public RepeatedValue asRepeatedValue() {
        return this;
    }

    @Override
    public StructValue asStructValue() throws UdfException {
        throw new UdfException("Value " + this + " is not a struct.");
    }

    public Collection<A> getAllValues() {
        return this.underlying;
    }

    public Value get(int pos) {
        return (Value)this.underlying.get(pos);
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public static <T extends Value> RepeatedValue<T> empty(DataType valueType) {
        Vector empty = new Vector();
        return new RepeatedValue(empty, valueType);
    }

    public static <T extends Value> RepeatedValue<T> ofOne(T first) {
        Vector<T> values = new Vector<T>();
        values.add(first);
        return new RepeatedValue(values, first.dataType);
    }

    public static <T extends Value> RepeatedValue<T> ofTwo(T first, T second) {
        Vector<T> values = new Vector<T>();
        values.add(first);
        values.add(second);
        if (!RepeatedValue.ofSameType(values)) {
            throw UdfRuntimeException.invalidValueTypes();
        }
        return new RepeatedValue(values, first.dataType);
    }

    public static <T extends Value> RepeatedValue<T> ofThree(T first, T second, T third) {
        Vector<T> values = new Vector<T>();
        values.add(first);
        values.add(second);
        values.add(third);
        if (!RepeatedValue.ofSameType(values)) {
            throw UdfRuntimeException.invalidValueTypes();
        }
        return new RepeatedValue(values, first.dataType);
    }

    public static <T extends Value> RepeatedValue<T> ofValues(List<T> values) {
        if (values.isEmpty()) {
            throw new UdfRuntimeException("List of values must not be empty.");
        }
        if (!RepeatedValue.ofSameType(values)) {
            throw UdfRuntimeException.invalidValueTypes();
        }
        DataType valueType = ((Value)values.get(0)).getDataType();
        return new RepeatedValue<T>(values, valueType);
    }

    private Optional<UdfRuntimeException> validate(List<A> values, DataType valueType) {
        Optional<UdfRuntimeException> result = Optional.empty();
        if (!values.isEmpty()) {
            DataType firstDataType;
            if (!RepeatedValue.ofSameType(values)) {
                result = Optional.of(UdfRuntimeException.invalidValueTypes());
            }
            if (!(firstDataType = ((Value)values.get(0)).getDataType()).equals(valueType)) {
                result = Optional.of(UdfRuntimeException.valueTypesMismatch(firstDataType, valueType));
            }
        }
        return result;
    }

    private static <T extends Value> boolean ofSameType(List<T> values) {
        boolean result = true;
        if (!values.isEmpty()) {
            String valueType = ((Value)values.get((int)0)).getDataType().name;
            for (Value v : values) {
                if (v.getDataType().name == valueType) continue;
                result = false;
            }
        }
        return result;
    }
}

