/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.BigDecimalValue;
import io.lenses.sql.udf.value.BigIntValue;
import io.lenses.sql.udf.value.BooleanValue;
import io.lenses.sql.udf.value.ByteValue;
import io.lenses.sql.udf.value.Container;
import io.lenses.sql.udf.value.DoubleValue;
import io.lenses.sql.udf.value.FloatValue;
import io.lenses.sql.udf.value.IntValue;
import io.lenses.sql.udf.value.LongValue;
import io.lenses.sql.udf.value.Primitive;
import io.lenses.sql.udf.value.RepeatedValue;
import io.lenses.sql.udf.value.StringValue;
import io.lenses.sql.udf.value.StructValue;
import io.lenses.sql.udf.value.Value;
import java.util.Optional;

public class OptionalValue
extends Value {
    private final Optional<Value> inner;

    protected OptionalValue(Optional<Value> inner, DataType dataType) throws UdfException {
        super(dataType);
        this.inner = inner;
    }

    public Boolean nonEmpty() {
        return this.inner.isPresent();
    }

    public Boolean isEmpty() {
        return this.nonEmpty() == false;
    }

    @Override
    public Object get() {
        return this.inner.orElse(null);
    }

    @Override
    public Primitive asPrimitive() throws UdfException {
        this.throwIfEmptyOnConversion("Primitive");
        return this.inner.get().asPrimitive();
    }

    @Override
    public Container asContainer() throws UdfException {
        this.throwIfEmptyOnConversion("Container");
        return this.inner.get().asContainer();
    }

    @Override
    public RepeatedValue asRepeatedValue() throws UdfException {
        this.throwIfEmptyOnConversion("RepeatedValue");
        return this.inner.get().asRepeatedValue();
    }

    @Override
    public StructValue asStructValue() throws UdfException {
        this.throwIfEmptyOnConversion("StructValue");
        return this.inner.get().asStructValue();
    }

    @Override
    public boolean isPrimitive() {
        return this.inner.isPresent() && this.inner.get().isPrimitive();
    }

    @Override
    public BigDecimalValue toBigDecimalValue() throws UdfException {
        this.throwIfEmptyOnConversion("BigDecimalValue");
        return this.inner.get().toBigDecimalValue();
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        this.throwIfEmptyOnConversion("BigIntValue");
        return this.inner.get().toBigIntValue();
    }

    @Override
    public BooleanValue toBooleanValue() throws UdfException {
        this.throwIfEmptyOnConversion("BooleanValue");
        return this.inner.get().toBooleanValue();
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        this.throwIfEmptyOnConversion("ByteValue");
        return this.inner.get().toByteValue();
    }

    @Override
    public DoubleValue toDoubleValue() throws UdfException {
        this.throwIfEmptyOnConversion("DoubleValue");
        return this.inner.get().toDoubleValue();
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        this.throwIfEmptyOnConversion("FloatValue");
        return this.inner.get().toFloatValue();
    }

    @Override
    public IntValue toIntValue() throws UdfException {
        this.throwIfEmptyOnConversion("IntValue");
        return this.inner.get().toIntValue();
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        this.throwIfEmptyOnConversion("LongValue");
        return this.inner.get().toLongValue();
    }

    @Override
    public StringValue toStringValue() throws UdfException {
        this.throwIfEmptyOnConversion("StringValue");
        return this.inner.get().toStringValue();
    }

    private void throwIfEmptyOnConversion(String type) throws UdfException {
        if (!this.inner.isPresent()) {
            throw new UdfException("Invalid call. An empty optional cannot be converted to" + type + ".");
        }
    }

    public static OptionalValue empty(DataType dataType) throws UdfException {
        return new OptionalValue(Optional.empty(), DataType.ltOptional(dataType));
    }

    public static OptionalValue of(Value value) throws UdfException {
        if (value.getClass() == OptionalValue.class) {
            throw new UdfException("Invalid arguments. Creating an optional value of optional value is not allowed.");
        }
        return new OptionalValue(Optional.of(value), DataType.ltOptional(value.getDataType()));
    }
}

