/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.BigDecimalValue;
import io.lenses.sql.udf.value.BigIntValue;
import io.lenses.sql.udf.value.BooleanValue;
import io.lenses.sql.udf.value.ByteValue;
import io.lenses.sql.udf.value.DoubleValue;
import io.lenses.sql.udf.value.FloatValue;
import io.lenses.sql.udf.value.IntValue;
import io.lenses.sql.udf.value.LongValue;
import io.lenses.sql.udf.value.Primitive;
import io.lenses.sql.udf.value.StringValue;
import io.lenses.sql.udf.value.Value;

public abstract class Container
extends Value {
    public Container(DataType dt) {
        super(dt);
    }

    @Override
    public Primitive asPrimitive() throws UdfException {
        throw new UdfException("Value " + this + " is not a primitive.");
    }

    @Override
    public Container asContainer() throws UdfException {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    private UdfException failConversion(DataType to) {
        return UdfException.containerToPrimitiveConversion(this.dataType, to);
    }

    @Override
    public BigDecimalValue toBigDecimalValue() throws UdfException {
        throw this.failConversion(DataType.ltBigDecimal());
    }

    @Override
    public BigIntValue toBigIntValue() throws UdfException {
        throw this.failConversion(DataType.ltBigInt());
    }

    @Override
    public BooleanValue toBooleanValue() throws UdfException {
        throw this.failConversion(DataType.ltBoolean());
    }

    @Override
    public ByteValue toByteValue() throws UdfException {
        throw this.failConversion(DataType.ltByte());
    }

    @Override
    public DoubleValue toDoubleValue() throws UdfException {
        throw this.failConversion(DataType.ltDouble());
    }

    @Override
    public FloatValue toFloatValue() throws UdfException {
        throw this.failConversion(DataType.ltFloat());
    }

    @Override
    public IntValue toIntValue() throws UdfException {
        throw this.failConversion(DataType.ltInt());
    }

    @Override
    public LongValue toLongValue() throws UdfException {
        throw this.failConversion(DataType.ltLong());
    }

    @Override
    public StringValue toStringValue() throws UdfException {
        throw this.failConversion(DataType.ltString());
    }
}

