/*
 * Decompiled with CFR 0.152.
 */
package io.lenses.sql.udf;

import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.Value;
import java.util.ArrayList;
import java.util.List;

public class UdfException
extends Exception {
    public UdfException(String message) {
        super(message);
    }

    public static UdfException conversionNotSupported(DataType from, DataType to) {
        return new UdfException("Conversion of value of type " + from.name + " to value of type " + to.name + " is not supported.");
    }

    public static UdfException containerToPrimitiveConversion(DataType from, DataType to) {
        return new UdfException("Conversion of container type " + from.name + " to primitive value of type " + to.name + " is not supported.");
    }

    public static UdfException conversionError(DataType from, DataType to, Object value) {
        return new UdfException("Conversion of value of type " + from.name + "to value of type " + to.name + " failed for value: " + value);
    }

    public static UdfException argumentTypeNotSupported(String functionName, int position, DataType dataType) {
        return new UdfException("Function " + functionName + " does not support argument of type " + dataType.name + " at position " + position);
    }

    public static UdfException argumentTypesNotSupported(String functionName, List<DataType> dataTypes) {
        ArrayList dtNames = new ArrayList();
        dataTypes.forEach(dt -> dtNames.add(dt.name));
        return new UdfException("Function " + functionName + " does not support arguments with types " + dtNames);
    }

    public static UdfException fieldAccessError(List<Value> fields, int pos) {
        return new UdfException("Error while trying to access field at position " + pos + " of fields " + fields);
    }

    public static UdfException evaluationFailed(String functionName, List<Value> args, String reason) {
        return new UdfException("Evaluation of function " + functionName + " for arguments " + args + " failed: " + reason);
    }
}

