/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StructValue extends Container {

    private final Map<String, Value> underlying;

    private static Map<String, DataType> buildSchema(Map<String, Value> values) {
        Iterator<String> it = values.keySet().iterator();
        Map<String, DataType> result = new HashMap<>();
        while(it.hasNext()) {
            String k = it.next();
            DataType dt = values.get(k).getDataType();
            result.put(k, dt);
        }
        return result;
    }

    public StructValue(Map<String, Value> values) {
        super(DataType.ltStruct(buildSchema(values)));
        this.underlying = values;
    }

    @Override
    public Map<String, Value> get() {
        return underlying;
    }

    @Override
    public RepeatedValue asRepeatedValue() throws UdfException {
        throw new UdfException("Value " + this + " is not an array.");
    }

    @Override
    public StructValue asStructValue() {
        return this;
    }

    public Collection<Value> getAllValues() {
        return underlying.values();
    }

    public Value getField(String fieldName) {
        return underlying.get(fieldName);
    }

    public static StructValue ofOne(String fieldName, Value value) {
        Map<String, Value> values = new HashMap<>();
        values.put(fieldName, value);
        return new StructValue(values);
    }

    public static StructValue ofTwo(String fieldName1, Value value1, String fieldName2, Value value2) {
        Map<String, Value> values = new HashMap<>();
        values.put(fieldName1, value1);
        values.put(fieldName2, value2);
        return new StructValue(values);
    }

    public static StructValue ofThree(String fieldName1, Value value1,
                                      String fieldName2, Value value2,
                                      String fieldName3, Value value3) {
        Map<String, Value> values = new HashMap<>();
        values.put(fieldName1, value1);
        values.put(fieldName2, value2);
        values.put(fieldName3, value3);
        return new StructValue(values);
    }

}
