/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.value;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.datatype.DataType;

public abstract class Primitive<A> extends Value {

    protected A underlying;

    public Primitive(A value, DataType dt) {
        super(dt);
        this.underlying = value;
    }

    @Override
    public A get() {
        return underlying;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Primitive asPrimitive() {
        return this;
    }

    @Override
    public Container asContainer() throws UdfException {
        throw new UdfException("Value " + this + " is not a container.");
    }

    @Override
    public RepeatedValue asRepeatedValue() throws UdfException {
        throw new UdfException("Value " + this + " is not a repeated value.");
    }

    @Override
    public StructValue asStructValue() throws UdfException {
        throw new UdfException("Value " + this + " is not a struct value.");
    }
}
