/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.datatype;


import io.lenses.sql.udf.UdfException;

import java.util.Objects;

public class LTOptional<T extends DataType> extends DataType {
    public static final String DATA_TYPE_NAME = "LTOptional";
    private final DataType inner;

    protected LTOptional(T dataType) throws UdfException {
        super(DATA_TYPE_NAME);
        inner = dataType;
        if (dataType.getClass().isAssignableFrom(this.getClass())) {
            throw new UdfException("Invalid use of optional. LTOptional<LTOptional<..>> is disabled.");
        }
    }

    public DataType actualType() {
        return inner;
    }

    @Override
    public boolean isNumber() {
        return inner.isBigDecimal() || inner.isBigInt() || inner.isDouble() || inner.isFloat() || inner.isInt() || inner.isLong();
    }

    @Override
    public boolean isBigDecimal() {
        return inner.isBigDecimal();
    }

    public boolean isBigInt() {
        return inner.isBigInt();
    }

    public boolean isBoolean() {
        return inner.isBoolean();
    }

    public boolean isByte() {
        return inner.isByte();
    }

    public boolean isDouble() {
        return inner.isDouble();
    }

    public boolean isFloat() {
        return inner.isFloat();
    }

    public boolean isInt() {
        return inner.isInt();
    }

    public boolean isLong() {
        return inner.isLong();
    }

    public boolean isNullable() {
        return true;
    }

    public boolean isRepeated() {
        return inner.isRepeated();
    }

    public boolean isString() {
        return inner.isString();
    }

    public boolean isStruct() {
        return inner.isStruct();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LTOptional)) return false;
        LTOptional<?> that = (LTOptional<?>) o;
        return inner.equals(that.inner);
    }

    @Override
    public int hashCode() {
        return Objects.hash(inner);
    }
}
