/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.datatype;

import java.util.Arrays;
import java.util.Objects;

public class LTEnum extends DataType {

    public static final String DATA_TYPE_NAME = "LTEnum";

    private final String[] values;
    private final String name;

    protected LTEnum(String name, String[] values) {
        super(DATA_TYPE_NAME);
        this.values = Arrays.copyOf(values, values.length);
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public String[] getValues() {
        return Arrays.copyOf(values, values.length);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LTEnum)) return false;
        LTEnum ltEnum = (LTEnum) o;
        return Arrays.equals(values, ltEnum.values) &&
                Objects.equals(name, ltEnum.name);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(name);
        result = 31 * result + Arrays.hashCode(values);
        return result;
    }
}
