/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf.datatype;

import io.lenses.sql.udf.UdfException;
import io.lenses.sql.udf.UdfRuntimeException;

import java.util.Map;

public abstract class DataType {

    public final String name;

    public DataType(String name) {
        this.name = name;
    }

    public static LTBigDecimal ltBigDecimal() {
        return new LTBigDecimal(LTBigDecimal.DEFAULT_PRECISION, LTBigDecimal.DEFAULT_SCALE);
    }

    public static LTBigDecimal ltBigDecimal(int precision, int scale) {
        return new LTBigDecimal(precision, scale);
    }

    public static LTBigInt ltBigInt() {
        return LTBigInt.getInstance();
    }

    public static LTBoolean ltBoolean() {
        return LTBoolean.getInstance();
    }

    public static LTByte ltByte() {
        return LTByte.getInstance();
    }

    public static LTDouble ltDouble() {
        return LTDouble.getInstance();
    }

    public static LTFloat ltFloat() {
        return LTFloat.getInstance();
    }

    public static LTInt ltInt() {
        return LTInt.getInstance();
    }

    public static LTLong ltLong() {
        return LTLong.getInstance();
    }

    public static LTString ltString() {
        return LTString.getInstance();
    }

    public static LTByteArray ltByteArray() {
        return LTByteArray.getInstance();
    }

    public static LTEnum ltEnum(String name, String[] values) {
        return new LTEnum(name, values);
    }

    public static LTTimestampMillis ltTimestampMillis() {
        return LTTimestampMillis.getInstance();
    }

    public static LTTimeMillis ltTimeMillis() {
        return LTTimeMillis.getInstance();
    }

    public static LTTimeMicros ltTimeMicros() {
        return LTTimeMicros.getInstance();
    }

    public static LTTimestampMicros ltTimestampMicros() {
        return LTTimestampMicros.getInstance();
    }

    public static LTDate ltDate() { return LTDate.getInstance(); }

    public static LTRepeated ltRepeated(DataType schema) {
        return new LTRepeated(schema);
    }

    public static LTStruct ltStruct(Map<String, DataType> schema) {
        if (schema.isEmpty()) {
            throw UdfRuntimeException.emptySchema();
        }
        return new LTStruct(schema);
    }

    public static <T extends DataType> LTOptional<T> ltOptional(T dataType) throws UdfException {
        return new LTOptional<>(dataType);
    }

    // convenience methods to implement typer methods with less boiler-plate
    public final boolean isContainer() {
        return isRepeated() || isStruct();
    }

    public final boolean isPrimitive() {
        return !isContainer();
    }

    public boolean isNumber() {
        return isBigDecimal() || isBigInt() || isDouble() || isFloat() || isInt() || isLong();
    }

    public boolean isBigDecimal() {
        return false;
    }

    public boolean isBigInt() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isByte() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isRepeated() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isStruct() {
        return false;
    }


}
