/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf;

import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.Value;

/**
 * Interface for User Defined Functions taking two arguments.
 */
public interface UserDefinedFunction2 extends UserDefinedFunction {

    /**
     * Defines a mapping from input to output types.
     *
     * @param arg1Type The data type of the first argument.
     * @param arg2Type The data type of the second argument.
     * @return The resulting data type.
     * @throws UdfException if one or more of the given data types are not supported by this UDF.
     */
    DataType typeMapping(DataType arg1Type, DataType arg2Type) throws UdfException;

    /**
     * Evaluates this UDF for the given arguments.
     *
     * @param arg1 The first argument.
     * @param arg2 The second argument.
     * @return The result of the evaluation.
     * @throws UdfException if the evaluation failed for some reason.
     */
    Value evaluate(Value arg1, Value arg2) throws UdfException;

}
