/*
 * Copyright 2017-2022 Lenses.io Ltd
 */
package io.lenses.sql.udf;

import io.lenses.sql.udf.datatype.DataType;
import io.lenses.sql.udf.value.Value;

/**
 * Interface for User Defined Functions taking one argument.
 */
public interface UserDefinedFunction1 extends UserDefinedFunction {

    /**
     * Defines a mapping from input to output types.
     *
     * @param arg1Type The data type of the single argument.
     * @return The data type of the result.
     * @throws UdfException if the given data type is not supported by this UDF.
     */
    DataType typeMapping(DataType arg1Type) throws UdfException;

    /**
     * Evaluates this UDF for the given argument.
     *
     * @param arg1 The single argument of this UDF.
     * @return The result of the evaluation.
     * @throws UdfException if the evaluation failed for some reason.
     */
    Value evaluate(Value arg1) throws UdfException;

}
