/*
 * Copyright 2017-2019 Lenses.io Ltd
 */
package io.lenses.audits.plugin.scalaapi

import io.lenses.audits.plugin.{Audit => JAudit}
import io.lenses.audits.plugin.javaapi.{AuditService => JAuditService}
import io.lenses.audits.plugin.scalaapi.util.TryUtils._

import scala.util.Try

/**
  * simple Audit service wrapper giving Scala users a bit more type information
  */
class AuditService(underlying: JAuditService) {

  def publish(Audit: JAudit): Try[JAudit] = Try {
    underlying.publish(Audit).asScala
  }.flatten
}

object AuditService {
  def apply(underlying: JAuditService): AuditService = new AuditService(underlying)
}