/*
 * Copyright 2017-2019 Lenses.io Ltd
 */
package io.lenses.audits.plugin.scalaapi

import java.util.Optional

import io.lenses.audits.plugin.{Audit => JAudit}

import scala.collection.JavaConverters._

case class Audit(resource: String,
                 change: String,
                 user: String,
                 timestamp: Long,
                 resourceId: Option[String],
                 labels: Map[String, String]) {
  def asJava: JAudit = {
    new JAudit(resource,
      change,
      user,
      timestamp,
      resourceId.map(v => Optional.of(v)).getOrElse(Optional.empty()),
      labels.asJava)
  }
}
