/*
 * Lenra server internal API
 * The API usable by the Lenra applications
 *
 * The version of the OpenAPI document: 0.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lenra.api.internal.client;

import io.lenra.api.internal.ApiCallback;
import io.lenra.api.internal.ApiClient;
import io.lenra.api.internal.ApiException;
import io.lenra.api.internal.ApiResponse;
import io.lenra.api.internal.Configuration;
import io.lenra.api.internal.Pair;
import io.lenra.api.internal.ProgressRequestBody;
import io.lenra.api.internal.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.lenra.api.internal.client.model.FindDocumentsRequest;
import io.lenra.api.internal.client.model.InsertManyDocuments200Response;
import io.lenra.api.internal.client.model.InsertManyDocumentsRequest;
import io.lenra.api.internal.client.model.UpdateManyDocumentsRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for abortTransaction
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction aborted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call abortTransactionCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/transaction/abort";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call abortTransactionValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return abortTransactionCall(_callback);

    }

    /**
     * Aborts a transaction
     * 
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction aborted </td><td>  -  </td></tr>
     </table>
     */
    public void abortTransaction() throws ApiException {
        abortTransactionWithHttpInfo();
    }

    /**
     * Aborts a transaction
     * 
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction aborted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> abortTransactionWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = abortTransactionValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Aborts a transaction (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction aborted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call abortTransactionAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = abortTransactionValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for commitTransaction
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction commited </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call commitTransactionCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/transaction/commit";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call commitTransactionValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return commitTransactionCall(_callback);

    }

    /**
     * Commits a transaction
     * 
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction commited </td><td>  -  </td></tr>
     </table>
     */
    public void commitTransaction() throws ApiException {
        commitTransactionWithHttpInfo();
    }

    /**
     * Commits a transaction
     * 
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction commited </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> commitTransactionWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = commitTransactionValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Commits a transaction (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction commited </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call commitTransactionAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = commitTransactionValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for createDocument
     * @param coll The document collection name (required)
     * @param body The document to create (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createDocumentCall(String coll, Object body, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/colls/{coll}/docs"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createDocumentValidateBeforeCall(String coll, Object body, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling createDocument(Async)");
        }

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDocument(Async)");
        }

        return createDocumentCall(coll, body, _callback);

    }

    /**
     * Creates one document in database
     * 
     * @param coll The document collection name (required)
     * @param body The document to create (required)
     * @return Map&lt;String, Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document created </td><td>  -  </td></tr>
     </table>
     */
    public Map<String, Object> createDocument(String coll, Object body) throws ApiException {
        ApiResponse<Map<String, Object>> localVarResp = createDocumentWithHttpInfo(coll, body);
        return localVarResp.getData();
    }

    /**
     * Creates one document in database
     * 
     * @param coll The document collection name (required)
     * @param body The document to create (required)
     * @return ApiResponse&lt;Map&lt;String, Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Map<String, Object>> createDocumentWithHttpInfo(String coll, Object body) throws ApiException {
        okhttp3.Call localVarCall = createDocumentValidateBeforeCall(coll, body, null);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Creates one document in database (asynchronously)
     * 
     * @param coll The document collection name (required)
     * @param body The document to create (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createDocumentAsync(String coll, Object body, final ApiCallback<Map<String, Object>> _callback) throws ApiException {

        okhttp3.Call localVarCall = createDocumentValidateBeforeCall(coll, body, _callback);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createTransaction
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTransactionCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/transaction";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTransactionValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return createTransactionCall(_callback);

    }

    /**
     * Creates a transaction
     * 
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction created </td><td>  -  </td></tr>
     </table>
     */
    public String createTransaction() throws ApiException {
        ApiResponse<String> localVarResp = createTransactionWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Creates a transaction
     * 
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> createTransactionWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = createTransactionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Creates a transaction (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Transaction created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTransactionAsync(final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTransactionValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteCollection
     * @param coll The document collection name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Collection deleted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCollectionCall(String coll, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/app-api/v1-api/v1/data/colls/{coll}"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteCollectionValidateBeforeCall(String coll, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling deleteCollection(Async)");
        }

        return deleteCollectionCall(coll, _callback);

    }

    /**
     * Deletes a collection from database
     * 
     * @param coll The document collection name (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Collection deleted </td><td>  -  </td></tr>
     </table>
     */
    public void deleteCollection(String coll) throws ApiException {
        deleteCollectionWithHttpInfo(coll);
    }

    /**
     * Deletes a collection from database
     * 
     * @param coll The document collection name (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Collection deleted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteCollectionWithHttpInfo(String coll) throws ApiException {
        okhttp3.Call localVarCall = deleteCollectionValidateBeforeCall(coll, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Deletes a collection from database (asynchronously)
     * 
     * @param coll The document collection name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Collection deleted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCollectionAsync(String coll, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteCollectionValidateBeforeCall(coll, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteDocumentById
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document deleted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteDocumentByIdCall(String coll, String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/colls/{coll}/docs/{id}"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteDocumentByIdValidateBeforeCall(String coll, String id, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling deleteDocumentById(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteDocumentById(Async)");
        }

        return deleteDocumentByIdCall(coll, id, _callback);

    }

    /**
     * Deletes a document from database
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @return Map&lt;String, Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document deleted </td><td>  -  </td></tr>
     </table>
     */
    public Map<String, Object> deleteDocumentById(String coll, String id) throws ApiException {
        ApiResponse<Map<String, Object>> localVarResp = deleteDocumentByIdWithHttpInfo(coll, id);
        return localVarResp.getData();
    }

    /**
     * Deletes a document from database
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @return ApiResponse&lt;Map&lt;String, Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document deleted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Map<String, Object>> deleteDocumentByIdWithHttpInfo(String coll, String id) throws ApiException {
        okhttp3.Call localVarCall = deleteDocumentByIdValidateBeforeCall(coll, id, null);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Deletes a document from database (asynchronously)
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document deleted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteDocumentByIdAsync(String coll, String id, final ApiCallback<Map<String, Object>> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteDocumentByIdValidateBeforeCall(coll, id, _callback);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findDocuments
     * @param coll The document collection name (required)
     * @param findDocumentsRequest The query to find documents (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findDocumentsCall(String coll, FindDocumentsRequest findDocumentsRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = findDocumentsRequest;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/colls/{coll}/find"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findDocumentsValidateBeforeCall(String coll, FindDocumentsRequest findDocumentsRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling findDocuments(Async)");
        }

        // verify the required parameter 'findDocumentsRequest' is set
        if (findDocumentsRequest == null) {
            throw new ApiException("Missing the required parameter 'findDocumentsRequest' when calling findDocuments(Async)");
        }

        return findDocumentsCall(coll, findDocumentsRequest, _callback);

    }

    /**
     * Finds documents in database
     * 
     * @param coll The document collection name (required)
     * @param findDocumentsRequest The query to find documents (required)
     * @return List&lt;Map&lt;String, Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents found </td><td>  -  </td></tr>
     </table>
     */
    public List<Map<String, Object>> findDocuments(String coll, FindDocumentsRequest findDocumentsRequest) throws ApiException {
        ApiResponse<List<Map<String, Object>>> localVarResp = findDocumentsWithHttpInfo(coll, findDocumentsRequest);
        return localVarResp.getData();
    }

    /**
     * Finds documents in database
     * 
     * @param coll The document collection name (required)
     * @param findDocumentsRequest The query to find documents (required)
     * @return ApiResponse&lt;List&lt;Map&lt;String, Object&gt;&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Map<String, Object>>> findDocumentsWithHttpInfo(String coll, FindDocumentsRequest findDocumentsRequest) throws ApiException {
        okhttp3.Call localVarCall = findDocumentsValidateBeforeCall(coll, findDocumentsRequest, null);
        Type localVarReturnType = new TypeToken<List<Map<String, Object>>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Finds documents in database (asynchronously)
     * 
     * @param coll The document collection name (required)
     * @param findDocumentsRequest The query to find documents (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findDocumentsAsync(String coll, FindDocumentsRequest findDocumentsRequest, final ApiCallback<List<Map<String, Object>>> _callback) throws ApiException {

        okhttp3.Call localVarCall = findDocumentsValidateBeforeCall(coll, findDocumentsRequest, _callback);
        Type localVarReturnType = new TypeToken<List<Map<String, Object>>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDocumentById
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDocumentByIdCall(String coll, String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/colls/{coll}/docs/{id}"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDocumentByIdValidateBeforeCall(String coll, String id, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling getDocumentById(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDocumentById(Async)");
        }

        return getDocumentByIdCall(coll, id, _callback);

    }

    /**
     * Gets a document from database
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @return Map&lt;String, Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document created </td><td>  -  </td></tr>
     </table>
     */
    public Map<String, Object> getDocumentById(String coll, String id) throws ApiException {
        ApiResponse<Map<String, Object>> localVarResp = getDocumentByIdWithHttpInfo(coll, id);
        return localVarResp.getData();
    }

    /**
     * Gets a document from database
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @return ApiResponse&lt;Map&lt;String, Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Map<String, Object>> getDocumentByIdWithHttpInfo(String coll, String id) throws ApiException {
        okhttp3.Call localVarCall = getDocumentByIdValidateBeforeCall(coll, id, null);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Gets a document from database (asynchronously)
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDocumentByIdAsync(String coll, String id, final ApiCallback<Map<String, Object>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDocumentByIdValidateBeforeCall(coll, id, _callback);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDocuments
     * @param coll The document collection name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDocumentsCall(String coll, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/colls/{coll}/docs"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDocumentsValidateBeforeCall(String coll, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling getDocuments(Async)");
        }

        return getDocumentsCall(coll, _callback);

    }

    /**
     * Gets documents from database
     * 
     * @param coll The document collection name (required)
     * @return List&lt;Map&lt;String, Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents found </td><td>  -  </td></tr>
     </table>
     */
    public List<Map<String, Object>> getDocuments(String coll) throws ApiException {
        ApiResponse<List<Map<String, Object>>> localVarResp = getDocumentsWithHttpInfo(coll);
        return localVarResp.getData();
    }

    /**
     * Gets documents from database
     * 
     * @param coll The document collection name (required)
     * @return ApiResponse&lt;List&lt;Map&lt;String, Object&gt;&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Map<String, Object>>> getDocumentsWithHttpInfo(String coll) throws ApiException {
        okhttp3.Call localVarCall = getDocumentsValidateBeforeCall(coll, null);
        Type localVarReturnType = new TypeToken<List<Map<String, Object>>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Gets documents from database (asynchronously)
     * 
     * @param coll The document collection name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDocumentsAsync(String coll, final ApiCallback<List<Map<String, Object>>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDocumentsValidateBeforeCall(coll, _callback);
        Type localVarReturnType = new TypeToken<List<Map<String, Object>>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for insertManyDocuments
     * @param coll The documents collection name (required)
     * @param insertManyDocumentsRequest The documents to create (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents inserted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call insertManyDocumentsCall(String coll, InsertManyDocumentsRequest insertManyDocumentsRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = insertManyDocumentsRequest;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/colls/{coll}/insertMany"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call insertManyDocumentsValidateBeforeCall(String coll, InsertManyDocumentsRequest insertManyDocumentsRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling insertManyDocuments(Async)");
        }

        // verify the required parameter 'insertManyDocumentsRequest' is set
        if (insertManyDocumentsRequest == null) {
            throw new ApiException("Missing the required parameter 'insertManyDocumentsRequest' when calling insertManyDocuments(Async)");
        }

        return insertManyDocumentsCall(coll, insertManyDocumentsRequest, _callback);

    }

    /**
     * Inserts many documents in database
     * 
     * @param coll The documents collection name (required)
     * @param insertManyDocumentsRequest The documents to create (required)
     * @return InsertManyDocuments200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents inserted </td><td>  -  </td></tr>
     </table>
     */
    public InsertManyDocuments200Response insertManyDocuments(String coll, InsertManyDocumentsRequest insertManyDocumentsRequest) throws ApiException {
        ApiResponse<InsertManyDocuments200Response> localVarResp = insertManyDocumentsWithHttpInfo(coll, insertManyDocumentsRequest);
        return localVarResp.getData();
    }

    /**
     * Inserts many documents in database
     * 
     * @param coll The documents collection name (required)
     * @param insertManyDocumentsRequest The documents to create (required)
     * @return ApiResponse&lt;InsertManyDocuments200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents inserted </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InsertManyDocuments200Response> insertManyDocumentsWithHttpInfo(String coll, InsertManyDocumentsRequest insertManyDocumentsRequest) throws ApiException {
        okhttp3.Call localVarCall = insertManyDocumentsValidateBeforeCall(coll, insertManyDocumentsRequest, null);
        Type localVarReturnType = new TypeToken<InsertManyDocuments200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Inserts many documents in database (asynchronously)
     * 
     * @param coll The documents collection name (required)
     * @param insertManyDocumentsRequest The documents to create (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents inserted </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call insertManyDocumentsAsync(String coll, InsertManyDocumentsRequest insertManyDocumentsRequest, final ApiCallback<InsertManyDocuments200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = insertManyDocumentsValidateBeforeCall(coll, insertManyDocumentsRequest, _callback);
        Type localVarReturnType = new TypeToken<InsertManyDocuments200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateDocumentById
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @param requestBody The document to update (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDocumentByIdCall(String coll, String id, Map<String, Object> requestBody, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/colls/{coll}/docs/{id}"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateDocumentByIdValidateBeforeCall(String coll, String id, Map<String, Object> requestBody, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling updateDocumentById(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateDocumentById(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling updateDocumentById(Async)");
        }

        return updateDocumentByIdCall(coll, id, requestBody, _callback);

    }

    /**
     * Updates a document in database
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @param requestBody The document to update (required)
     * @return Map&lt;String, Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document updated </td><td>  -  </td></tr>
     </table>
     */
    public Map<String, Object> updateDocumentById(String coll, String id, Map<String, Object> requestBody) throws ApiException {
        ApiResponse<Map<String, Object>> localVarResp = updateDocumentByIdWithHttpInfo(coll, id, requestBody);
        return localVarResp.getData();
    }

    /**
     * Updates a document in database
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @param requestBody The document to update (required)
     * @return ApiResponse&lt;Map&lt;String, Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document updated </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Map<String, Object>> updateDocumentByIdWithHttpInfo(String coll, String id, Map<String, Object> requestBody) throws ApiException {
        okhttp3.Call localVarCall = updateDocumentByIdValidateBeforeCall(coll, id, requestBody, null);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Updates a document in database (asynchronously)
     * 
     * @param coll The document collection name (required)
     * @param id The document identifier (required)
     * @param requestBody The document to update (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Document updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDocumentByIdAsync(String coll, String id, Map<String, Object> requestBody, final ApiCallback<Map<String, Object>> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateDocumentByIdValidateBeforeCall(coll, id, requestBody, _callback);
        Type localVarReturnType = new TypeToken<Map<String, Object>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateManyDocuments
     * @param coll The document collection name (required)
     * @param updateManyDocumentsRequest The query to find documents (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManyDocumentsCall(String coll, UpdateManyDocumentsRequest updateManyDocumentsRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = updateManyDocumentsRequest;

        // create path and map variables
        String localVarPath = "/app-api/v1/data/colls/{coll}/updateMany"
            .replace("{" + "coll" + "}", localVarApiClient.escapeString(coll.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "bearerAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateManyDocumentsValidateBeforeCall(String coll, UpdateManyDocumentsRequest updateManyDocumentsRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'coll' is set
        if (coll == null) {
            throw new ApiException("Missing the required parameter 'coll' when calling updateManyDocuments(Async)");
        }

        // verify the required parameter 'updateManyDocumentsRequest' is set
        if (updateManyDocumentsRequest == null) {
            throw new ApiException("Missing the required parameter 'updateManyDocumentsRequest' when calling updateManyDocuments(Async)");
        }

        return updateManyDocumentsCall(coll, updateManyDocumentsRequest, _callback);

    }

    /**
     * Updates many documents in database
     * 
     * @param coll The document collection name (required)
     * @param updateManyDocumentsRequest The query to find documents (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents updated </td><td>  -  </td></tr>
     </table>
     */
    public Object updateManyDocuments(String coll, UpdateManyDocumentsRequest updateManyDocumentsRequest) throws ApiException {
        ApiResponse<Object> localVarResp = updateManyDocumentsWithHttpInfo(coll, updateManyDocumentsRequest);
        return localVarResp.getData();
    }

    /**
     * Updates many documents in database
     * 
     * @param coll The document collection name (required)
     * @param updateManyDocumentsRequest The query to find documents (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents updated </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> updateManyDocumentsWithHttpInfo(String coll, UpdateManyDocumentsRequest updateManyDocumentsRequest) throws ApiException {
        okhttp3.Call localVarCall = updateManyDocumentsValidateBeforeCall(coll, updateManyDocumentsRequest, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Updates many documents in database (asynchronously)
     * 
     * @param coll The document collection name (required)
     * @param updateManyDocumentsRequest The query to find documents (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Documents updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateManyDocumentsAsync(String coll, UpdateManyDocumentsRequest updateManyDocumentsRequest, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateManyDocumentsValidateBeforeCall(coll, updateManyDocumentsRequest, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
