/*
 * Decompiled with CFR 0.152.
 */
package io.lenra.app.api;

import io.lenra.api.internal.ApiException;
import io.lenra.api.internal.client.model.DataOptions;
import io.lenra.api.internal.client.model.FindDocumentsRequest;
import io.lenra.api.internal.client.model.UpdateManyDocumentsRequest;
import io.lenra.app.api.AbstractDataApi;
import java.util.List;
import java.util.Map;

abstract class AbstractCollection<T> {
    private final AbstractDataApi api;
    private final String name;

    AbstractCollection(AbstractDataApi api, String name) {
        this.api = api;
        this.name = name;
    }

    protected abstract T mapTo(Map<String, Object> var1);

    protected abstract Map<String, Object> mapFrom(T var1);

    protected abstract String getId(T var1);

    public T getDoc(String id) throws ApiException {
        return this.mapTo(this.api.getApi().getDocumentById(this.name, id));
    }

    public T createDoc(T doc) throws ApiException {
        return this.mapTo(this.api.getApi().createDocument(this.name, this.mapFrom(doc)));
    }

    public T updateDoc(T doc) throws ApiException {
        return this.mapTo(this.api.getApi().updateDocumentById(this.name, this.getId(doc), this.mapFrom(doc)));
    }

    public T deleteDoc(T doc) throws ApiException {
        return this.mapTo(this.api.getApi().deleteDocumentById(this.name, this.getId(doc)));
    }

    public List<T> find(Map<String, Object> query) throws ApiException {
        return this.find(query, null, null);
    }

    public List<T> find(Map<String, Object> query, Map<String, Object> projection) throws ApiException {
        return this.find(query, projection, null);
    }

    public List<T> find(Map<String, Object> query, DataOptions options) throws ApiException {
        return this.find(query, null, options);
    }

    public List<T> find(Map<String, Object> query, Map<String, Object> projection, DataOptions options) throws ApiException {
        FindDocumentsRequest req = new FindDocumentsRequest();
        req.setQuery(query);
        if (projection != null) {
            req.setProjection(projection);
        }
        if (options != null) {
            req.setOptions(options);
        }
        return this.api.getApi().findDocuments(this.name, req).stream().map(data -> this.mapTo((Map<String, Object>)data)).toList();
    }

    public Object updateMany(Map<String, Object> filter, Map<String, Object> update) throws ApiException {
        UpdateManyDocumentsRequest req = new UpdateManyDocumentsRequest();
        req.setFilter(filter);
        req.setUpdate(update);
        return this.api.getApi().updateManyDocuments(this.name, req);
    }
}

