/*
 * Decompiled with CFR 0.152.
 */
package io.lenra.app.annotation;

import com.google.auto.service.AutoService;
import io.lenra.app.annotation.AppListener;
import io.lenra.app.annotation.AppManifest;
import io.lenra.app.annotation.AppView;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.lenra.app.annotation.AppManifest", "io.lenra.app.annotation.AppView", "io.lenra.app.annotation.AppListener"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public class AppProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String manifestMethod = null;
        HashMap views = new HashMap();
        HashMap listeners = new HashMap();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            if (typeElement.getQualifiedName().toString().equals(AppManifest.class.getName())) {
                if (annotatedElements.size() > 1) {
                    throw new IllegalArgumentException("Too many manifests");
                }
                if (annotatedElements.isEmpty()) {
                    throw new IllegalArgumentException("No manifest");
                }
                ExecutableElement method = (ExecutableElement)annotatedElements.iterator().next();
                manifestMethod = this.processingEnv.getElementUtils().getBinaryName((TypeElement)method.getEnclosingElement()) + "." + method.getSimpleName();
                continue;
            }
            if (typeElement.getQualifiedName().toString().equals(AppView.class.getName())) {
                this.parseMethods(views, ViewParameter.class, AppView.class, AppView::prefix, AppView::name, annotatedElements);
                continue;
            }
            if (typeElement.getQualifiedName().toString().equals(AppListener.class.getName())) {
                this.parseMethods(listeners, ListenerParameter.class, AppListener.class, AppListener::prefix, AppListener::name, annotatedElements);
                continue;
            }
            throw new IllegalArgumentException("Unknown annotation: " + typeElement.getQualifiedName());
        }
        if (views.size() > 0 || listeners.size() > 0) {
            try {
                this.writeNamesEnum("io.lenra.app.view", "ViewName", views);
                this.writeNamesEnum("io.lenra.app.listener", "ListenerName", listeners);
                this.writeRequestHandlerClass(manifestMethod, views, listeners);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    private <A extends Annotation, T extends Enum<T>> void parseMethods(Map<String, MethodRef<T>> elements, Class<T> enumClass, Class<A> annotationClass, Function<A, String> prefixGetter, Function<A, String> nameGetter, Set<? extends Element> methods) {
        methods.forEach(element -> {
            ExecutableElement method = (ExecutableElement)element;
            this.parseMethod(elements, enumClass, annotationClass, prefixGetter, nameGetter, method);
        });
    }

    private <A extends Annotation, T extends Enum<T>> void parseMethod(Map<String, MethodRef<T>> elements, Class<T> enumClass, Class<A> annotationClass, Function<A, String> prefixGetter, Function<A, String> nameGetter, ExecutableElement method) {
        String prefix = "";
        Object name = "";
        A annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            prefix = prefixGetter.apply(annotation);
            name = nameGetter.apply(annotation);
        }
        if (((String)name).isEmpty()) {
            name = method.getSimpleName().toString();
        }
        if (!prefix.isEmpty()) {
            name = prefix + (String)name;
        }
        List<Parameter<T>> parameters = this.parseParameters(enumClass, method.getParameters());
        String methodFullName = this.processingEnv.getElementUtils().getBinaryName((TypeElement)method.getEnclosingElement()) + "." + method.getSimpleName();
        MethodRef<T> element = new MethodRef<T>(methodFullName, parameters);
        if (elements.containsKey(name)) {
            throw new IllegalArgumentException("View " + (String)name + " already exists");
        }
        elements.put((String)name, element);
    }

    private <T extends Enum<T>> List<Parameter<T>> parseParameters(Class<T> enumClass, List<? extends VariableElement> parameters) {
        ArrayList<Parameter<T>> parsedParameters = new ArrayList<Parameter<T>>();
        List<Enum> values = List.of((Enum[])enumClass.getEnumConstants());
        ArrayList<Enum> notAddedParam = new ArrayList<Enum>(values);
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement param = parameters.get(i);
            Enum type = null;
            for (Enum t : values) {
                if (param.getAnnotation(((AnnotatedParameter)((Object)t)).getAnnotation()) == null) continue;
                type = t;
                break;
            }
            if (type == null) {
                if (notAddedParam.isEmpty()) {
                    throw new IllegalArgumentException("Too many parameters");
                }
                type = notAddedParam.get(0);
            }
            if (!notAddedParam.remove(type)) {
                throw new IllegalArgumentException("Too many parameters of type " + type);
            }
            Parameter<Object> parameter = Parameter.parse(type, param);
            parsedParameters.add(parameter);
        }
        return parsedParameters;
    }

    private <T extends Enum<T>> void writeNamesEnum(String packageName, String enumName, Map<String, MethodRef<T>> handlers) throws IOException {
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(packageName + "." + enumName, new Element[0]);
        builderFile.delete();
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.print("package ");
            out.print(packageName);
            out.println(";");
            out.println();
            out.print("public enum ");
            out.print(enumName);
            out.println(" {");
            Iterator<String> namesIt = handlers.keySet().iterator();
            while (namesIt.hasNext()) {
                String name = namesIt.next();
                String enumValue = name.replaceAll("\\W+", "_").toUpperCase();
                out.print(" ");
                out.print(enumValue);
                out.print("(\"");
                out.print(name);
                out.print("\")");
                if (!namesIt.hasNext()) continue;
                out.println(",");
            }
            out.println(";");
            out.println("");
            out.println(" public final String value;");
            out.println();
            out.print(" private ");
            out.print(enumName);
            out.println("(String name) {");
            out.println("   this.value = name;");
            out.println(" }");
            out.println("}");
        }
    }

    private void writeRequestHandlerClass(String manifestMethod, Map<String, MethodRef<ViewParameter>> views, Map<String, MethodRef<ListenerParameter>> listeners) throws IOException {
        String packageName = "io.lenra.app";
        String className = "RequestHandlerImpl";
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(packageName + "." + className, new Element[0]);
        builderFile.delete();
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.print("package ");
            out.print(packageName);
            out.println(";");
            out.println();
            out.println("import io.lenra.app.requests.ViewRequest;");
            out.println("import io.lenra.app.requests.ListenerRequest;");
            out.println("import io.lenra.app.exception.NotFoundException;");
            out.println("import jakarta.enterprise.context.ApplicationScoped;");
            out.println("import jakarta.inject.Named;");
            out.println("import jakarta.inject.Inject;");
            out.println("import com.fasterxml.jackson.databind.ObjectMapper;");
            out.println("import com.fasterxml.jackson.core.type.TypeReference;");
            out.println();
            out.println("@Named");
            out.println("@ApplicationScoped");
            out.print("public class ");
            out.print(className);
            out.println(" extends RequestHandler {");
            out.println();
            out.println(" @Inject");
            out.println(" private ObjectMapper mapper;");
            out.println(" private Manifest manifest = " + manifestMethod + "();");
            out.println();
            out.println(" @Override");
            out.println(" public io.lenra.app.Manifest handleManifest() {");
            out.println("   return manifest;");
            out.println(" }");
            out.println();
            out.println(" @Override");
            out.println(" public Object handleView(ViewRequest request) {");
            out.println("   var name = request.getView();");
            this.writeRequestHandlers(out, views, true);
            out.println(" }");
            out.println();
            out.println(" @Override");
            out.println(" public void handleListener(ListenerRequest request) {");
            out.println("   var name = request.getListener();");
            this.writeRequestHandlers(out, listeners, false);
            out.println(" }");
            out.println();
            out.println("}");
        }
    }

    private <T extends Enum<T>> void writeRequestHandlers(PrintWriter out, Map<String, MethodRef<T>> handlers, boolean returns) throws IOException {
        out.println("   System.out.println(\"Handling \" + request.getClass().getSimpleName() + \" : \" + name);");
        out.println("   try {");
        out.println("     switch (name) {");
        handlers.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            MethodRef view = (MethodRef)entry.getValue();
            out.println("       case \"" + name + "\":");
            out.print("         ");
            if (returns) {
                out.print("return ");
            }
            out.print(view.getMethod() + "(");
            if (view.getParameters().size() > 0) {
                out.println();
                for (int i = 0; i < view.getParameters().size(); ++i) {
                    Parameter parameter = view.getParameters().get(i);
                    out.print("           mapper.convertValue(");
                    out.print("request.get");
                    out.print(((Enum)parameter.getType()).name().substring(0, 1).toUpperCase());
                    out.print(((Enum)parameter.getType()).name().substring(1).toLowerCase());
                    out.print("(), new TypeReference<");
                    out.print(parameter.getClassName());
                    out.print(">() { })");
                    if (i < view.getParameters().size() - 1) {
                        out.print(",");
                    }
                    out.println();
                }
                out.println("\t\t  \t );");
            } else {
                out.println(");");
            }
            if (!returns) {
                out.println("         break;");
            }
        });
        out.println("       default:");
        out.println("         throw new NotFoundException(\"Unknown element: \" + name);");
        out.println("     }");
        out.println("   } catch (Exception e) {");
        out.println("     throw new RuntimeException(e);");
        out.println("   }");
    }

    private static enum ViewParameter implements AnnotatedParameter
    {
        DATA(AppView.Data.class),
        PROPS(AppView.Props.class),
        CONTEXT(AppView.Context.class);

        private final Class<? extends Annotation> annotation;

        private <A extends Annotation> ViewParameter(Class<A> annotation) {
            this.annotation = annotation;
        }

        @Override
        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }
    }

    private static enum ListenerParameter implements AnnotatedParameter
    {
        PROPS(AppListener.Props.class),
        API(AppListener.Api.class);

        private final Class<? extends Annotation> annotation;

        private <A extends Annotation> ListenerParameter(Class<A> annotation) {
            this.annotation = annotation;
        }

        @Override
        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }
    }

    private static class MethodRef<T extends Enum<T>> {
        private String method;
        private List<Parameter<T>> parameters;

        public MethodRef(String method, List<Parameter<T>> parameters) {
            this.method = method;
            this.parameters = parameters;
        }

        public String getMethod() {
            return this.method;
        }

        public List<Parameter<T>> getParameters() {
            return this.parameters;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setParameters(List<Parameter<T>> parameters) {
            this.parameters = parameters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodRef)) {
                return false;
            }
            MethodRef other = (MethodRef)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            List<Parameter<T>> this$parameters = this.getParameters();
            List<Parameter<T>> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodRef;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            List<Parameter<T>> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        public String toString() {
            return "AppProcessor.MethodRef(method=" + this.getMethod() + ", parameters=" + this.getParameters() + ")";
        }
    }

    private static interface AnnotatedParameter {
        public Class<? extends Annotation> getAnnotation();
    }

    private static class Parameter<T extends Enum<T>> {
        private T type;
        private String className;

        public static <T extends Enum<T>> Parameter<T> parse(T type, VariableElement element) {
            return new Parameter<T>(type, element.asType().toString());
        }

        public Parameter(T type, String className) {
            this.type = type;
            this.className = className;
        }

        public T getType() {
            return this.type;
        }

        public String getClassName() {
            return this.className;
        }

        public void setType(T type) {
            this.type = type;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$type = this.getType();
            T other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            return !(this$className == null ? other$className != null : !this$className.equals(other$className));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            return result;
        }

        public String toString() {
            return "AppProcessor.Parameter(type=" + this.getType() + ", className=" + this.getClassName() + ")";
        }
    }
}

