/*
 * Decompiled with CFR 0.152.
 */
package io.lenra.app;

import io.lenra.app.AppRequest;
import io.lenra.app.Manifest;
import io.lenra.app.exception.NotFoundException;
import io.lenra.app.requests.ListenerRequest;
import io.lenra.app.requests.ResourceRequest;
import io.lenra.app.requests.ViewRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class RequestHandler {
    public Object handle(AppRequest request) {
        if (request instanceof ViewRequest) {
            return this.handleView((ViewRequest)request);
        }
        if (request instanceof ListenerRequest) {
            this.handleListener((ListenerRequest)request);
            return null;
        }
        if (request instanceof ResourceRequest) {
            return this.handleResource((ResourceRequest)request);
        }
        return this.handleManifest();
    }

    public abstract Object handleView(ViewRequest var1);

    public abstract void handleListener(ListenerRequest var1);

    public Resource handleResource(ResourceRequest request) {
        Resource resource;
        block9: {
            String resource2 = request.getResource();
            URL url = this.getClass().getResource("/assets/" + resource2);
            if (url == null) {
                throw new NotFoundException("Resource not found: " + resource2);
            }
            InputStream stream = url.openStream();
            try {
                String contentType = url.openConnection().getContentType();
                resource = new Resource(stream.readAllBytes(), contentType);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read resource: " + resource2, e);
                }
            }
            stream.close();
        }
        return resource;
    }

    public abstract Manifest handleManifest();

    public static class Resource {
        private final byte[] data;
        private final String mimetype;

        Resource(byte[] data, String mimetype) {
            this.data = data;
            this.mimetype = mimetype;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getMimetype() {
            return this.mimetype;
        }
    }
}

