package io.lenra.app.components;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.lenra.app.components.styles.autofillhints.Items;
import io.lenra.app.components.styles.DragStartBehavior;
import io.lenra.app.components.styles.MaxLengthEnforcement;
import io.lenra.app.components.styles.TextCapitalization;
import io.lenra.app.components.styles.TextDirection;
import io.lenra.app.components.styles.TextFieldStyle;
import io.lenra.app.components.styles.TextInputAction;
import io.lenra.app.components.styles.TextInputType;
import io.lenra.app.components.styles.ToolbarOptions;
import java.util.List;
import javax.annotation.processing.Generated;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.Setter;
import lombok.Singular;

@Generated("JSON Schema")
@JsonInclude(JsonInclude.Include.NON_NULL)
@Getter
@Setter
@NoArgsConstructor
class TextFieldBase {
  // Fields
  @JsonProperty("_type")
  private final String type = "textfield";
  @NonNull
  private String value;
  private Boolean autocorrect;
  @Singular
  private List<Items> autofillHints;
  private Boolean autofocus;
  private Listener buildCounter;
  private TextFieldStyle style;
  private DragStartBehavior dragStartBehavior;
  private Boolean enabled;
  private Boolean enableInteractiveSelection;
  private Boolean expands;
  private TextInputType keyboardType;
  private Integer maxLength;
  private MaxLengthEnforcement maxLengthEnforcement;
  private Integer maxLines;
  private Integer minLines;
  private Boolean obscureText;
  private Listener onAppPrivateCommand;
  private Listener onChanged;
  private Listener onEditingComplete;
  private Listener onSubmitted;
  private Listener onTap;
  private Boolean readOnly;
  private Boolean showCursor;
  private TextCapitalization textCapitalization;
  private TextDirection textDirection;
  private TextInputAction textInputAction;
  private ToolbarOptions toolbarOptions;
  private String name;
}
