/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.sdk.JSON;
import io.lakefs.clients.sdk.model.OtfDiffEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OtfDiffList {
    public static final String SERIALIZED_NAME_DIFF_TYPE = "diff_type";
    @SerializedName(value="diff_type")
    private DiffTypeEnum diffType;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private List<OtfDiffEntry> results = new ArrayList<OtfDiffEntry>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OtfDiffList diffType(DiffTypeEnum diffType) {
        this.diffType = diffType;
        return this;
    }

    @Nullable
    public DiffTypeEnum getDiffType() {
        return this.diffType;
    }

    public void setDiffType(DiffTypeEnum diffType) {
        this.diffType = diffType;
    }

    public OtfDiffList results(List<OtfDiffEntry> results) {
        this.results = results;
        return this;
    }

    public OtfDiffList addResultsItem(OtfDiffEntry resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<OtfDiffEntry>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @Nonnull
    public List<OtfDiffEntry> getResults() {
        return this.results;
    }

    public void setResults(List<OtfDiffEntry> results) {
        this.results = results;
    }

    public OtfDiffList putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtfDiffList otfDiffList = (OtfDiffList)o;
        return Objects.equals((Object)this.diffType, (Object)otfDiffList.diffType) && Objects.equals(this.results, otfDiffList.results) && Objects.equals(this.additionalProperties, otfDiffList.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diffType, this.results, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtfDiffList {\n");
        sb.append("    diffType: ").append(this.toIndentedString((Object)this.diffType)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OtfDiffList is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DIFF_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DIFF_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DIFF_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `diff_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIFF_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESULTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `results` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULTS).toString()));
        }
        JsonArray jsonArrayresults = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESULTS);
        for (int i = 0; i < jsonArrayresults.size(); ++i) {
            OtfDiffEntry.validateJsonElement(jsonArrayresults.get(i));
        }
    }

    public static OtfDiffList fromJson(String jsonString) throws IOException {
        return (OtfDiffList)JSON.getGson().fromJson(jsonString, OtfDiffList.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DIFF_TYPE);
        openapiFields.add(SERIALIZED_NAME_RESULTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RESULTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!OtfDiffList.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OtfDiffList.class));
            return new TypeAdapter<OtfDiffList>(){

                public void write(JsonWriter out, OtfDiffList value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public OtfDiffList read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    OtfDiffList.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    OtfDiffList instance = (OtfDiffList)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DiffTypeEnum {
        CREATED("created"),
        DROPPED("dropped"),
        CHANGED("changed");

        private String value;

        private DiffTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DiffTypeEnum fromValue(String value) {
            for (DiffTypeEnum b : DiffTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DiffTypeEnum> {
            public void write(JsonWriter jsonWriter, DiffTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DiffTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DiffTypeEnum.fromValue(value);
            }
        }
    }
}

