/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.sdk.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Statement {
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    private EffectEnum effect;
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    private String resource;
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private List<String> action = new ArrayList<String>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Statement effect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    @Nonnull
    public EffectEnum getEffect() {
        return this.effect;
    }

    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public Statement resource(String resource) {
        this.resource = resource;
        return this;
    }

    @Nonnull
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Statement action(List<String> action) {
        this.action = action;
        return this;
    }

    public Statement addActionItem(String actionItem) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        this.action.add(actionItem);
        return this;
    }

    @Nonnull
    public List<String> getAction() {
        return this.action;
    }

    public void setAction(List<String> action) {
        this.action = action;
    }

    public Statement putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement statement = (Statement)o;
        return Objects.equals((Object)this.effect, (Object)statement.effect) && Objects.equals(this.resource, statement.resource) && Objects.equals(this.action, statement.action) && Objects.equals(this.additionalProperties, statement.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.effect, this.resource, this.action, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Statement {\n");
        sb.append("    effect: ").append(this.toIndentedString((Object)this.effect)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Statement is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_EFFECT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `effect` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EFFECT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resource` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTION) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_ACTION).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `action` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTION).toString()));
        }
    }

    public static Statement fromJson(String jsonString) throws IOException {
        return (Statement)JSON.getGson().fromJson(jsonString, Statement.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EFFECT);
        openapiFields.add(SERIALIZED_NAME_RESOURCE);
        openapiFields.add(SERIALIZED_NAME_ACTION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EFFECT);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE);
        openapiRequiredFields.add(SERIALIZED_NAME_ACTION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Statement.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Statement.class));
            return new TypeAdapter<Statement>(){

                public void write(JsonWriter out, Statement value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Statement read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Statement.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    Statement instance = (Statement)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EffectEnum {
        ALLOW("allow"),
        DENY("deny");

        private String value;

        private EffectEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EffectEnum fromValue(String value) {
            for (EffectEnum b : EffectEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EffectEnum> {
            public void write(JsonWriter jsonWriter, EffectEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EffectEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EffectEnum.fromValue(value);
            }
        }
    }
}

