/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.ImportCreation;
import io.lakefs.clients.sdk.model.ImportCreationResponse;
import io.lakefs.clients.sdk.model.ImportStatus;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ImportApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ImportApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImportApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call importCancelCall(String repository, String branch, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/import".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importCancelValidateBeforeCall(String repository, String branch, String id, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling importCancel(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling importCancel(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling importCancel(Async)");
        }
        return this.importCancelCall(repository, branch, id, _callback);
    }

    private ApiResponse<Void> importCancelWithHttpInfo(String repository, String branch, String id) throws ApiException {
        Call localVarCall = this.importCancelValidateBeforeCall(repository, branch, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call importCancelAsync(String repository, String branch, String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.importCancelValidateBeforeCall(repository, branch, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimportCancelRequest importCancel(String repository, String branch, String id) {
        return new APIimportCancelRequest(repository, branch, id);
    }

    private Call importStartCall(String repository, String branch, ImportCreation importCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ImportCreation localVarPostBody = importCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/import".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importStartValidateBeforeCall(String repository, String branch, ImportCreation importCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling importStart(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling importStart(Async)");
        }
        if (importCreation == null) {
            throw new ApiException("Missing the required parameter 'importCreation' when calling importStart(Async)");
        }
        return this.importStartCall(repository, branch, importCreation, _callback);
    }

    private ApiResponse<ImportCreationResponse> importStartWithHttpInfo(String repository, String branch, ImportCreation importCreation) throws ApiException {
        Call localVarCall = this.importStartValidateBeforeCall(repository, branch, importCreation, null);
        Type localVarReturnType = new TypeToken<ImportCreationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call importStartAsync(String repository, String branch, ImportCreation importCreation, ApiCallback<ImportCreationResponse> _callback) throws ApiException {
        Call localVarCall = this.importStartValidateBeforeCall(repository, branch, importCreation, _callback);
        Type localVarReturnType = new TypeToken<ImportCreationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimportStartRequest importStart(String repository, String branch, ImportCreation importCreation) {
        return new APIimportStartRequest(repository, branch, importCreation);
    }

    private Call importStatusCall(String repository, String branch, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/import".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call importStatusValidateBeforeCall(String repository, String branch, String id, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling importStatus(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling importStatus(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling importStatus(Async)");
        }
        return this.importStatusCall(repository, branch, id, _callback);
    }

    private ApiResponse<ImportStatus> importStatusWithHttpInfo(String repository, String branch, String id) throws ApiException {
        Call localVarCall = this.importStatusValidateBeforeCall(repository, branch, id, null);
        Type localVarReturnType = new TypeToken<ImportStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call importStatusAsync(String repository, String branch, String id, ApiCallback<ImportStatus> _callback) throws ApiException {
        Call localVarCall = this.importStatusValidateBeforeCall(repository, branch, id, _callback);
        Type localVarReturnType = new TypeToken<ImportStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIimportStatusRequest importStatus(String repository, String branch, String id) {
        return new APIimportStatusRequest(repository, branch, id);
    }

    public class APIimportStatusRequest {
        private final String repository;
        private final String branch;
        private final String id;

        private APIimportStatusRequest(String repository, String branch, String id) {
            this.repository = repository;
            this.branch = branch;
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImportApi.this.importStatusCall(this.repository, this.branch, this.id, _callback);
        }

        public ImportStatus execute() throws ApiException {
            ApiResponse localVarResp = ImportApi.this.importStatusWithHttpInfo(this.repository, this.branch, this.id);
            return (ImportStatus)localVarResp.getData();
        }

        public ApiResponse<ImportStatus> executeWithHttpInfo() throws ApiException {
            return ImportApi.this.importStatusWithHttpInfo(this.repository, this.branch, this.id);
        }

        public Call executeAsync(ApiCallback<ImportStatus> _callback) throws ApiException {
            return ImportApi.this.importStatusAsync(this.repository, this.branch, this.id, _callback);
        }
    }

    public class APIimportStartRequest {
        private final String repository;
        private final String branch;
        private final ImportCreation importCreation;

        private APIimportStartRequest(String repository, String branch, ImportCreation importCreation) {
            this.repository = repository;
            this.branch = branch;
            this.importCreation = importCreation;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImportApi.this.importStartCall(this.repository, this.branch, this.importCreation, _callback);
        }

        public ImportCreationResponse execute() throws ApiException {
            ApiResponse localVarResp = ImportApi.this.importStartWithHttpInfo(this.repository, this.branch, this.importCreation);
            return (ImportCreationResponse)localVarResp.getData();
        }

        public ApiResponse<ImportCreationResponse> executeWithHttpInfo() throws ApiException {
            return ImportApi.this.importStartWithHttpInfo(this.repository, this.branch, this.importCreation);
        }

        public Call executeAsync(ApiCallback<ImportCreationResponse> _callback) throws ApiException {
            return ImportApi.this.importStartAsync(this.repository, this.branch, this.importCreation, _callback);
        }
    }

    public class APIimportCancelRequest {
        private final String repository;
        private final String branch;
        private final String id;

        private APIimportCancelRequest(String repository, String branch, String id) {
            this.repository = repository;
            this.branch = branch;
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImportApi.this.importCancelCall(this.repository, this.branch, this.id, _callback);
        }

        public void execute() throws ApiException {
            ImportApi.this.importCancelWithHttpInfo(this.repository, this.branch, this.id);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ImportApi.this.importCancelWithHttpInfo(this.repository, this.branch, this.id);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ImportApi.this.importCancelAsync(this.repository, this.branch, this.id, _callback);
        }
    }
}

