/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.sdk.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.lakefs.clients.sdk.JSON;

/**
 * LoginConfig
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class LoginConfig {
  /**
   * RBAC will remain enabled on GUI if \&quot;external\&quot;.  That only works with an external auth service. 
   */
  @JsonAdapter(RBACEnum.Adapter.class)
  public enum RBACEnum {
    SIMPLIFIED("simplified"),
    
    EXTERNAL("external");

    private String value;

    RBACEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RBACEnum fromValue(String value) {
      for (RBACEnum b : RBACEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RBACEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RBACEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RBACEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RBACEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_R_B_A_C = "RBAC";
  @SerializedName(SERIALIZED_NAME_R_B_A_C)
  private RBACEnum RBAC;

  public static final String SERIALIZED_NAME_LOGIN_URL = "login_url";
  @SerializedName(SERIALIZED_NAME_LOGIN_URL)
  private String loginUrl;

  public static final String SERIALIZED_NAME_LOGIN_FAILED_MESSAGE = "login_failed_message";
  @SerializedName(SERIALIZED_NAME_LOGIN_FAILED_MESSAGE)
  private String loginFailedMessage;

  public static final String SERIALIZED_NAME_FALLBACK_LOGIN_URL = "fallback_login_url";
  @SerializedName(SERIALIZED_NAME_FALLBACK_LOGIN_URL)
  private String fallbackLoginUrl;

  public static final String SERIALIZED_NAME_FALLBACK_LOGIN_LABEL = "fallback_login_label";
  @SerializedName(SERIALIZED_NAME_FALLBACK_LOGIN_LABEL)
  private String fallbackLoginLabel;

  public static final String SERIALIZED_NAME_LOGIN_COOKIE_NAMES = "login_cookie_names";
  @SerializedName(SERIALIZED_NAME_LOGIN_COOKIE_NAMES)
  private List<String> loginCookieNames = new ArrayList<>();

  public static final String SERIALIZED_NAME_LOGOUT_URL = "logout_url";
  @SerializedName(SERIALIZED_NAME_LOGOUT_URL)
  private String logoutUrl;

  public LoginConfig() {
  }

  public LoginConfig RBAC(RBACEnum RBAC) {
    
    this.RBAC = RBAC;
    return this;
  }

   /**
   * RBAC will remain enabled on GUI if \&quot;external\&quot;.  That only works with an external auth service. 
   * @return RBAC
  **/
  @javax.annotation.Nullable
  public RBACEnum getRBAC() {
    return RBAC;
  }


  public void setRBAC(RBACEnum RBAC) {
    this.RBAC = RBAC;
  }


  public LoginConfig loginUrl(String loginUrl) {
    
    this.loginUrl = loginUrl;
    return this;
  }

   /**
   * primary URL to use for login.
   * @return loginUrl
  **/
  @javax.annotation.Nonnull
  public String getLoginUrl() {
    return loginUrl;
  }


  public void setLoginUrl(String loginUrl) {
    this.loginUrl = loginUrl;
  }


  public LoginConfig loginFailedMessage(String loginFailedMessage) {
    
    this.loginFailedMessage = loginFailedMessage;
    return this;
  }

   /**
   * message to display to users who fail to login; a full sentence that is rendered in HTML and may contain a link to a secondary login method 
   * @return loginFailedMessage
  **/
  @javax.annotation.Nullable
  public String getLoginFailedMessage() {
    return loginFailedMessage;
  }


  public void setLoginFailedMessage(String loginFailedMessage) {
    this.loginFailedMessage = loginFailedMessage;
  }


  public LoginConfig fallbackLoginUrl(String fallbackLoginUrl) {
    
    this.fallbackLoginUrl = fallbackLoginUrl;
    return this;
  }

   /**
   * secondary URL to offer users to use for login.
   * @return fallbackLoginUrl
  **/
  @javax.annotation.Nullable
  public String getFallbackLoginUrl() {
    return fallbackLoginUrl;
  }


  public void setFallbackLoginUrl(String fallbackLoginUrl) {
    this.fallbackLoginUrl = fallbackLoginUrl;
  }


  public LoginConfig fallbackLoginLabel(String fallbackLoginLabel) {
    
    this.fallbackLoginLabel = fallbackLoginLabel;
    return this;
  }

   /**
   * label to place on fallback_login_url.
   * @return fallbackLoginLabel
  **/
  @javax.annotation.Nullable
  public String getFallbackLoginLabel() {
    return fallbackLoginLabel;
  }


  public void setFallbackLoginLabel(String fallbackLoginLabel) {
    this.fallbackLoginLabel = fallbackLoginLabel;
  }


  public LoginConfig loginCookieNames(List<String> loginCookieNames) {
    
    this.loginCookieNames = loginCookieNames;
    return this;
  }

  public LoginConfig addLoginCookieNamesItem(String loginCookieNamesItem) {
    if (this.loginCookieNames == null) {
      this.loginCookieNames = new ArrayList<>();
    }
    this.loginCookieNames.add(loginCookieNamesItem);
    return this;
  }

   /**
   * cookie names used to store JWT
   * @return loginCookieNames
  **/
  @javax.annotation.Nonnull
  public List<String> getLoginCookieNames() {
    return loginCookieNames;
  }


  public void setLoginCookieNames(List<String> loginCookieNames) {
    this.loginCookieNames = loginCookieNames;
  }


  public LoginConfig logoutUrl(String logoutUrl) {
    
    this.logoutUrl = logoutUrl;
    return this;
  }

   /**
   * URL to use for logging out.
   * @return logoutUrl
  **/
  @javax.annotation.Nonnull
  public String getLogoutUrl() {
    return logoutUrl;
  }


  public void setLogoutUrl(String logoutUrl) {
    this.logoutUrl = logoutUrl;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the LoginConfig instance itself
   */
  public LoginConfig putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoginConfig loginConfig = (LoginConfig) o;
    return Objects.equals(this.RBAC, loginConfig.RBAC) &&
        Objects.equals(this.loginUrl, loginConfig.loginUrl) &&
        Objects.equals(this.loginFailedMessage, loginConfig.loginFailedMessage) &&
        Objects.equals(this.fallbackLoginUrl, loginConfig.fallbackLoginUrl) &&
        Objects.equals(this.fallbackLoginLabel, loginConfig.fallbackLoginLabel) &&
        Objects.equals(this.loginCookieNames, loginConfig.loginCookieNames) &&
        Objects.equals(this.logoutUrl, loginConfig.logoutUrl)&&
        Objects.equals(this.additionalProperties, loginConfig.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(RBAC, loginUrl, loginFailedMessage, fallbackLoginUrl, fallbackLoginLabel, loginCookieNames, logoutUrl, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoginConfig {\n");
    sb.append("    RBAC: ").append(toIndentedString(RBAC)).append("\n");
    sb.append("    loginUrl: ").append(toIndentedString(loginUrl)).append("\n");
    sb.append("    loginFailedMessage: ").append(toIndentedString(loginFailedMessage)).append("\n");
    sb.append("    fallbackLoginUrl: ").append(toIndentedString(fallbackLoginUrl)).append("\n");
    sb.append("    fallbackLoginLabel: ").append(toIndentedString(fallbackLoginLabel)).append("\n");
    sb.append("    loginCookieNames: ").append(toIndentedString(loginCookieNames)).append("\n");
    sb.append("    logoutUrl: ").append(toIndentedString(logoutUrl)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("RBAC");
    openapiFields.add("login_url");
    openapiFields.add("login_failed_message");
    openapiFields.add("fallback_login_url");
    openapiFields.add("fallback_login_label");
    openapiFields.add("login_cookie_names");
    openapiFields.add("logout_url");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("login_url");
    openapiRequiredFields.add("login_cookie_names");
    openapiRequiredFields.add("logout_url");
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to LoginConfig
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!LoginConfig.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in LoginConfig is not found in the empty JSON string", LoginConfig.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : LoginConfig.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("RBAC") != null && !jsonObj.get("RBAC").isJsonNull()) && !jsonObj.get("RBAC").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `RBAC` to be a primitive type in the JSON string but got `%s`", jsonObj.get("RBAC").toString()));
      }
      if (!jsonObj.get("login_url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `login_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("login_url").toString()));
      }
      if ((jsonObj.get("login_failed_message") != null && !jsonObj.get("login_failed_message").isJsonNull()) && !jsonObj.get("login_failed_message").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `login_failed_message` to be a primitive type in the JSON string but got `%s`", jsonObj.get("login_failed_message").toString()));
      }
      if ((jsonObj.get("fallback_login_url") != null && !jsonObj.get("fallback_login_url").isJsonNull()) && !jsonObj.get("fallback_login_url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `fallback_login_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fallback_login_url").toString()));
      }
      if ((jsonObj.get("fallback_login_label") != null && !jsonObj.get("fallback_login_label").isJsonNull()) && !jsonObj.get("fallback_login_label").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `fallback_login_label` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fallback_login_label").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("login_cookie_names") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("login_cookie_names").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `login_cookie_names` to be an array in the JSON string but got `%s`", jsonObj.get("login_cookie_names").toString()));
      }
      if (!jsonObj.get("logout_url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `logout_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("logout_url").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!LoginConfig.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'LoginConfig' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<LoginConfig> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(LoginConfig.class));

       return (TypeAdapter<T>) new TypeAdapter<LoginConfig>() {
           @Override
           public void write(JsonWriter out, LoginConfig value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additional properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public LoginConfig read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             JsonObject jsonObj = jsonElement.getAsJsonObject();
             // store additional fields in the deserialized instance
             LoginConfig instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of LoginConfig given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of LoginConfig
  * @throws IOException if the JSON string is invalid with respect to LoginConfig
  */
  public static LoginConfig fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, LoginConfig.class);
  }

 /**
  * Convert an instance of LoginConfig to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

