/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.Ref;
import io.lakefs.clients.sdk.model.RefList;
import io.lakefs.clients.sdk.model.TagCreation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TagsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createTagCall(String repository, TagCreation tagCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TagCreation localVarPostBody = tagCreation;
        String localVarPath = "/repositories/{repository}/tags".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTagValidateBeforeCall(String repository, TagCreation tagCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createTag(Async)");
        }
        if (tagCreation == null) {
            throw new ApiException("Missing the required parameter 'tagCreation' when calling createTag(Async)");
        }
        return this.createTagCall(repository, tagCreation, _callback);
    }

    private ApiResponse<Ref> createTagWithHttpInfo(String repository, TagCreation tagCreation) throws ApiException {
        Call localVarCall = this.createTagValidateBeforeCall(repository, tagCreation, null);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createTagAsync(String repository, TagCreation tagCreation, ApiCallback<Ref> _callback) throws ApiException {
        Call localVarCall = this.createTagValidateBeforeCall(repository, tagCreation, _callback);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateTagRequest createTag(String repository, TagCreation tagCreation) {
        return new APIcreateTagRequest(repository, tagCreation);
    }

    private Call deleteTagCall(String repository, String tag, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/tags/{tag}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{tag}", this.localVarApiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTagValidateBeforeCall(String repository, String tag, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteTag(Async)");
        }
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling deleteTag(Async)");
        }
        return this.deleteTagCall(repository, tag, _callback);
    }

    private ApiResponse<Void> deleteTagWithHttpInfo(String repository, String tag) throws ApiException {
        Call localVarCall = this.deleteTagValidateBeforeCall(repository, tag, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteTagAsync(String repository, String tag, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTagValidateBeforeCall(repository, tag, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteTagRequest deleteTag(String repository, String tag) {
        return new APIdeleteTagRequest(repository, tag);
    }

    private Call getTagCall(String repository, String tag, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/tags/{tag}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{tag}", this.localVarApiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTagValidateBeforeCall(String repository, String tag, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getTag(Async)");
        }
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling getTag(Async)");
        }
        return this.getTagCall(repository, tag, _callback);
    }

    private ApiResponse<Ref> getTagWithHttpInfo(String repository, String tag) throws ApiException {
        Call localVarCall = this.getTagValidateBeforeCall(repository, tag, null);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTagAsync(String repository, String tag, ApiCallback<Ref> _callback) throws ApiException {
        Call localVarCall = this.getTagValidateBeforeCall(repository, tag, _callback);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetTagRequest getTag(String repository, String tag) {
        return new APIgetTagRequest(repository, tag);
    }

    private Call listTagsCall(String repository, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/tags".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTagsValidateBeforeCall(String repository, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listTags(Async)");
        }
        return this.listTagsCall(repository, prefix, after, amount, _callback);
    }

    private ApiResponse<RefList> listTagsWithHttpInfo(String repository, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listTagsValidateBeforeCall(repository, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<RefList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listTagsAsync(String repository, String prefix, String after, Integer amount, ApiCallback<RefList> _callback) throws ApiException {
        Call localVarCall = this.listTagsValidateBeforeCall(repository, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<RefList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistTagsRequest listTags(String repository) {
        return new APIlistTagsRequest(repository);
    }

    public class APIlistTagsRequest {
        private final String repository;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistTagsRequest(String repository) {
            this.repository = repository;
        }

        public APIlistTagsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistTagsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistTagsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TagsApi.this.listTagsCall(this.repository, this.prefix, this.after, this.amount, _callback);
        }

        public RefList execute() throws ApiException {
            ApiResponse localVarResp = TagsApi.this.listTagsWithHttpInfo(this.repository, this.prefix, this.after, this.amount);
            return (RefList)localVarResp.getData();
        }

        public ApiResponse<RefList> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.listTagsWithHttpInfo(this.repository, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<RefList> _callback) throws ApiException {
            return TagsApi.this.listTagsAsync(this.repository, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIgetTagRequest {
        private final String repository;
        private final String tag;

        private APIgetTagRequest(String repository, String tag) {
            this.repository = repository;
            this.tag = tag;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TagsApi.this.getTagCall(this.repository, this.tag, _callback);
        }

        public Ref execute() throws ApiException {
            ApiResponse localVarResp = TagsApi.this.getTagWithHttpInfo(this.repository, this.tag);
            return (Ref)localVarResp.getData();
        }

        public ApiResponse<Ref> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.getTagWithHttpInfo(this.repository, this.tag);
        }

        public Call executeAsync(ApiCallback<Ref> _callback) throws ApiException {
            return TagsApi.this.getTagAsync(this.repository, this.tag, _callback);
        }
    }

    public class APIdeleteTagRequest {
        private final String repository;
        private final String tag;

        private APIdeleteTagRequest(String repository, String tag) {
            this.repository = repository;
            this.tag = tag;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TagsApi.this.deleteTagCall(this.repository, this.tag, _callback);
        }

        public void execute() throws ApiException {
            TagsApi.this.deleteTagWithHttpInfo(this.repository, this.tag);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.deleteTagWithHttpInfo(this.repository, this.tag);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return TagsApi.this.deleteTagAsync(this.repository, this.tag, _callback);
        }
    }

    public class APIcreateTagRequest {
        private final String repository;
        private final TagCreation tagCreation;

        private APIcreateTagRequest(String repository, TagCreation tagCreation) {
            this.repository = repository;
            this.tagCreation = tagCreation;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return TagsApi.this.createTagCall(this.repository, this.tagCreation, _callback);
        }

        public Ref execute() throws ApiException {
            ApiResponse localVarResp = TagsApi.this.createTagWithHttpInfo(this.repository, this.tagCreation);
            return (Ref)localVarResp.getData();
        }

        public ApiResponse<Ref> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.createTagWithHttpInfo(this.repository, this.tagCreation);
        }

        public Call executeAsync(ApiCallback<Ref> _callback) throws ApiException {
            return TagsApi.this.createTagAsync(this.repository, this.tagCreation, _callback);
        }
    }
}

