/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.sdk.JSON;
import io.lakefs.clients.sdk.model.UploadPart;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompletePresignMultipartUpload {
    public static final String SERIALIZED_NAME_PHYSICAL_ADDRESS = "physical_address";
    @SerializedName(value="physical_address")
    private String physicalAddress;
    public static final String SERIALIZED_NAME_PARTS = "parts";
    @SerializedName(value="parts")
    private List<UploadPart> parts = new ArrayList<UploadPart>();
    public static final String SERIALIZED_NAME_USER_METADATA = "user_metadata";
    @SerializedName(value="user_metadata")
    private Map<String, String> userMetadata = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private String contentType;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CompletePresignMultipartUpload physicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
        return this;
    }

    @Nonnull
    public String getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public CompletePresignMultipartUpload parts(List<UploadPart> parts) {
        this.parts = parts;
        return this;
    }

    public CompletePresignMultipartUpload addPartsItem(UploadPart partsItem) {
        if (this.parts == null) {
            this.parts = new ArrayList<UploadPart>();
        }
        this.parts.add(partsItem);
        return this;
    }

    @Nonnull
    public List<UploadPart> getParts() {
        return this.parts;
    }

    public void setParts(List<UploadPart> parts) {
        this.parts = parts;
    }

    public CompletePresignMultipartUpload userMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public CompletePresignMultipartUpload putUserMetadataItem(String key, String userMetadataItem) {
        if (this.userMetadata == null) {
            this.userMetadata = new HashMap<String, String>();
        }
        this.userMetadata.put(key, userMetadataItem);
        return this;
    }

    @Nullable
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public CompletePresignMultipartUpload contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public CompletePresignMultipartUpload putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletePresignMultipartUpload completePresignMultipartUpload = (CompletePresignMultipartUpload)o;
        return Objects.equals(this.physicalAddress, completePresignMultipartUpload.physicalAddress) && Objects.equals(this.parts, completePresignMultipartUpload.parts) && Objects.equals(this.userMetadata, completePresignMultipartUpload.userMetadata) && Objects.equals(this.contentType, completePresignMultipartUpload.contentType) && Objects.equals(this.additionalProperties, completePresignMultipartUpload.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.physicalAddress, this.parts, this.userMetadata, this.contentType, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompletePresignMultipartUpload {\n");
        sb.append("    physicalAddress: ").append(this.toIndentedString(this.physicalAddress)).append("\n");
        sb.append("    parts: ").append(this.toIndentedString(this.parts)).append("\n");
        sb.append("    userMetadata: ").append(this.toIndentedString(this.userMetadata)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CompletePresignMultipartUpload is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_PHYSICAL_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `physical_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHYSICAL_ADDRESS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PARTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `parts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARTS).toString()));
        }
        JsonArray jsonArrayparts = jsonObj.getAsJsonArray(SERIALIZED_NAME_PARTS);
        for (int i = 0; i < jsonArrayparts.size(); ++i) {
            UploadPart.validateJsonElement(jsonArrayparts.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).toString()));
        }
    }

    public static CompletePresignMultipartUpload fromJson(String jsonString) throws IOException {
        return (CompletePresignMultipartUpload)JSON.getGson().fromJson(jsonString, CompletePresignMultipartUpload.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PHYSICAL_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_PARTS);
        openapiFields.add(SERIALIZED_NAME_USER_METADATA);
        openapiFields.add(SERIALIZED_NAME_CONTENT_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PHYSICAL_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_PARTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CompletePresignMultipartUpload.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CompletePresignMultipartUpload.class));
            return new TypeAdapter<CompletePresignMultipartUpload>(){

                public void write(JsonWriter out, CompletePresignMultipartUpload value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public CompletePresignMultipartUpload read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CompletePresignMultipartUpload.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    CompletePresignMultipartUpload instance = (CompletePresignMultipartUpload)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

