/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.StagingLocation;
import io.lakefs.clients.sdk.model.StagingMetadata;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class StagingApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public StagingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StagingApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getPhysicalAddressCall(String repository, String branch, String path, Boolean presign, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/backing".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (presign != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("presign", presign));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPhysicalAddressValidateBeforeCall(String repository, String branch, String path, Boolean presign, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getPhysicalAddress(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling getPhysicalAddress(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getPhysicalAddress(Async)");
        }
        return this.getPhysicalAddressCall(repository, branch, path, presign, _callback);
    }

    private ApiResponse<StagingLocation> getPhysicalAddressWithHttpInfo(String repository, String branch, String path, Boolean presign) throws ApiException {
        Call localVarCall = this.getPhysicalAddressValidateBeforeCall(repository, branch, path, presign, null);
        Type localVarReturnType = new TypeToken<StagingLocation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPhysicalAddressAsync(String repository, String branch, String path, Boolean presign, ApiCallback<StagingLocation> _callback) throws ApiException {
        Call localVarCall = this.getPhysicalAddressValidateBeforeCall(repository, branch, path, presign, _callback);
        Type localVarReturnType = new TypeToken<StagingLocation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetPhysicalAddressRequest getPhysicalAddress(String repository, String branch, String path) {
        return new APIgetPhysicalAddressRequest(repository, branch, path);
    }

    private Call linkPhysicalAddressCall(String repository, String branch, String path, StagingMetadata stagingMetadata, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StagingMetadata localVarPostBody = stagingMetadata;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/backing".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call linkPhysicalAddressValidateBeforeCall(String repository, String branch, String path, StagingMetadata stagingMetadata, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling linkPhysicalAddress(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling linkPhysicalAddress(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling linkPhysicalAddress(Async)");
        }
        if (stagingMetadata == null) {
            throw new ApiException("Missing the required parameter 'stagingMetadata' when calling linkPhysicalAddress(Async)");
        }
        return this.linkPhysicalAddressCall(repository, branch, path, stagingMetadata, ifNoneMatch, _callback);
    }

    private ApiResponse<ObjectStats> linkPhysicalAddressWithHttpInfo(String repository, String branch, String path, StagingMetadata stagingMetadata, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.linkPhysicalAddressValidateBeforeCall(repository, branch, path, stagingMetadata, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call linkPhysicalAddressAsync(String repository, String branch, String path, StagingMetadata stagingMetadata, String ifNoneMatch, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.linkPhysicalAddressValidateBeforeCall(repository, branch, path, stagingMetadata, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlinkPhysicalAddressRequest linkPhysicalAddress(String repository, String branch, String path, StagingMetadata stagingMetadata) {
        return new APIlinkPhysicalAddressRequest(repository, branch, path, stagingMetadata);
    }

    public class APIlinkPhysicalAddressRequest {
        private final String repository;
        private final String branch;
        private final String path;
        private final StagingMetadata stagingMetadata;
        private String ifNoneMatch;

        private APIlinkPhysicalAddressRequest(String repository, String branch, String path, StagingMetadata stagingMetadata) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
            this.stagingMetadata = stagingMetadata;
        }

        public APIlinkPhysicalAddressRequest ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StagingApi.this.linkPhysicalAddressCall(this.repository, this.branch, this.path, this.stagingMetadata, this.ifNoneMatch, _callback);
        }

        public ObjectStats execute() throws ApiException {
            ApiResponse localVarResp = StagingApi.this.linkPhysicalAddressWithHttpInfo(this.repository, this.branch, this.path, this.stagingMetadata, this.ifNoneMatch);
            return (ObjectStats)localVarResp.getData();
        }

        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return StagingApi.this.linkPhysicalAddressWithHttpInfo(this.repository, this.branch, this.path, this.stagingMetadata, this.ifNoneMatch);
        }

        public Call executeAsync(ApiCallback<ObjectStats> _callback) throws ApiException {
            return StagingApi.this.linkPhysicalAddressAsync(this.repository, this.branch, this.path, this.stagingMetadata, this.ifNoneMatch, _callback);
        }
    }

    public class APIgetPhysicalAddressRequest {
        private final String repository;
        private final String branch;
        private final String path;
        private Boolean presign;

        private APIgetPhysicalAddressRequest(String repository, String branch, String path) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
        }

        public APIgetPhysicalAddressRequest presign(Boolean presign) {
            this.presign = presign;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StagingApi.this.getPhysicalAddressCall(this.repository, this.branch, this.path, this.presign, _callback);
        }

        public StagingLocation execute() throws ApiException {
            ApiResponse localVarResp = StagingApi.this.getPhysicalAddressWithHttpInfo(this.repository, this.branch, this.path, this.presign);
            return (StagingLocation)localVarResp.getData();
        }

        public ApiResponse<StagingLocation> executeWithHttpInfo() throws ApiException {
            return StagingApi.this.getPhysicalAddressWithHttpInfo(this.repository, this.branch, this.path, this.presign);
        }

        public Call executeAsync(ApiCallback<StagingLocation> _callback) throws ApiException {
            return StagingApi.this.getPhysicalAddressAsync(this.repository, this.branch, this.path, this.presign, _callback);
        }
    }
}

