/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.sdk;

import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.ProgressRequestBody;
import io.lakefs.clients.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.lakefs.clients.sdk.model.AbortPresignMultipartUpload;
import io.lakefs.clients.sdk.model.AuthenticationToken;
import io.lakefs.clients.sdk.model.CompletePresignMultipartUpload;
import io.lakefs.clients.sdk.model.Error;
import io.lakefs.clients.sdk.model.ExternalLoginInformation;
import io.lakefs.clients.sdk.model.ExternalPrincipal;
import io.lakefs.clients.sdk.model.ExternalPrincipalCreation;
import io.lakefs.clients.sdk.model.ExternalPrincipalList;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.PresignMultipartUpload;
import io.lakefs.clients.sdk.model.StagingLocation;
import io.lakefs.clients.sdk.model.StsAuthRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExperimentalApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExperimentalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call abortPresignMultipartUploadCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = abortPresignMultipartUpload;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "branch" + "}", localVarApiClient.escapeString(branch.toString()))
            .replace("{" + "uploadId" + "}", localVarApiClient.escapeString(uploadId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call abortPresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling abortPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling abortPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'uploadId' is set
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling abortPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling abortPresignMultipartUpload(Async)");
        }

        return abortPresignMultipartUploadCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);

    }


    private ApiResponse<Void> abortPresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload) throws ApiException {
        okhttp3.Call localVarCall = abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call abortPresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIabortPresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String uploadId;
        private final String path;
        private AbortPresignMultipartUpload abortPresignMultipartUpload;

        private APIabortPresignMultipartUploadRequest(String repository, String branch, String uploadId, String path) {
            this.repository = repository;
            this.branch = branch;
            this.uploadId = uploadId;
            this.path = path;
        }

        /**
         * Set abortPresignMultipartUpload
         * @param abortPresignMultipartUpload  (optional)
         * @return APIabortPresignMultipartUploadRequest
         */
        public APIabortPresignMultipartUploadRequest abortPresignMultipartUpload(AbortPresignMultipartUpload abortPresignMultipartUpload) {
            this.abortPresignMultipartUpload = abortPresignMultipartUpload;
            return this;
        }

        /**
         * Build call for abortPresignMultipartUpload
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return abortPresignMultipartUploadCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        }

        /**
         * Execute abortPresignMultipartUpload request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            abortPresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, abortPresignMultipartUpload);
        }

        /**
         * Execute abortPresignMultipartUpload request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return abortPresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, abortPresignMultipartUpload);
        }

        /**
         * Execute abortPresignMultipartUpload request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return abortPresignMultipartUploadAsync(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        }
    }

    /**
     * Abort a presign multipart upload
     * Aborts a presign multipart upload.
     * @param repository  (required)
     * @param branch  (required)
     * @param uploadId  (required)
     * @param path relative to the branch (required)
     * @return APIabortPresignMultipartUploadRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Presign multipart upload aborted </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIabortPresignMultipartUploadRequest abortPresignMultipartUpload(String repository, String branch, String uploadId, String path) {
        return new APIabortPresignMultipartUploadRequest(repository, branch, uploadId, path);
    }
    private okhttp3.Call completePresignMultipartUploadCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = completePresignMultipartUpload;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "branch" + "}", localVarApiClient.escapeString(branch.toString()))
            .replace("{" + "uploadId" + "}", localVarApiClient.escapeString(uploadId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call completePresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling completePresignMultipartUpload(Async)");
        }

        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling completePresignMultipartUpload(Async)");
        }

        // verify the required parameter 'uploadId' is set
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling completePresignMultipartUpload(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling completePresignMultipartUpload(Async)");
        }

        return completePresignMultipartUploadCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);

    }


    private ApiResponse<ObjectStats> completePresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload) throws ApiException {
        okhttp3.Call localVarCall = completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call completePresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, final ApiCallback<ObjectStats> _callback) throws ApiException {

        okhttp3.Call localVarCall = completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcompletePresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String uploadId;
        private final String path;
        private CompletePresignMultipartUpload completePresignMultipartUpload;

        private APIcompletePresignMultipartUploadRequest(String repository, String branch, String uploadId, String path) {
            this.repository = repository;
            this.branch = branch;
            this.uploadId = uploadId;
            this.path = path;
        }

        /**
         * Set completePresignMultipartUpload
         * @param completePresignMultipartUpload  (optional)
         * @return APIcompletePresignMultipartUploadRequest
         */
        public APIcompletePresignMultipartUploadRequest completePresignMultipartUpload(CompletePresignMultipartUpload completePresignMultipartUpload) {
            this.completePresignMultipartUpload = completePresignMultipartUpload;
            return this;
        }

        /**
         * Build call for completePresignMultipartUpload
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return completePresignMultipartUploadCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        }

        /**
         * Execute completePresignMultipartUpload request
         * @return ObjectStats
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ObjectStats execute() throws ApiException {
            ApiResponse<ObjectStats> localVarResp = completePresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, completePresignMultipartUpload);
            return localVarResp.getData();
        }

        /**
         * Execute completePresignMultipartUpload request with HTTP info returned
         * @return ApiResponse&lt;ObjectStats&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return completePresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, completePresignMultipartUpload);
        }

        /**
         * Execute completePresignMultipartUpload request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ObjectStats> _callback) throws ApiException {
            return completePresignMultipartUploadAsync(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        }
    }

    /**
     * Complete a presign multipart upload request
     * Completes a presign multipart upload by assembling the uploaded parts.
     * @param repository  (required)
     * @param branch  (required)
     * @param uploadId  (required)
     * @param path relative to the branch (required)
     * @return APIcompletePresignMultipartUploadRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Presign multipart upload completed </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> conflict with a commit, try here </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcompletePresignMultipartUploadRequest completePresignMultipartUpload(String repository, String branch, String uploadId, String path) {
        return new APIcompletePresignMultipartUploadRequest(repository, branch, uploadId, path);
    }
    private okhttp3.Call createPresignMultipartUploadCall(String repository, String branch, String path, Integer parts, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "branch" + "}", localVarApiClient.escapeString(branch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (path != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("path", path));
        }

        if (parts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("parts", parts));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createPresignMultipartUploadValidateBeforeCall(String repository, String branch, String path, Integer parts, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createPresignMultipartUpload(Async)");
        }

        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling createPresignMultipartUpload(Async)");
        }

        return createPresignMultipartUploadCall(repository, branch, path, parts, _callback);

    }


    private ApiResponse<PresignMultipartUpload> createPresignMultipartUploadWithHttpInfo(String repository, String branch, String path, Integer parts) throws ApiException {
        okhttp3.Call localVarCall = createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, null);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call createPresignMultipartUploadAsync(String repository, String branch, String path, Integer parts, final ApiCallback<PresignMultipartUpload> _callback) throws ApiException {

        okhttp3.Call localVarCall = createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, _callback);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIcreatePresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String path;
        private Integer parts;

        private APIcreatePresignMultipartUploadRequest(String repository, String branch, String path) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
        }

        /**
         * Set parts
         * @param parts number of presigned URL parts required to upload (optional)
         * @return APIcreatePresignMultipartUploadRequest
         */
        public APIcreatePresignMultipartUploadRequest parts(Integer parts) {
            this.parts = parts;
            return this;
        }

        /**
         * Build call for createPresignMultipartUpload
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return createPresignMultipartUploadCall(repository, branch, path, parts, _callback);
        }

        /**
         * Execute createPresignMultipartUpload request
         * @return PresignMultipartUpload
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public PresignMultipartUpload execute() throws ApiException {
            ApiResponse<PresignMultipartUpload> localVarResp = createPresignMultipartUploadWithHttpInfo(repository, branch, path, parts);
            return localVarResp.getData();
        }

        /**
         * Execute createPresignMultipartUpload request with HTTP info returned
         * @return ApiResponse&lt;PresignMultipartUpload&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PresignMultipartUpload> executeWithHttpInfo() throws ApiException {
            return createPresignMultipartUploadWithHttpInfo(repository, branch, path, parts);
        }

        /**
         * Execute createPresignMultipartUpload request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PresignMultipartUpload> _callback) throws ApiException {
            return createPresignMultipartUploadAsync(repository, branch, path, parts, _callback);
        }
    }

    /**
     * Initiate a multipart upload
     * Initiates a multipart upload and returns an upload ID with presigned URLs for each part (optional). Part numbers starts with 1. Each part except the last one has minimum size depends on the underlying blockstore implementation. For example working with S3 blockstore, minimum size is 5MB (excluding the last part). 
     * @param repository  (required)
     * @param branch  (required)
     * @param path relative to the branch (required)
     * @return APIcreatePresignMultipartUploadRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Presign multipart upload initiated </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcreatePresignMultipartUploadRequest createPresignMultipartUpload(String repository, String branch, String path) {
        return new APIcreatePresignMultipartUploadRequest(repository, branch, path);
    }
    private okhttp3.Call createUserExternalPrincipalCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = externalPrincipalCreation;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/external/principals"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (principalId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("principalId", principalId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createUserExternalPrincipal(Async)");
        }

        // verify the required parameter 'principalId' is set
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling createUserExternalPrincipal(Async)");
        }

        return createUserExternalPrincipalCall(userId, principalId, externalPrincipalCreation, _callback);

    }


    private ApiResponse<Void> createUserExternalPrincipalWithHttpInfo(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation) throws ApiException {
        okhttp3.Call localVarCall = createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call createUserExternalPrincipalAsync(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIcreateUserExternalPrincipalRequest {
        private final String userId;
        private final String principalId;
        private ExternalPrincipalCreation externalPrincipalCreation;

        private APIcreateUserExternalPrincipalRequest(String userId, String principalId) {
            this.userId = userId;
            this.principalId = principalId;
        }

        /**
         * Set externalPrincipalCreation
         * @param externalPrincipalCreation  (optional)
         * @return APIcreateUserExternalPrincipalRequest
         */
        public APIcreateUserExternalPrincipalRequest externalPrincipalCreation(ExternalPrincipalCreation externalPrincipalCreation) {
            this.externalPrincipalCreation = externalPrincipalCreation;
            return this;
        }

        /**
         * Build call for createUserExternalPrincipal
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> external principal attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return createUserExternalPrincipalCall(userId, principalId, externalPrincipalCreation, _callback);
        }

        /**
         * Execute createUserExternalPrincipal request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> external principal attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            createUserExternalPrincipalWithHttpInfo(userId, principalId, externalPrincipalCreation);
        }

        /**
         * Execute createUserExternalPrincipal request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> external principal attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return createUserExternalPrincipalWithHttpInfo(userId, principalId, externalPrincipalCreation);
        }

        /**
         * Execute createUserExternalPrincipal request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> external principal attached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return createUserExternalPrincipalAsync(userId, principalId, externalPrincipalCreation, _callback);
        }
    }

    /**
     * attach external principal to user
     * 
     * @param userId  (required)
     * @param principalId  (required)
     * @return APIcreateUserExternalPrincipalRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> external principal attached successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Resource Conflicts With Target </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIcreateUserExternalPrincipalRequest createUserExternalPrincipal(String userId, String principalId) {
        return new APIcreateUserExternalPrincipalRequest(userId, principalId);
    }
    private okhttp3.Call deleteUserExternalPrincipalCall(String userId, String principalId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/external/principals"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (principalId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("principalId", principalId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteUserExternalPrincipalValidateBeforeCall(String userId, String principalId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUserExternalPrincipal(Async)");
        }

        // verify the required parameter 'principalId' is set
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling deleteUserExternalPrincipal(Async)");
        }

        return deleteUserExternalPrincipalCall(userId, principalId, _callback);

    }


    private ApiResponse<Void> deleteUserExternalPrincipalWithHttpInfo(String userId, String principalId) throws ApiException {
        okhttp3.Call localVarCall = deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call deleteUserExternalPrincipalAsync(String userId, String principalId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIdeleteUserExternalPrincipalRequest {
        private final String userId;
        private final String principalId;

        private APIdeleteUserExternalPrincipalRequest(String userId, String principalId) {
            this.userId = userId;
            this.principalId = principalId;
        }

        /**
         * Build call for deleteUserExternalPrincipal
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> external principal detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return deleteUserExternalPrincipalCall(userId, principalId, _callback);
        }

        /**
         * Execute deleteUserExternalPrincipal request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> external principal detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            deleteUserExternalPrincipalWithHttpInfo(userId, principalId);
        }

        /**
         * Execute deleteUserExternalPrincipal request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> external principal detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return deleteUserExternalPrincipalWithHttpInfo(userId, principalId);
        }

        /**
         * Execute deleteUserExternalPrincipal request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> external principal detached successfully </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return deleteUserExternalPrincipalAsync(userId, principalId, _callback);
        }
    }

    /**
     * delete external principal from user
     * 
     * @param userId  (required)
     * @param principalId  (required)
     * @return APIdeleteUserExternalPrincipalRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> external principal detached successfully </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIdeleteUserExternalPrincipalRequest deleteUserExternalPrincipal(String userId, String principalId) {
        return new APIdeleteUserExternalPrincipalRequest(userId, principalId);
    }
    private okhttp3.Call externalPrincipalLoginCall(ExternalLoginInformation externalLoginInformation, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = externalLoginInformation;

        // create path and map variables
        String localVarPath = "/auth/external/principal/login";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call externalPrincipalLoginValidateBeforeCall(ExternalLoginInformation externalLoginInformation, final ApiCallback _callback) throws ApiException {
        return externalPrincipalLoginCall(externalLoginInformation, _callback);

    }


    private ApiResponse<AuthenticationToken> externalPrincipalLoginWithHttpInfo(ExternalLoginInformation externalLoginInformation) throws ApiException {
        okhttp3.Call localVarCall = externalPrincipalLoginValidateBeforeCall(externalLoginInformation, null);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call externalPrincipalLoginAsync(ExternalLoginInformation externalLoginInformation, final ApiCallback<AuthenticationToken> _callback) throws ApiException {

        okhttp3.Call localVarCall = externalPrincipalLoginValidateBeforeCall(externalLoginInformation, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIexternalPrincipalLoginRequest {
        private ExternalLoginInformation externalLoginInformation;

        private APIexternalPrincipalLoginRequest() {
        }

        /**
         * Set externalLoginInformation
         * @param externalLoginInformation  (optional)
         * @return APIexternalPrincipalLoginRequest
         */
        public APIexternalPrincipalLoginRequest externalLoginInformation(ExternalLoginInformation externalLoginInformation) {
            this.externalLoginInformation = externalLoginInformation;
            return this;
        }

        /**
         * Build call for externalPrincipalLogin
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful external login </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return externalPrincipalLoginCall(externalLoginInformation, _callback);
        }

        /**
         * Execute externalPrincipalLogin request
         * @return AuthenticationToken
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful external login </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public AuthenticationToken execute() throws ApiException {
            ApiResponse<AuthenticationToken> localVarResp = externalPrincipalLoginWithHttpInfo(externalLoginInformation);
            return localVarResp.getData();
        }

        /**
         * Execute externalPrincipalLogin request with HTTP info returned
         * @return ApiResponse&lt;AuthenticationToken&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful external login </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<AuthenticationToken> executeWithHttpInfo() throws ApiException {
            return externalPrincipalLoginWithHttpInfo(externalLoginInformation);
        }

        /**
         * Execute externalPrincipalLogin request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful external login </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<AuthenticationToken> _callback) throws ApiException {
            return externalPrincipalLoginAsync(externalLoginInformation, _callback);
        }
    }

    /**
     * perform a login using an external authenticator
     * 
     * @return APIexternalPrincipalLoginRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successful external login </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIexternalPrincipalLoginRequest externalPrincipalLogin() {
        return new APIexternalPrincipalLoginRequest();
    }
    private okhttp3.Call getExternalPrincipalCall(String principalId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/external/principals";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (principalId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("principalId", principalId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getExternalPrincipalValidateBeforeCall(String principalId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'principalId' is set
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling getExternalPrincipal(Async)");
        }

        return getExternalPrincipalCall(principalId, _callback);

    }


    private ApiResponse<ExternalPrincipal> getExternalPrincipalWithHttpInfo(String principalId) throws ApiException {
        okhttp3.Call localVarCall = getExternalPrincipalValidateBeforeCall(principalId, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getExternalPrincipalAsync(String principalId, final ApiCallback<ExternalPrincipal> _callback) throws ApiException {

        okhttp3.Call localVarCall = getExternalPrincipalValidateBeforeCall(principalId, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetExternalPrincipalRequest {
        private final String principalId;

        private APIgetExternalPrincipalRequest(String principalId) {
            this.principalId = principalId;
        }

        /**
         * Build call for getExternalPrincipal
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> external principal </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getExternalPrincipalCall(principalId, _callback);
        }

        /**
         * Execute getExternalPrincipal request
         * @return ExternalPrincipal
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> external principal </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ExternalPrincipal execute() throws ApiException {
            ApiResponse<ExternalPrincipal> localVarResp = getExternalPrincipalWithHttpInfo(principalId);
            return localVarResp.getData();
        }

        /**
         * Execute getExternalPrincipal request with HTTP info returned
         * @return ApiResponse&lt;ExternalPrincipal&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> external principal </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ExternalPrincipal> executeWithHttpInfo() throws ApiException {
            return getExternalPrincipalWithHttpInfo(principalId);
        }

        /**
         * Execute getExternalPrincipal request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> external principal </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ExternalPrincipal> _callback) throws ApiException {
            return getExternalPrincipalAsync(principalId, _callback);
        }
    }

    /**
     * describe external principal by id
     * 
     * @param principalId  (required)
     * @return APIgetExternalPrincipalRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> external principal </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIgetExternalPrincipalRequest getExternalPrincipal(String principalId) {
        return new APIgetExternalPrincipalRequest(principalId);
    }
    private okhttp3.Call hardResetBranchCall(String repository, String branch, String ref, Boolean force, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/branches/{branch}/hard_reset"
            .replace("{" + "repository" + "}", localVarApiClient.escapeString(repository.toString()))
            .replace("{" + "branch" + "}", localVarApiClient.escapeString(branch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (ref != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ref", ref));
        }

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call hardResetBranchValidateBeforeCall(String repository, String branch, String ref, Boolean force, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling hardResetBranch(Async)");
        }

        // verify the required parameter 'branch' is set
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling hardResetBranch(Async)");
        }

        // verify the required parameter 'ref' is set
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling hardResetBranch(Async)");
        }

        return hardResetBranchCall(repository, branch, ref, force, _callback);

    }


    private ApiResponse<Void> hardResetBranchWithHttpInfo(String repository, String branch, String ref, Boolean force) throws ApiException {
        okhttp3.Call localVarCall = hardResetBranchValidateBeforeCall(repository, branch, ref, force, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call hardResetBranchAsync(String repository, String branch, String ref, Boolean force, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = hardResetBranchValidateBeforeCall(repository, branch, ref, force, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIhardResetBranchRequest {
        private final String repository;
        private final String branch;
        private final String ref;
        private Boolean force;

        private APIhardResetBranchRequest(String repository, String branch, String ref) {
            this.repository = repository;
            this.branch = branch;
            this.ref = ref;
        }

        /**
         * Set force
         * @param force  (optional, default to false)
         * @return APIhardResetBranchRequest
         */
        public APIhardResetBranchRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Build call for hardResetBranch
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return hardResetBranchCall(repository, branch, ref, force, _callback);
        }

        /**
         * Execute hardResetBranch request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            hardResetBranchWithHttpInfo(repository, branch, ref, force);
        }

        /**
         * Execute hardResetBranch request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return hardResetBranchWithHttpInfo(repository, branch, ref, force);
        }

        /**
         * Execute hardResetBranch request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return hardResetBranchAsync(repository, branch, ref, force, _callback);
        }
    }

    /**
     * hard reset branch
     * Relocate branch to refer to ref.  Branch must not contain uncommitted data.
     * @param repository  (required)
     * @param branch  (required)
     * @param ref After reset, branch will point at this reference. (required)
     * @return APIhardResetBranchRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> reset successful </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIhardResetBranchRequest hardResetBranch(String repository, String branch, String ref) {
        return new APIhardResetBranchRequest(repository, branch, ref);
    }
    private okhttp3.Call listUserExternalPrincipalsCall(String userId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/auth/users/{userId}/external/principals/ls"
            .replace("{" + "userId" + "}", localVarApiClient.escapeString(userId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserExternalPrincipalsValidateBeforeCall(String userId, String prefix, String after, Integer amount, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserExternalPrincipals(Async)");
        }

        return listUserExternalPrincipalsCall(userId, prefix, after, amount, _callback);

    }


    private ApiResponse<ExternalPrincipalList> listUserExternalPrincipalsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        okhttp3.Call localVarCall = listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUserExternalPrincipalsAsync(String userId, String prefix, String after, Integer amount, final ApiCallback<ExternalPrincipalList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUserExternalPrincipalsRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUserExternalPrincipalsRequest(String userId) {
            this.userId = userId;
        }

        /**
         * Set prefix
         * @param prefix return items prefixed with this value (optional)
         * @return APIlistUserExternalPrincipalsRequest
         */
        public APIlistUserExternalPrincipalsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Set after
         * @param after return items after this value (optional)
         * @return APIlistUserExternalPrincipalsRequest
         */
        public APIlistUserExternalPrincipalsRequest after(String after) {
            this.after = after;
            return this;
        }

        /**
         * Set amount
         * @param amount how many items to return (optional, default to 100)
         * @return APIlistUserExternalPrincipalsRequest
         */
        public APIlistUserExternalPrincipalsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Build call for listUserExternalPrincipals
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> external principals list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUserExternalPrincipalsCall(userId, prefix, after, amount, _callback);
        }

        /**
         * Execute listUserExternalPrincipals request
         * @return ExternalPrincipalList
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> external principals list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ExternalPrincipalList execute() throws ApiException {
            ApiResponse<ExternalPrincipalList> localVarResp = listUserExternalPrincipalsWithHttpInfo(userId, prefix, after, amount);
            return localVarResp.getData();
        }

        /**
         * Execute listUserExternalPrincipals request with HTTP info returned
         * @return ApiResponse&lt;ExternalPrincipalList&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> external principals list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ExternalPrincipalList> executeWithHttpInfo() throws ApiException {
            return listUserExternalPrincipalsWithHttpInfo(userId, prefix, after, amount);
        }

        /**
         * Execute listUserExternalPrincipals request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> external principals list </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ExternalPrincipalList> _callback) throws ApiException {
            return listUserExternalPrincipalsAsync(userId, prefix, after, amount, _callback);
        }
    }

    /**
     * list user external policies attached to a user
     * 
     * @param userId  (required)
     * @return APIlistUserExternalPrincipalsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> external principals list </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUserExternalPrincipalsRequest listUserExternalPrincipals(String userId) {
        return new APIlistUserExternalPrincipalsRequest(userId);
    }
    private okhttp3.Call stsLoginCall(StsAuthRequest stsAuthRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = stsAuthRequest;

        // create path and map variables
        String localVarPath = "/sts/login";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call stsLoginValidateBeforeCall(StsAuthRequest stsAuthRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'stsAuthRequest' is set
        if (stsAuthRequest == null) {
            throw new ApiException("Missing the required parameter 'stsAuthRequest' when calling stsLogin(Async)");
        }

        return stsLoginCall(stsAuthRequest, _callback);

    }


    private ApiResponse<AuthenticationToken> stsLoginWithHttpInfo(StsAuthRequest stsAuthRequest) throws ApiException {
        okhttp3.Call localVarCall = stsLoginValidateBeforeCall(stsAuthRequest, null);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call stsLoginAsync(StsAuthRequest stsAuthRequest, final ApiCallback<AuthenticationToken> _callback) throws ApiException {

        okhttp3.Call localVarCall = stsLoginValidateBeforeCall(stsAuthRequest, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIstsLoginRequest {
        private final StsAuthRequest stsAuthRequest;

        private APIstsLoginRequest(StsAuthRequest stsAuthRequest) {
            this.stsAuthRequest = stsAuthRequest;
        }

        /**
         * Build call for stsLogin
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful STS login </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return stsLoginCall(stsAuthRequest, _callback);
        }

        /**
         * Execute stsLogin request
         * @return AuthenticationToken
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful STS login </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public AuthenticationToken execute() throws ApiException {
            ApiResponse<AuthenticationToken> localVarResp = stsLoginWithHttpInfo(stsAuthRequest);
            return localVarResp.getData();
        }

        /**
         * Execute stsLogin request with HTTP info returned
         * @return ApiResponse&lt;AuthenticationToken&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful STS login </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<AuthenticationToken> executeWithHttpInfo() throws ApiException {
            return stsLoginWithHttpInfo(stsAuthRequest);
        }

        /**
         * Execute stsLogin request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> successful STS login </td><td>  -  </td></tr>
            <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
            <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
            <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<AuthenticationToken> _callback) throws ApiException {
            return stsLoginAsync(stsAuthRequest, _callback);
        }
    }

    /**
     * perform a login with STS
     * 
     * @param stsAuthRequest  (required)
     * @return APIstsLoginRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> successful STS login </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public APIstsLoginRequest stsLogin(StsAuthRequest stsAuthRequest) {
        return new APIstsLoginRequest(stsAuthRequest);
    }
}
