/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.BranchProtectionRule;
import io.lakefs.clients.sdk.model.GarbageCollectionRules;
import io.lakefs.clients.sdk.model.Repository;
import io.lakefs.clients.sdk.model.RepositoryCreation;
import io.lakefs.clients.sdk.model.RepositoryList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class RepositoriesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RepositoriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RepositoriesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createRepositoryCall(RepositoryCreation repositoryCreation, Boolean bare, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RepositoryCreation localVarPostBody = repositoryCreation;
        String localVarPath = "/repositories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (bare != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bare", bare));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRepositoryValidateBeforeCall(RepositoryCreation repositoryCreation, Boolean bare, ApiCallback _callback) throws ApiException {
        if (repositoryCreation == null) {
            throw new ApiException("Missing the required parameter 'repositoryCreation' when calling createRepository(Async)");
        }
        return this.createRepositoryCall(repositoryCreation, bare, _callback);
    }

    private ApiResponse<Repository> createRepositoryWithHttpInfo(RepositoryCreation repositoryCreation, Boolean bare) throws ApiException {
        Call localVarCall = this.createRepositoryValidateBeforeCall(repositoryCreation, bare, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createRepositoryAsync(RepositoryCreation repositoryCreation, Boolean bare, ApiCallback<Repository> _callback) throws ApiException {
        Call localVarCall = this.createRepositoryValidateBeforeCall(repositoryCreation, bare, _callback);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateRepositoryRequest createRepository(RepositoryCreation repositoryCreation) {
        return new APIcreateRepositoryRequest(repositoryCreation);
    }

    private Call deleteGCRulesCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/settings/gc_rules".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGCRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteGCRules(Async)");
        }
        return this.deleteGCRulesCall(repository, _callback);
    }

    private ApiResponse<Void> deleteGCRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.deleteGCRulesValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteGCRulesAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGCRulesValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteGCRulesRequest deleteGCRules(String repository) {
        return new APIdeleteGCRulesRequest(repository);
    }

    private Call deleteRepositoryCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRepositoryValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteRepository(Async)");
        }
        return this.deleteRepositoryCall(repository, _callback);
    }

    private ApiResponse<Void> deleteRepositoryWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.deleteRepositoryValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteRepositoryAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRepositoryValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteRepositoryRequest deleteRepository(String repository) {
        return new APIdeleteRepositoryRequest(repository);
    }

    private Call getBranchProtectionRulesCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/settings/branch_protection".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBranchProtectionRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getBranchProtectionRules(Async)");
        }
        return this.getBranchProtectionRulesCall(repository, _callback);
    }

    private ApiResponse<List<BranchProtectionRule>> getBranchProtectionRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.getBranchProtectionRulesValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<List<BranchProtectionRule>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getBranchProtectionRulesAsync(String repository, ApiCallback<List<BranchProtectionRule>> _callback) throws ApiException {
        Call localVarCall = this.getBranchProtectionRulesValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<List<BranchProtectionRule>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetBranchProtectionRulesRequest getBranchProtectionRules(String repository) {
        return new APIgetBranchProtectionRulesRequest(repository);
    }

    private Call getGCRulesCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/settings/gc_rules".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGCRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getGCRules(Async)");
        }
        return this.getGCRulesCall(repository, _callback);
    }

    private ApiResponse<GarbageCollectionRules> getGCRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.getGCRulesValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<GarbageCollectionRules>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getGCRulesAsync(String repository, ApiCallback<GarbageCollectionRules> _callback) throws ApiException {
        Call localVarCall = this.getGCRulesValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionRules>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetGCRulesRequest getGCRules(String repository) {
        return new APIgetGCRulesRequest(repository);
    }

    private Call getRepositoryCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRepositoryValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRepository(Async)");
        }
        return this.getRepositoryCall(repository, _callback);
    }

    private ApiResponse<Repository> getRepositoryWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.getRepositoryValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getRepositoryAsync(String repository, ApiCallback<Repository> _callback) throws ApiException {
        Call localVarCall = this.getRepositoryValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetRepositoryRequest getRepository(String repository) {
        return new APIgetRepositoryRequest(repository);
    }

    private Call getRepositoryMetadataCall(String repository, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/metadata".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRepositoryMetadataValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRepositoryMetadata(Async)");
        }
        return this.getRepositoryMetadataCall(repository, _callback);
    }

    private ApiResponse<Map<String, String>> getRepositoryMetadataWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.getRepositoryMetadataValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getRepositoryMetadataAsync(String repository, ApiCallback<Map<String, String>> _callback) throws ApiException {
        Call localVarCall = this.getRepositoryMetadataValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetRepositoryMetadataRequest getRepositoryMetadata(String repository) {
        return new APIgetRepositoryMetadataRequest(repository);
    }

    private Call listRepositoriesCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRepositoriesValidateBeforeCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        return this.listRepositoriesCall(prefix, after, amount, _callback);
    }

    private ApiResponse<RepositoryList> listRepositoriesWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listRepositoriesValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<RepositoryList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listRepositoriesAsync(String prefix, String after, Integer amount, ApiCallback<RepositoryList> _callback) throws ApiException {
        Call localVarCall = this.listRepositoriesValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<RepositoryList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRepositoriesRequest listRepositories() {
        return new APIlistRepositoriesRequest();
    }

    private Call setBranchProtectionRulesCall(String repository, List<BranchProtectionRule> branchProtectionRule, String ifMatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<BranchProtectionRule> localVarPostBody = branchProtectionRule;
        String localVarPath = "/repositories/{repository}/settings/branch_protection".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.localVarApiClient.parameterToString(ifMatch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setBranchProtectionRulesValidateBeforeCall(String repository, List<BranchProtectionRule> branchProtectionRule, String ifMatch, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling setBranchProtectionRules(Async)");
        }
        if (branchProtectionRule == null) {
            throw new ApiException("Missing the required parameter 'branchProtectionRule' when calling setBranchProtectionRules(Async)");
        }
        return this.setBranchProtectionRulesCall(repository, branchProtectionRule, ifMatch, _callback);
    }

    private ApiResponse<Void> setBranchProtectionRulesWithHttpInfo(String repository, List<BranchProtectionRule> branchProtectionRule, String ifMatch) throws ApiException {
        Call localVarCall = this.setBranchProtectionRulesValidateBeforeCall(repository, branchProtectionRule, ifMatch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call setBranchProtectionRulesAsync(String repository, List<BranchProtectionRule> branchProtectionRule, String ifMatch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setBranchProtectionRulesValidateBeforeCall(repository, branchProtectionRule, ifMatch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsetBranchProtectionRulesRequest setBranchProtectionRules(String repository, List<BranchProtectionRule> branchProtectionRule) {
        return new APIsetBranchProtectionRulesRequest(repository, branchProtectionRule);
    }

    private Call setGCRulesCall(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GarbageCollectionRules localVarPostBody = garbageCollectionRules;
        String localVarPath = "/repositories/{repository}/settings/gc_rules".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setGCRulesValidateBeforeCall(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling setGCRules(Async)");
        }
        if (garbageCollectionRules == null) {
            throw new ApiException("Missing the required parameter 'garbageCollectionRules' when calling setGCRules(Async)");
        }
        return this.setGCRulesCall(repository, garbageCollectionRules, _callback);
    }

    private ApiResponse<Void> setGCRulesWithHttpInfo(String repository, GarbageCollectionRules garbageCollectionRules) throws ApiException {
        Call localVarCall = this.setGCRulesValidateBeforeCall(repository, garbageCollectionRules, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call setGCRulesAsync(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setGCRulesValidateBeforeCall(repository, garbageCollectionRules, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsetGCRulesRequest setGCRules(String repository, GarbageCollectionRules garbageCollectionRules) {
        return new APIsetGCRulesRequest(repository, garbageCollectionRules);
    }

    public class APIsetGCRulesRequest {
        private final String repository;
        private final GarbageCollectionRules garbageCollectionRules;

        private APIsetGCRulesRequest(String repository, GarbageCollectionRules garbageCollectionRules) {
            this.repository = repository;
            this.garbageCollectionRules = garbageCollectionRules;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.setGCRulesCall(this.repository, this.garbageCollectionRules, _callback);
        }

        public void execute() throws ApiException {
            RepositoriesApi.this.setGCRulesWithHttpInfo(this.repository, this.garbageCollectionRules);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.setGCRulesWithHttpInfo(this.repository, this.garbageCollectionRules);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return RepositoriesApi.this.setGCRulesAsync(this.repository, this.garbageCollectionRules, _callback);
        }
    }

    public class APIsetBranchProtectionRulesRequest {
        private final String repository;
        private final List<BranchProtectionRule> branchProtectionRule;
        private String ifMatch;

        private APIsetBranchProtectionRulesRequest(String repository, List<BranchProtectionRule> branchProtectionRule) {
            this.repository = repository;
            this.branchProtectionRule = branchProtectionRule;
        }

        public APIsetBranchProtectionRulesRequest ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.setBranchProtectionRulesCall(this.repository, this.branchProtectionRule, this.ifMatch, _callback);
        }

        public void execute() throws ApiException {
            RepositoriesApi.this.setBranchProtectionRulesWithHttpInfo(this.repository, this.branchProtectionRule, this.ifMatch);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.setBranchProtectionRulesWithHttpInfo(this.repository, this.branchProtectionRule, this.ifMatch);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return RepositoriesApi.this.setBranchProtectionRulesAsync(this.repository, this.branchProtectionRule, this.ifMatch, _callback);
        }
    }

    public class APIlistRepositoriesRequest {
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistRepositoriesRequest() {
        }

        public APIlistRepositoriesRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistRepositoriesRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistRepositoriesRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.listRepositoriesCall(this.prefix, this.after, this.amount, _callback);
        }

        public RepositoryList execute() throws ApiException {
            ApiResponse localVarResp = RepositoriesApi.this.listRepositoriesWithHttpInfo(this.prefix, this.after, this.amount);
            return (RepositoryList)localVarResp.getData();
        }

        public ApiResponse<RepositoryList> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.listRepositoriesWithHttpInfo(this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<RepositoryList> _callback) throws ApiException {
            return RepositoriesApi.this.listRepositoriesAsync(this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIgetRepositoryMetadataRequest {
        private final String repository;

        private APIgetRepositoryMetadataRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.getRepositoryMetadataCall(this.repository, _callback);
        }

        public Map<String, String> execute() throws ApiException {
            ApiResponse localVarResp = RepositoriesApi.this.getRepositoryMetadataWithHttpInfo(this.repository);
            return (Map)localVarResp.getData();
        }

        public ApiResponse<Map<String, String>> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.getRepositoryMetadataWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<Map<String, String>> _callback) throws ApiException {
            return RepositoriesApi.this.getRepositoryMetadataAsync(this.repository, _callback);
        }
    }

    public class APIgetRepositoryRequest {
        private final String repository;

        private APIgetRepositoryRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.getRepositoryCall(this.repository, _callback);
        }

        public Repository execute() throws ApiException {
            ApiResponse localVarResp = RepositoriesApi.this.getRepositoryWithHttpInfo(this.repository);
            return (Repository)localVarResp.getData();
        }

        public ApiResponse<Repository> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.getRepositoryWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<Repository> _callback) throws ApiException {
            return RepositoriesApi.this.getRepositoryAsync(this.repository, _callback);
        }
    }

    public class APIgetGCRulesRequest {
        private final String repository;

        private APIgetGCRulesRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.getGCRulesCall(this.repository, _callback);
        }

        public GarbageCollectionRules execute() throws ApiException {
            ApiResponse localVarResp = RepositoriesApi.this.getGCRulesWithHttpInfo(this.repository);
            return (GarbageCollectionRules)localVarResp.getData();
        }

        public ApiResponse<GarbageCollectionRules> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.getGCRulesWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<GarbageCollectionRules> _callback) throws ApiException {
            return RepositoriesApi.this.getGCRulesAsync(this.repository, _callback);
        }
    }

    public class APIgetBranchProtectionRulesRequest {
        private final String repository;

        private APIgetBranchProtectionRulesRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.getBranchProtectionRulesCall(this.repository, _callback);
        }

        public List<BranchProtectionRule> execute() throws ApiException {
            ApiResponse localVarResp = RepositoriesApi.this.getBranchProtectionRulesWithHttpInfo(this.repository);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<BranchProtectionRule>> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.getBranchProtectionRulesWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<List<BranchProtectionRule>> _callback) throws ApiException {
            return RepositoriesApi.this.getBranchProtectionRulesAsync(this.repository, _callback);
        }
    }

    public class APIdeleteRepositoryRequest {
        private final String repository;

        private APIdeleteRepositoryRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.deleteRepositoryCall(this.repository, _callback);
        }

        public void execute() throws ApiException {
            RepositoriesApi.this.deleteRepositoryWithHttpInfo(this.repository);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.deleteRepositoryWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return RepositoriesApi.this.deleteRepositoryAsync(this.repository, _callback);
        }
    }

    public class APIdeleteGCRulesRequest {
        private final String repository;

        private APIdeleteGCRulesRequest(String repository) {
            this.repository = repository;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.deleteGCRulesCall(this.repository, _callback);
        }

        public void execute() throws ApiException {
            RepositoriesApi.this.deleteGCRulesWithHttpInfo(this.repository);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.deleteGCRulesWithHttpInfo(this.repository);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return RepositoriesApi.this.deleteGCRulesAsync(this.repository, _callback);
        }
    }

    public class APIcreateRepositoryRequest {
        private final RepositoryCreation repositoryCreation;
        private Boolean bare;

        private APIcreateRepositoryRequest(RepositoryCreation repositoryCreation) {
            this.repositoryCreation = repositoryCreation;
        }

        public APIcreateRepositoryRequest bare(Boolean bare) {
            this.bare = bare;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RepositoriesApi.this.createRepositoryCall(this.repositoryCreation, this.bare, _callback);
        }

        public Repository execute() throws ApiException {
            ApiResponse localVarResp = RepositoriesApi.this.createRepositoryWithHttpInfo(this.repositoryCreation, this.bare);
            return (Repository)localVarResp.getData();
        }

        public ApiResponse<Repository> executeWithHttpInfo() throws ApiException {
            return RepositoriesApi.this.createRepositoryWithHttpInfo(this.repositoryCreation, this.bare);
        }

        public Call executeAsync(ApiCallback<Repository> _callback) throws ApiException {
            return RepositoriesApi.this.createRepositoryAsync(this.repositoryCreation, this.bare, _callback);
        }
    }
}

