/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.ObjectCopyCreation;
import io.lakefs.clients.sdk.model.ObjectErrorList;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.ObjectStatsList;
import io.lakefs.clients.sdk.model.PathList;
import io.lakefs.clients.sdk.model.UnderlyingObjectProperties;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ObjectsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ObjectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call copyObjectCall(String repository, String branch, String destPath, ObjectCopyCreation objectCopyCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ObjectCopyCreation localVarPostBody = objectCopyCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects/copy".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (destPath != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dest_path", destPath));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call copyObjectValidateBeforeCall(String repository, String branch, String destPath, ObjectCopyCreation objectCopyCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling copyObject(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling copyObject(Async)");
        }
        if (destPath == null) {
            throw new ApiException("Missing the required parameter 'destPath' when calling copyObject(Async)");
        }
        if (objectCopyCreation == null) {
            throw new ApiException("Missing the required parameter 'objectCopyCreation' when calling copyObject(Async)");
        }
        return this.copyObjectCall(repository, branch, destPath, objectCopyCreation, _callback);
    }

    private ApiResponse<ObjectStats> copyObjectWithHttpInfo(String repository, String branch, String destPath, ObjectCopyCreation objectCopyCreation) throws ApiException {
        Call localVarCall = this.copyObjectValidateBeforeCall(repository, branch, destPath, objectCopyCreation, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call copyObjectAsync(String repository, String branch, String destPath, ObjectCopyCreation objectCopyCreation, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.copyObjectValidateBeforeCall(repository, branch, destPath, objectCopyCreation, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcopyObjectRequest copyObject(String repository, String branch, String destPath, ObjectCopyCreation objectCopyCreation) {
        return new APIcopyObjectRequest(repository, branch, destPath, objectCopyCreation);
    }

    private Call deleteObjectCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteObjectValidateBeforeCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteObject(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling deleteObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling deleteObject(Async)");
        }
        return this.deleteObjectCall(repository, branch, path, _callback);
    }

    private ApiResponse<Void> deleteObjectWithHttpInfo(String repository, String branch, String path) throws ApiException {
        Call localVarCall = this.deleteObjectValidateBeforeCall(repository, branch, path, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteObjectAsync(String repository, String branch, String path, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteObjectValidateBeforeCall(repository, branch, path, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteObjectRequest deleteObject(String repository, String branch, String path) {
        return new APIdeleteObjectRequest(repository, branch, path);
    }

    private Call deleteObjectsCall(String repository, String branch, PathList pathList, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PathList localVarPostBody = pathList;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects/delete".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteObjectsValidateBeforeCall(String repository, String branch, PathList pathList, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteObjects(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling deleteObjects(Async)");
        }
        if (pathList == null) {
            throw new ApiException("Missing the required parameter 'pathList' when calling deleteObjects(Async)");
        }
        return this.deleteObjectsCall(repository, branch, pathList, _callback);
    }

    private ApiResponse<ObjectErrorList> deleteObjectsWithHttpInfo(String repository, String branch, PathList pathList) throws ApiException {
        Call localVarCall = this.deleteObjectsValidateBeforeCall(repository, branch, pathList, null);
        Type localVarReturnType = new TypeToken<ObjectErrorList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteObjectsAsync(String repository, String branch, PathList pathList, ApiCallback<ObjectErrorList> _callback) throws ApiException {
        Call localVarCall = this.deleteObjectsValidateBeforeCall(repository, branch, pathList, _callback);
        Type localVarReturnType = new TypeToken<ObjectErrorList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteObjectsRequest deleteObjects(String repository, String branch, PathList pathList) {
        return new APIdeleteObjectsRequest(repository, branch, pathList);
    }

    private Call getObjectCall(String repository, String ref, String path, String range, Boolean presign, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{ref}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (presign != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("presign", presign));
        }
        if (range != null) {
            localVarHeaderParams.put("Range", this.localVarApiClient.parameterToString(range));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/octet-stream", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getObjectValidateBeforeCall(String repository, String ref, String path, String range, Boolean presign, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getObject(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling getObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getObject(Async)");
        }
        return this.getObjectCall(repository, ref, path, range, presign, _callback);
    }

    private ApiResponse<File> getObjectWithHttpInfo(String repository, String ref, String path, String range, Boolean presign) throws ApiException {
        Call localVarCall = this.getObjectValidateBeforeCall(repository, ref, path, range, presign, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getObjectAsync(String repository, String ref, String path, String range, Boolean presign, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getObjectValidateBeforeCall(repository, ref, path, range, presign, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetObjectRequest getObject(String repository, String ref, String path) {
        return new APIgetObjectRequest(repository, ref, path);
    }

    private Call getUnderlyingPropertiesCall(String repository, String ref, String path, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects/underlyingProperties".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{ref}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnderlyingPropertiesValidateBeforeCall(String repository, String ref, String path, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getUnderlyingProperties(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling getUnderlyingProperties(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getUnderlyingProperties(Async)");
        }
        return this.getUnderlyingPropertiesCall(repository, ref, path, _callback);
    }

    private ApiResponse<UnderlyingObjectProperties> getUnderlyingPropertiesWithHttpInfo(String repository, String ref, String path) throws ApiException {
        Call localVarCall = this.getUnderlyingPropertiesValidateBeforeCall(repository, ref, path, null);
        Type localVarReturnType = new TypeToken<UnderlyingObjectProperties>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getUnderlyingPropertiesAsync(String repository, String ref, String path, ApiCallback<UnderlyingObjectProperties> _callback) throws ApiException {
        Call localVarCall = this.getUnderlyingPropertiesValidateBeforeCall(repository, ref, path, _callback);
        Type localVarReturnType = new TypeToken<UnderlyingObjectProperties>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetUnderlyingPropertiesRequest getUnderlyingProperties(String repository, String ref, String path) {
        return new APIgetUnderlyingPropertiesRequest(repository, ref, path);
    }

    private Call headObjectCall(String repository, String ref, String path, String range, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{ref}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (range != null) {
            localVarHeaderParams.put("Range", this.localVarApiClient.parameterToString(range));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[0])) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "HEAD", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call headObjectValidateBeforeCall(String repository, String ref, String path, String range, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling headObject(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling headObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling headObject(Async)");
        }
        return this.headObjectCall(repository, ref, path, range, _callback);
    }

    private ApiResponse<Void> headObjectWithHttpInfo(String repository, String ref, String path, String range) throws ApiException {
        Call localVarCall = this.headObjectValidateBeforeCall(repository, ref, path, range, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call headObjectAsync(String repository, String ref, String path, String range, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.headObjectValidateBeforeCall(repository, ref, path, range, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIheadObjectRequest headObject(String repository, String ref, String path) {
        return new APIheadObjectRequest(repository, ref, path);
    }

    private Call listObjectsCall(String repository, String ref, Boolean userMetadata, Boolean presign, String after, Integer amount, String delimiter, String prefix, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects/ls".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{ref}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userMetadata != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_metadata", userMetadata));
        }
        if (presign != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("presign", presign));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (delimiter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("delimiter", delimiter));
        }
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listObjectsValidateBeforeCall(String repository, String ref, Boolean userMetadata, Boolean presign, String after, Integer amount, String delimiter, String prefix, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listObjects(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling listObjects(Async)");
        }
        return this.listObjectsCall(repository, ref, userMetadata, presign, after, amount, delimiter, prefix, _callback);
    }

    private ApiResponse<ObjectStatsList> listObjectsWithHttpInfo(String repository, String ref, Boolean userMetadata, Boolean presign, String after, Integer amount, String delimiter, String prefix) throws ApiException {
        Call localVarCall = this.listObjectsValidateBeforeCall(repository, ref, userMetadata, presign, after, amount, delimiter, prefix, null);
        Type localVarReturnType = new TypeToken<ObjectStatsList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listObjectsAsync(String repository, String ref, Boolean userMetadata, Boolean presign, String after, Integer amount, String delimiter, String prefix, ApiCallback<ObjectStatsList> _callback) throws ApiException {
        Call localVarCall = this.listObjectsValidateBeforeCall(repository, ref, userMetadata, presign, after, amount, delimiter, prefix, _callback);
        Type localVarReturnType = new TypeToken<ObjectStatsList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistObjectsRequest listObjects(String repository, String ref) {
        return new APIlistObjectsRequest(repository, ref);
    }

    private Call statObjectCall(String repository, String ref, String path, Boolean userMetadata, Boolean presign, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects/stat".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{ref}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (userMetadata != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_metadata", userMetadata));
        }
        if (presign != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("presign", presign));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call statObjectValidateBeforeCall(String repository, String ref, String path, Boolean userMetadata, Boolean presign, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling statObject(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling statObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling statObject(Async)");
        }
        return this.statObjectCall(repository, ref, path, userMetadata, presign, _callback);
    }

    private ApiResponse<ObjectStats> statObjectWithHttpInfo(String repository, String ref, String path, Boolean userMetadata, Boolean presign) throws ApiException {
        Call localVarCall = this.statObjectValidateBeforeCall(repository, ref, path, userMetadata, presign, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call statObjectAsync(String repository, String ref, String path, Boolean userMetadata, Boolean presign, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.statObjectValidateBeforeCall(repository, ref, path, userMetadata, presign, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIstatObjectRequest statObject(String repository, String ref, String path) {
        return new APIstatObjectRequest(repository, ref, path);
    }

    private Call uploadObjectCall(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (content != null) {
            localVarFormParams.put("content", content);
        }
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (storageClass != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("storageClass", storageClass));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data", "application/octet-stream"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadObjectValidateBeforeCall(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling uploadObject(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling uploadObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling uploadObject(Async)");
        }
        return this.uploadObjectCall(repository, branch, path, storageClass, ifNoneMatch, content, _callback);
    }

    private ApiResponse<ObjectStats> uploadObjectWithHttpInfo(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content) throws ApiException {
        Call localVarCall = this.uploadObjectValidateBeforeCall(repository, branch, path, storageClass, ifNoneMatch, content, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadObjectAsync(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.uploadObjectValidateBeforeCall(repository, branch, path, storageClass, ifNoneMatch, content, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIuploadObjectRequest uploadObject(String repository, String branch, String path) {
        return new APIuploadObjectRequest(repository, branch, path);
    }

    public class APIuploadObjectRequest {
        private final String repository;
        private final String branch;
        private final String path;
        private String storageClass;
        private String ifNoneMatch;
        private File content;

        private APIuploadObjectRequest(String repository, String branch, String path) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
        }

        public APIuploadObjectRequest storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public APIuploadObjectRequest ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public APIuploadObjectRequest content(File content) {
            this.content = content;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.uploadObjectCall(this.repository, this.branch, this.path, this.storageClass, this.ifNoneMatch, this.content, _callback);
        }

        public ObjectStats execute() throws ApiException {
            ApiResponse localVarResp = ObjectsApi.this.uploadObjectWithHttpInfo(this.repository, this.branch, this.path, this.storageClass, this.ifNoneMatch, this.content);
            return (ObjectStats)localVarResp.getData();
        }

        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.uploadObjectWithHttpInfo(this.repository, this.branch, this.path, this.storageClass, this.ifNoneMatch, this.content);
        }

        public Call executeAsync(ApiCallback<ObjectStats> _callback) throws ApiException {
            return ObjectsApi.this.uploadObjectAsync(this.repository, this.branch, this.path, this.storageClass, this.ifNoneMatch, this.content, _callback);
        }
    }

    public class APIstatObjectRequest {
        private final String repository;
        private final String ref;
        private final String path;
        private Boolean userMetadata;
        private Boolean presign;

        private APIstatObjectRequest(String repository, String ref, String path) {
            this.repository = repository;
            this.ref = ref;
            this.path = path;
        }

        public APIstatObjectRequest userMetadata(Boolean userMetadata) {
            this.userMetadata = userMetadata;
            return this;
        }

        public APIstatObjectRequest presign(Boolean presign) {
            this.presign = presign;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.statObjectCall(this.repository, this.ref, this.path, this.userMetadata, this.presign, _callback);
        }

        public ObjectStats execute() throws ApiException {
            ApiResponse localVarResp = ObjectsApi.this.statObjectWithHttpInfo(this.repository, this.ref, this.path, this.userMetadata, this.presign);
            return (ObjectStats)localVarResp.getData();
        }

        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.statObjectWithHttpInfo(this.repository, this.ref, this.path, this.userMetadata, this.presign);
        }

        public Call executeAsync(ApiCallback<ObjectStats> _callback) throws ApiException {
            return ObjectsApi.this.statObjectAsync(this.repository, this.ref, this.path, this.userMetadata, this.presign, _callback);
        }
    }

    public class APIlistObjectsRequest {
        private final String repository;
        private final String ref;
        private Boolean userMetadata;
        private Boolean presign;
        private String after;
        private Integer amount;
        private String delimiter;
        private String prefix;

        private APIlistObjectsRequest(String repository, String ref) {
            this.repository = repository;
            this.ref = ref;
        }

        public APIlistObjectsRequest userMetadata(Boolean userMetadata) {
            this.userMetadata = userMetadata;
            return this;
        }

        public APIlistObjectsRequest presign(Boolean presign) {
            this.presign = presign;
            return this;
        }

        public APIlistObjectsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistObjectsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public APIlistObjectsRequest delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public APIlistObjectsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.listObjectsCall(this.repository, this.ref, this.userMetadata, this.presign, this.after, this.amount, this.delimiter, this.prefix, _callback);
        }

        public ObjectStatsList execute() throws ApiException {
            ApiResponse localVarResp = ObjectsApi.this.listObjectsWithHttpInfo(this.repository, this.ref, this.userMetadata, this.presign, this.after, this.amount, this.delimiter, this.prefix);
            return (ObjectStatsList)localVarResp.getData();
        }

        public ApiResponse<ObjectStatsList> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.listObjectsWithHttpInfo(this.repository, this.ref, this.userMetadata, this.presign, this.after, this.amount, this.delimiter, this.prefix);
        }

        public Call executeAsync(ApiCallback<ObjectStatsList> _callback) throws ApiException {
            return ObjectsApi.this.listObjectsAsync(this.repository, this.ref, this.userMetadata, this.presign, this.after, this.amount, this.delimiter, this.prefix, _callback);
        }
    }

    public class APIheadObjectRequest {
        private final String repository;
        private final String ref;
        private final String path;
        private String range;

        private APIheadObjectRequest(String repository, String ref, String path) {
            this.repository = repository;
            this.ref = ref;
            this.path = path;
        }

        public APIheadObjectRequest range(String range) {
            this.range = range;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.headObjectCall(this.repository, this.ref, this.path, this.range, _callback);
        }

        public void execute() throws ApiException {
            ObjectsApi.this.headObjectWithHttpInfo(this.repository, this.ref, this.path, this.range);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.headObjectWithHttpInfo(this.repository, this.ref, this.path, this.range);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ObjectsApi.this.headObjectAsync(this.repository, this.ref, this.path, this.range, _callback);
        }
    }

    public class APIgetUnderlyingPropertiesRequest {
        private final String repository;
        private final String ref;
        private final String path;

        private APIgetUnderlyingPropertiesRequest(String repository, String ref, String path) {
            this.repository = repository;
            this.ref = ref;
            this.path = path;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.getUnderlyingPropertiesCall(this.repository, this.ref, this.path, _callback);
        }

        public UnderlyingObjectProperties execute() throws ApiException {
            ApiResponse localVarResp = ObjectsApi.this.getUnderlyingPropertiesWithHttpInfo(this.repository, this.ref, this.path);
            return (UnderlyingObjectProperties)localVarResp.getData();
        }

        public ApiResponse<UnderlyingObjectProperties> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.getUnderlyingPropertiesWithHttpInfo(this.repository, this.ref, this.path);
        }

        public Call executeAsync(ApiCallback<UnderlyingObjectProperties> _callback) throws ApiException {
            return ObjectsApi.this.getUnderlyingPropertiesAsync(this.repository, this.ref, this.path, _callback);
        }
    }

    public class APIgetObjectRequest {
        private final String repository;
        private final String ref;
        private final String path;
        private String range;
        private Boolean presign;

        private APIgetObjectRequest(String repository, String ref, String path) {
            this.repository = repository;
            this.ref = ref;
            this.path = path;
        }

        public APIgetObjectRequest range(String range) {
            this.range = range;
            return this;
        }

        public APIgetObjectRequest presign(Boolean presign) {
            this.presign = presign;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.getObjectCall(this.repository, this.ref, this.path, this.range, this.presign, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse localVarResp = ObjectsApi.this.getObjectWithHttpInfo(this.repository, this.ref, this.path, this.range, this.presign);
            return (File)localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.getObjectWithHttpInfo(this.repository, this.ref, this.path, this.range, this.presign);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ObjectsApi.this.getObjectAsync(this.repository, this.ref, this.path, this.range, this.presign, _callback);
        }
    }

    public class APIdeleteObjectsRequest {
        private final String repository;
        private final String branch;
        private final PathList pathList;

        private APIdeleteObjectsRequest(String repository, String branch, PathList pathList) {
            this.repository = repository;
            this.branch = branch;
            this.pathList = pathList;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.deleteObjectsCall(this.repository, this.branch, this.pathList, _callback);
        }

        public ObjectErrorList execute() throws ApiException {
            ApiResponse localVarResp = ObjectsApi.this.deleteObjectsWithHttpInfo(this.repository, this.branch, this.pathList);
            return (ObjectErrorList)localVarResp.getData();
        }

        public ApiResponse<ObjectErrorList> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.deleteObjectsWithHttpInfo(this.repository, this.branch, this.pathList);
        }

        public Call executeAsync(ApiCallback<ObjectErrorList> _callback) throws ApiException {
            return ObjectsApi.this.deleteObjectsAsync(this.repository, this.branch, this.pathList, _callback);
        }
    }

    public class APIdeleteObjectRequest {
        private final String repository;
        private final String branch;
        private final String path;

        private APIdeleteObjectRequest(String repository, String branch, String path) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.deleteObjectCall(this.repository, this.branch, this.path, _callback);
        }

        public void execute() throws ApiException {
            ObjectsApi.this.deleteObjectWithHttpInfo(this.repository, this.branch, this.path);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.deleteObjectWithHttpInfo(this.repository, this.branch, this.path);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ObjectsApi.this.deleteObjectAsync(this.repository, this.branch, this.path, _callback);
        }
    }

    public class APIcopyObjectRequest {
        private final String repository;
        private final String branch;
        private final String destPath;
        private final ObjectCopyCreation objectCopyCreation;

        private APIcopyObjectRequest(String repository, String branch, String destPath, ObjectCopyCreation objectCopyCreation) {
            this.repository = repository;
            this.branch = branch;
            this.destPath = destPath;
            this.objectCopyCreation = objectCopyCreation;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ObjectsApi.this.copyObjectCall(this.repository, this.branch, this.destPath, this.objectCopyCreation, _callback);
        }

        public ObjectStats execute() throws ApiException {
            ApiResponse localVarResp = ObjectsApi.this.copyObjectWithHttpInfo(this.repository, this.branch, this.destPath, this.objectCopyCreation);
            return (ObjectStats)localVarResp.getData();
        }

        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return ObjectsApi.this.copyObjectWithHttpInfo(this.repository, this.branch, this.destPath, this.objectCopyCreation);
        }

        public Call executeAsync(ApiCallback<ObjectStats> _callback) throws ApiException {
            return ObjectsApi.this.copyObjectAsync(this.repository, this.branch, this.destPath, this.objectCopyCreation, _callback);
        }
    }
}

