/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.ActionRun;
import io.lakefs.clients.sdk.model.ActionRunList;
import io.lakefs.clients.sdk.model.HookRunList;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ActionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getRunCall(String repository, String runId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/actions/runs/{run_id}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{run_id}", this.localVarApiClient.escapeString(runId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRunValidateBeforeCall(String repository, String runId, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRun(Async)");
        }
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRun(Async)");
        }
        return this.getRunCall(repository, runId, _callback);
    }

    private ApiResponse<ActionRun> getRunWithHttpInfo(String repository, String runId) throws ApiException {
        Call localVarCall = this.getRunValidateBeforeCall(repository, runId, null);
        Type localVarReturnType = new TypeToken<ActionRun>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getRunAsync(String repository, String runId, ApiCallback<ActionRun> _callback) throws ApiException {
        Call localVarCall = this.getRunValidateBeforeCall(repository, runId, _callback);
        Type localVarReturnType = new TypeToken<ActionRun>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetRunRequest getRun(String repository, String runId) {
        return new APIgetRunRequest(repository, runId);
    }

    private Call getRunHookOutputCall(String repository, String runId, String hookRunId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/actions/runs/{run_id}/hooks/{hook_run_id}/output".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{run_id}", this.localVarApiClient.escapeString(runId.toString())).replace("{hook_run_id}", this.localVarApiClient.escapeString(hookRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRunHookOutputValidateBeforeCall(String repository, String runId, String hookRunId, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRunHookOutput(Async)");
        }
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling getRunHookOutput(Async)");
        }
        if (hookRunId == null) {
            throw new ApiException("Missing the required parameter 'hookRunId' when calling getRunHookOutput(Async)");
        }
        return this.getRunHookOutputCall(repository, runId, hookRunId, _callback);
    }

    private ApiResponse<File> getRunHookOutputWithHttpInfo(String repository, String runId, String hookRunId) throws ApiException {
        Call localVarCall = this.getRunHookOutputValidateBeforeCall(repository, runId, hookRunId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getRunHookOutputAsync(String repository, String runId, String hookRunId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getRunHookOutputValidateBeforeCall(repository, runId, hookRunId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetRunHookOutputRequest getRunHookOutput(String repository, String runId, String hookRunId) {
        return new APIgetRunHookOutputRequest(repository, runId, hookRunId);
    }

    private Call listRepositoryRunsCall(String repository, String after, Integer amount, String branch, String commit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/actions/runs".replace("{repository}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (branch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("branch", branch));
        }
        if (commit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("commit", commit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRepositoryRunsValidateBeforeCall(String repository, String after, Integer amount, String branch, String commit, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listRepositoryRuns(Async)");
        }
        return this.listRepositoryRunsCall(repository, after, amount, branch, commit, _callback);
    }

    private ApiResponse<ActionRunList> listRepositoryRunsWithHttpInfo(String repository, String after, Integer amount, String branch, String commit) throws ApiException {
        Call localVarCall = this.listRepositoryRunsValidateBeforeCall(repository, after, amount, branch, commit, null);
        Type localVarReturnType = new TypeToken<ActionRunList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listRepositoryRunsAsync(String repository, String after, Integer amount, String branch, String commit, ApiCallback<ActionRunList> _callback) throws ApiException {
        Call localVarCall = this.listRepositoryRunsValidateBeforeCall(repository, after, amount, branch, commit, _callback);
        Type localVarReturnType = new TypeToken<ActionRunList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRepositoryRunsRequest listRepositoryRuns(String repository) {
        return new APIlistRepositoryRunsRequest(repository);
    }

    private Call listRunHooksCall(String repository, String runId, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/actions/runs/{run_id}/hooks".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{run_id}", this.localVarApiClient.escapeString(runId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRunHooksValidateBeforeCall(String repository, String runId, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listRunHooks(Async)");
        }
        if (runId == null) {
            throw new ApiException("Missing the required parameter 'runId' when calling listRunHooks(Async)");
        }
        return this.listRunHooksCall(repository, runId, after, amount, _callback);
    }

    private ApiResponse<HookRunList> listRunHooksWithHttpInfo(String repository, String runId, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listRunHooksValidateBeforeCall(repository, runId, after, amount, null);
        Type localVarReturnType = new TypeToken<HookRunList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listRunHooksAsync(String repository, String runId, String after, Integer amount, ApiCallback<HookRunList> _callback) throws ApiException {
        Call localVarCall = this.listRunHooksValidateBeforeCall(repository, runId, after, amount, _callback);
        Type localVarReturnType = new TypeToken<HookRunList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistRunHooksRequest listRunHooks(String repository, String runId) {
        return new APIlistRunHooksRequest(repository, runId);
    }

    public class APIlistRunHooksRequest {
        private final String repository;
        private final String runId;
        private String after;
        private Integer amount;

        private APIlistRunHooksRequest(String repository, String runId) {
            this.repository = repository;
            this.runId = runId;
        }

        public APIlistRunHooksRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistRunHooksRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.listRunHooksCall(this.repository, this.runId, this.after, this.amount, _callback);
        }

        public HookRunList execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.listRunHooksWithHttpInfo(this.repository, this.runId, this.after, this.amount);
            return (HookRunList)localVarResp.getData();
        }

        public ApiResponse<HookRunList> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.listRunHooksWithHttpInfo(this.repository, this.runId, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<HookRunList> _callback) throws ApiException {
            return ActionsApi.this.listRunHooksAsync(this.repository, this.runId, this.after, this.amount, _callback);
        }
    }

    public class APIlistRepositoryRunsRequest {
        private final String repository;
        private String after;
        private Integer amount;
        private String branch;
        private String commit;

        private APIlistRepositoryRunsRequest(String repository) {
            this.repository = repository;
        }

        public APIlistRepositoryRunsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistRepositoryRunsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public APIlistRepositoryRunsRequest branch(String branch) {
            this.branch = branch;
            return this;
        }

        public APIlistRepositoryRunsRequest commit(String commit) {
            this.commit = commit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.listRepositoryRunsCall(this.repository, this.after, this.amount, this.branch, this.commit, _callback);
        }

        public ActionRunList execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.listRepositoryRunsWithHttpInfo(this.repository, this.after, this.amount, this.branch, this.commit);
            return (ActionRunList)localVarResp.getData();
        }

        public ApiResponse<ActionRunList> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.listRepositoryRunsWithHttpInfo(this.repository, this.after, this.amount, this.branch, this.commit);
        }

        public Call executeAsync(ApiCallback<ActionRunList> _callback) throws ApiException {
            return ActionsApi.this.listRepositoryRunsAsync(this.repository, this.after, this.amount, this.branch, this.commit, _callback);
        }
    }

    public class APIgetRunHookOutputRequest {
        private final String repository;
        private final String runId;
        private final String hookRunId;

        private APIgetRunHookOutputRequest(String repository, String runId, String hookRunId) {
            this.repository = repository;
            this.runId = runId;
            this.hookRunId = hookRunId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.getRunHookOutputCall(this.repository, this.runId, this.hookRunId, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.getRunHookOutputWithHttpInfo(this.repository, this.runId, this.hookRunId);
            return (File)localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.getRunHookOutputWithHttpInfo(this.repository, this.runId, this.hookRunId);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ActionsApi.this.getRunHookOutputAsync(this.repository, this.runId, this.hookRunId, _callback);
        }
    }

    public class APIgetRunRequest {
        private final String repository;
        private final String runId;

        private APIgetRunRequest(String repository, String runId) {
            this.repository = repository;
            this.runId = runId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ActionsApi.this.getRunCall(this.repository, this.runId, _callback);
        }

        public ActionRun execute() throws ApiException {
            ApiResponse localVarResp = ActionsApi.this.getRunWithHttpInfo(this.repository, this.runId);
            return (ActionRun)localVarResp.getData();
        }

        public ApiResponse<ActionRun> executeWithHttpInfo() throws ApiException {
            return ActionsApi.this.getRunWithHttpInfo(this.repository, this.runId);
        }

        public Call executeAsync(ApiCallback<ActionRun> _callback) throws ApiException {
            return ActionsApi.this.getRunAsync(this.repository, this.runId, _callback);
        }
    }
}

