/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.AbortPresignMultipartUpload;
import io.lakefs.clients.sdk.model.AuthenticationToken;
import io.lakefs.clients.sdk.model.CompletePresignMultipartUpload;
import io.lakefs.clients.sdk.model.ExternalLoginInformation;
import io.lakefs.clients.sdk.model.ExternalPrincipal;
import io.lakefs.clients.sdk.model.ExternalPrincipalCreation;
import io.lakefs.clients.sdk.model.ExternalPrincipalList;
import io.lakefs.clients.sdk.model.ObjectStats;
import io.lakefs.clients.sdk.model.PresignMultipartUpload;
import io.lakefs.clients.sdk.model.StsAuthRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExperimentalApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExperimentalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call abortPresignMultipartUploadCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AbortPresignMultipartUpload localVarPostBody = abortPresignMultipartUpload;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString())).replace("{uploadId}", this.localVarApiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call abortPresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling abortPresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling abortPresignMultipartUpload(Async)");
        }
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling abortPresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling abortPresignMultipartUpload(Async)");
        }
        return this.abortPresignMultipartUploadCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
    }

    private ApiResponse<Void> abortPresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload) throws ApiException {
        Call localVarCall = this.abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call abortPresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIabortPresignMultipartUploadRequest abortPresignMultipartUpload(String repository, String branch, String uploadId, String path) {
        return new APIabortPresignMultipartUploadRequest(repository, branch, uploadId, path);
    }

    private Call completePresignMultipartUploadCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CompletePresignMultipartUpload localVarPostBody = completePresignMultipartUpload;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString())).replace("{uploadId}", this.localVarApiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call completePresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling completePresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling completePresignMultipartUpload(Async)");
        }
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling completePresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling completePresignMultipartUpload(Async)");
        }
        return this.completePresignMultipartUploadCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
    }

    private ApiResponse<ObjectStats> completePresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload) throws ApiException {
        Call localVarCall = this.completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call completePresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcompletePresignMultipartUploadRequest completePresignMultipartUpload(String repository, String branch, String uploadId, String path) {
        return new APIcompletePresignMultipartUploadRequest(repository, branch, uploadId, path);
    }

    private Call createPresignMultipartUploadCall(String repository, String branch, String path, Integer parts, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (parts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parts", parts));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPresignMultipartUploadValidateBeforeCall(String repository, String branch, String path, Integer parts, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createPresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createPresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling createPresignMultipartUpload(Async)");
        }
        return this.createPresignMultipartUploadCall(repository, branch, path, parts, _callback);
    }

    private ApiResponse<PresignMultipartUpload> createPresignMultipartUploadWithHttpInfo(String repository, String branch, String path, Integer parts) throws ApiException {
        Call localVarCall = this.createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, null);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createPresignMultipartUploadAsync(String repository, String branch, String path, Integer parts, ApiCallback<PresignMultipartUpload> _callback) throws ApiException {
        Call localVarCall = this.createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, _callback);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreatePresignMultipartUploadRequest createPresignMultipartUpload(String repository, String branch, String path) {
        return new APIcreatePresignMultipartUploadRequest(repository, branch, path);
    }

    private Call createUserExternalPrincipalCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExternalPrincipalCreation localVarPostBody = externalPrincipalCreation;
        String localVarPath = "/auth/users/{userId}/external/principals".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createUserExternalPrincipal(Async)");
        }
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling createUserExternalPrincipal(Async)");
        }
        return this.createUserExternalPrincipalCall(userId, principalId, externalPrincipalCreation, _callback);
    }

    private ApiResponse<Void> createUserExternalPrincipalWithHttpInfo(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation) throws ApiException {
        Call localVarCall = this.createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call createUserExternalPrincipalAsync(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcreateUserExternalPrincipalRequest createUserExternalPrincipal(String userId, String principalId) {
        return new APIcreateUserExternalPrincipalRequest(userId, principalId);
    }

    private Call deleteUserExternalPrincipalCall(String userId, String principalId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/external/principals".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUserExternalPrincipal(Async)");
        }
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling deleteUserExternalPrincipal(Async)");
        }
        return this.deleteUserExternalPrincipalCall(userId, principalId, _callback);
    }

    private ApiResponse<Void> deleteUserExternalPrincipalWithHttpInfo(String userId, String principalId) throws ApiException {
        Call localVarCall = this.deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteUserExternalPrincipalAsync(String userId, String principalId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteUserExternalPrincipalRequest deleteUserExternalPrincipal(String userId, String principalId) {
        return new APIdeleteUserExternalPrincipalRequest(userId, principalId);
    }

    private Call externalPrincipalLoginCall(ExternalLoginInformation externalLoginInformation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExternalLoginInformation localVarPostBody = externalLoginInformation;
        String localVarPath = "/auth/external/principal/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call externalPrincipalLoginValidateBeforeCall(ExternalLoginInformation externalLoginInformation, ApiCallback _callback) throws ApiException {
        return this.externalPrincipalLoginCall(externalLoginInformation, _callback);
    }

    private ApiResponse<AuthenticationToken> externalPrincipalLoginWithHttpInfo(ExternalLoginInformation externalLoginInformation) throws ApiException {
        Call localVarCall = this.externalPrincipalLoginValidateBeforeCall(externalLoginInformation, null);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call externalPrincipalLoginAsync(ExternalLoginInformation externalLoginInformation, ApiCallback<AuthenticationToken> _callback) throws ApiException {
        Call localVarCall = this.externalPrincipalLoginValidateBeforeCall(externalLoginInformation, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIexternalPrincipalLoginRequest externalPrincipalLogin() {
        return new APIexternalPrincipalLoginRequest();
    }

    private Call getExternalPrincipalCall(String principalId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/external/principals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExternalPrincipalValidateBeforeCall(String principalId, ApiCallback _callback) throws ApiException {
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling getExternalPrincipal(Async)");
        }
        return this.getExternalPrincipalCall(principalId, _callback);
    }

    private ApiResponse<ExternalPrincipal> getExternalPrincipalWithHttpInfo(String principalId) throws ApiException {
        Call localVarCall = this.getExternalPrincipalValidateBeforeCall(principalId, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getExternalPrincipalAsync(String principalId, ApiCallback<ExternalPrincipal> _callback) throws ApiException {
        Call localVarCall = this.getExternalPrincipalValidateBeforeCall(principalId, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetExternalPrincipalRequest getExternalPrincipal(String principalId) {
        return new APIgetExternalPrincipalRequest(principalId);
    }

    private Call hardResetBranchCall(String repository, String branch, String ref, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/hard_reset".replace("{repository}", this.localVarApiClient.escapeString(repository.toString())).replace("{branch}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ref != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ref", ref));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call hardResetBranchValidateBeforeCall(String repository, String branch, String ref, Boolean force, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling hardResetBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling hardResetBranch(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling hardResetBranch(Async)");
        }
        return this.hardResetBranchCall(repository, branch, ref, force, _callback);
    }

    private ApiResponse<Void> hardResetBranchWithHttpInfo(String repository, String branch, String ref, Boolean force) throws ApiException {
        Call localVarCall = this.hardResetBranchValidateBeforeCall(repository, branch, ref, force, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call hardResetBranchAsync(String repository, String branch, String ref, Boolean force, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.hardResetBranchValidateBeforeCall(repository, branch, ref, force, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIhardResetBranchRequest hardResetBranch(String repository, String branch, String ref) {
        return new APIhardResetBranchRequest(repository, branch, ref);
    }

    private Call listUserExternalPrincipalsCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/external/principals/ls".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserExternalPrincipalsValidateBeforeCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserExternalPrincipals(Async)");
        }
        return this.listUserExternalPrincipalsCall(userId, prefix, after, amount, _callback);
    }

    private ApiResponse<ExternalPrincipalList> listUserExternalPrincipalsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUserExternalPrincipalsAsync(String userId, String prefix, String after, Integer amount, ApiCallback<ExternalPrincipalList> _callback) throws ApiException {
        Call localVarCall = this.listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserExternalPrincipalsRequest listUserExternalPrincipals(String userId) {
        return new APIlistUserExternalPrincipalsRequest(userId);
    }

    private Call stsLoginCall(StsAuthRequest stsAuthRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StsAuthRequest localVarPostBody = stsAuthRequest;
        String localVarPath = "/sts/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stsLoginValidateBeforeCall(StsAuthRequest stsAuthRequest, ApiCallback _callback) throws ApiException {
        if (stsAuthRequest == null) {
            throw new ApiException("Missing the required parameter 'stsAuthRequest' when calling stsLogin(Async)");
        }
        return this.stsLoginCall(stsAuthRequest, _callback);
    }

    private ApiResponse<AuthenticationToken> stsLoginWithHttpInfo(StsAuthRequest stsAuthRequest) throws ApiException {
        Call localVarCall = this.stsLoginValidateBeforeCall(stsAuthRequest, null);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call stsLoginAsync(StsAuthRequest stsAuthRequest, ApiCallback<AuthenticationToken> _callback) throws ApiException {
        Call localVarCall = this.stsLoginValidateBeforeCall(stsAuthRequest, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIstsLoginRequest stsLogin(StsAuthRequest stsAuthRequest) {
        return new APIstsLoginRequest(stsAuthRequest);
    }

    public class APIstsLoginRequest {
        private final StsAuthRequest stsAuthRequest;

        private APIstsLoginRequest(StsAuthRequest stsAuthRequest) {
            this.stsAuthRequest = stsAuthRequest;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.stsLoginCall(this.stsAuthRequest, _callback);
        }

        public AuthenticationToken execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.stsLoginWithHttpInfo(this.stsAuthRequest);
            return (AuthenticationToken)localVarResp.getData();
        }

        public ApiResponse<AuthenticationToken> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.stsLoginWithHttpInfo(this.stsAuthRequest);
        }

        public Call executeAsync(ApiCallback<AuthenticationToken> _callback) throws ApiException {
            return ExperimentalApi.this.stsLoginAsync(this.stsAuthRequest, _callback);
        }
    }

    public class APIlistUserExternalPrincipalsRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUserExternalPrincipalsRequest(String userId) {
            this.userId = userId;
        }

        public APIlistUserExternalPrincipalsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistUserExternalPrincipalsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistUserExternalPrincipalsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.listUserExternalPrincipalsCall(this.userId, this.prefix, this.after, this.amount, _callback);
        }

        public ExternalPrincipalList execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.listUserExternalPrincipalsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
            return (ExternalPrincipalList)localVarResp.getData();
        }

        public ApiResponse<ExternalPrincipalList> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.listUserExternalPrincipalsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<ExternalPrincipalList> _callback) throws ApiException {
            return ExperimentalApi.this.listUserExternalPrincipalsAsync(this.userId, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIhardResetBranchRequest {
        private final String repository;
        private final String branch;
        private final String ref;
        private Boolean force;

        private APIhardResetBranchRequest(String repository, String branch, String ref) {
            this.repository = repository;
            this.branch = branch;
            this.ref = ref;
        }

        public APIhardResetBranchRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.hardResetBranchCall(this.repository, this.branch, this.ref, this.force, _callback);
        }

        public void execute() throws ApiException {
            ExperimentalApi.this.hardResetBranchWithHttpInfo(this.repository, this.branch, this.ref, this.force);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.hardResetBranchWithHttpInfo(this.repository, this.branch, this.ref, this.force);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExperimentalApi.this.hardResetBranchAsync(this.repository, this.branch, this.ref, this.force, _callback);
        }
    }

    public class APIgetExternalPrincipalRequest {
        private final String principalId;

        private APIgetExternalPrincipalRequest(String principalId) {
            this.principalId = principalId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.getExternalPrincipalCall(this.principalId, _callback);
        }

        public ExternalPrincipal execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.getExternalPrincipalWithHttpInfo(this.principalId);
            return (ExternalPrincipal)localVarResp.getData();
        }

        public ApiResponse<ExternalPrincipal> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.getExternalPrincipalWithHttpInfo(this.principalId);
        }

        public Call executeAsync(ApiCallback<ExternalPrincipal> _callback) throws ApiException {
            return ExperimentalApi.this.getExternalPrincipalAsync(this.principalId, _callback);
        }
    }

    public class APIexternalPrincipalLoginRequest {
        private ExternalLoginInformation externalLoginInformation;

        private APIexternalPrincipalLoginRequest() {
        }

        public APIexternalPrincipalLoginRequest externalLoginInformation(ExternalLoginInformation externalLoginInformation) {
            this.externalLoginInformation = externalLoginInformation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.externalPrincipalLoginCall(this.externalLoginInformation, _callback);
        }

        public AuthenticationToken execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.externalPrincipalLoginWithHttpInfo(this.externalLoginInformation);
            return (AuthenticationToken)localVarResp.getData();
        }

        public ApiResponse<AuthenticationToken> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.externalPrincipalLoginWithHttpInfo(this.externalLoginInformation);
        }

        public Call executeAsync(ApiCallback<AuthenticationToken> _callback) throws ApiException {
            return ExperimentalApi.this.externalPrincipalLoginAsync(this.externalLoginInformation, _callback);
        }
    }

    public class APIdeleteUserExternalPrincipalRequest {
        private final String userId;
        private final String principalId;

        private APIdeleteUserExternalPrincipalRequest(String userId, String principalId) {
            this.userId = userId;
            this.principalId = principalId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.deleteUserExternalPrincipalCall(this.userId, this.principalId, _callback);
        }

        public void execute() throws ApiException {
            ExperimentalApi.this.deleteUserExternalPrincipalWithHttpInfo(this.userId, this.principalId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.deleteUserExternalPrincipalWithHttpInfo(this.userId, this.principalId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExperimentalApi.this.deleteUserExternalPrincipalAsync(this.userId, this.principalId, _callback);
        }
    }

    public class APIcreateUserExternalPrincipalRequest {
        private final String userId;
        private final String principalId;
        private ExternalPrincipalCreation externalPrincipalCreation;

        private APIcreateUserExternalPrincipalRequest(String userId, String principalId) {
            this.userId = userId;
            this.principalId = principalId;
        }

        public APIcreateUserExternalPrincipalRequest externalPrincipalCreation(ExternalPrincipalCreation externalPrincipalCreation) {
            this.externalPrincipalCreation = externalPrincipalCreation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.createUserExternalPrincipalCall(this.userId, this.principalId, this.externalPrincipalCreation, _callback);
        }

        public void execute() throws ApiException {
            ExperimentalApi.this.createUserExternalPrincipalWithHttpInfo(this.userId, this.principalId, this.externalPrincipalCreation);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.createUserExternalPrincipalWithHttpInfo(this.userId, this.principalId, this.externalPrincipalCreation);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExperimentalApi.this.createUserExternalPrincipalAsync(this.userId, this.principalId, this.externalPrincipalCreation, _callback);
        }
    }

    public class APIcreatePresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String path;
        private Integer parts;

        private APIcreatePresignMultipartUploadRequest(String repository, String branch, String path) {
            this.repository = repository;
            this.branch = branch;
            this.path = path;
        }

        public APIcreatePresignMultipartUploadRequest parts(Integer parts) {
            this.parts = parts;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.createPresignMultipartUploadCall(this.repository, this.branch, this.path, this.parts, _callback);
        }

        public PresignMultipartUpload execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.createPresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.path, this.parts);
            return (PresignMultipartUpload)localVarResp.getData();
        }

        public ApiResponse<PresignMultipartUpload> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.createPresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.path, this.parts);
        }

        public Call executeAsync(ApiCallback<PresignMultipartUpload> _callback) throws ApiException {
            return ExperimentalApi.this.createPresignMultipartUploadAsync(this.repository, this.branch, this.path, this.parts, _callback);
        }
    }

    public class APIcompletePresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String uploadId;
        private final String path;
        private CompletePresignMultipartUpload completePresignMultipartUpload;

        private APIcompletePresignMultipartUploadRequest(String repository, String branch, String uploadId, String path) {
            this.repository = repository;
            this.branch = branch;
            this.uploadId = uploadId;
            this.path = path;
        }

        public APIcompletePresignMultipartUploadRequest completePresignMultipartUpload(CompletePresignMultipartUpload completePresignMultipartUpload) {
            this.completePresignMultipartUpload = completePresignMultipartUpload;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.completePresignMultipartUploadCall(this.repository, this.branch, this.uploadId, this.path, this.completePresignMultipartUpload, _callback);
        }

        public ObjectStats execute() throws ApiException {
            ApiResponse localVarResp = ExperimentalApi.this.completePresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.uploadId, this.path, this.completePresignMultipartUpload);
            return (ObjectStats)localVarResp.getData();
        }

        public ApiResponse<ObjectStats> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.completePresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.uploadId, this.path, this.completePresignMultipartUpload);
        }

        public Call executeAsync(ApiCallback<ObjectStats> _callback) throws ApiException {
            return ExperimentalApi.this.completePresignMultipartUploadAsync(this.repository, this.branch, this.uploadId, this.path, this.completePresignMultipartUpload, _callback);
        }
    }

    public class APIabortPresignMultipartUploadRequest {
        private final String repository;
        private final String branch;
        private final String uploadId;
        private final String path;
        private AbortPresignMultipartUpload abortPresignMultipartUpload;

        private APIabortPresignMultipartUploadRequest(String repository, String branch, String uploadId, String path) {
            this.repository = repository;
            this.branch = branch;
            this.uploadId = uploadId;
            this.path = path;
        }

        public APIabortPresignMultipartUploadRequest abortPresignMultipartUpload(AbortPresignMultipartUpload abortPresignMultipartUpload) {
            this.abortPresignMultipartUpload = abortPresignMultipartUpload;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExperimentalApi.this.abortPresignMultipartUploadCall(this.repository, this.branch, this.uploadId, this.path, this.abortPresignMultipartUpload, _callback);
        }

        public void execute() throws ApiException {
            ExperimentalApi.this.abortPresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.uploadId, this.path, this.abortPresignMultipartUpload);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExperimentalApi.this.abortPresignMultipartUploadWithHttpInfo(this.repository, this.branch, this.uploadId, this.path, this.abortPresignMultipartUpload);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExperimentalApi.this.abortPresignMultipartUploadAsync(this.repository, this.branch, this.uploadId, this.path, this.abortPresignMultipartUpload, _callback);
        }
    }
}

