/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.sdk.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.lakefs.clients.sdk.JSON;

/**
 * CommitRecordCreation
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CommitRecordCreation {
  public static final String SERIALIZED_NAME_COMMIT_ID = "commit_id";
  @SerializedName(SERIALIZED_NAME_COMMIT_ID)
  private String commitId;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private Integer version;

  public static final String SERIALIZED_NAME_COMMITTER = "committer";
  @SerializedName(SERIALIZED_NAME_COMMITTER)
  private String committer;

  public static final String SERIALIZED_NAME_MESSAGE = "message";
  @SerializedName(SERIALIZED_NAME_MESSAGE)
  private String message;

  public static final String SERIALIZED_NAME_METARANGE_ID = "metarange_id";
  @SerializedName(SERIALIZED_NAME_METARANGE_ID)
  private String metarangeId;

  public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
  @SerializedName(SERIALIZED_NAME_CREATION_DATE)
  private Long creationDate;

  public static final String SERIALIZED_NAME_PARENTS = "parents";
  @SerializedName(SERIALIZED_NAME_PARENTS)
  private List<String> parents = new ArrayList<>();

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private Map<String, String> metadata = new HashMap<>();

  public static final String SERIALIZED_NAME_GENERATION = "generation";
  @SerializedName(SERIALIZED_NAME_GENERATION)
  private Long generation;

  public static final String SERIALIZED_NAME_FORCE = "force";
  @SerializedName(SERIALIZED_NAME_FORCE)
  private Boolean force = false;

  public CommitRecordCreation() {
  }

  public CommitRecordCreation commitId(String commitId) {
    
    this.commitId = commitId;
    return this;
  }

   /**
   * id of the commit record
   * @return commitId
  **/
  @javax.annotation.Nonnull
  public String getCommitId() {
    return commitId;
  }


  public void setCommitId(String commitId) {
    this.commitId = commitId;
  }


  public CommitRecordCreation version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * version of the commit record
   * minimum: 0
   * maximum: 1
   * @return version
  **/
  @javax.annotation.Nonnull
  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public CommitRecordCreation committer(String committer) {
    
    this.committer = committer;
    return this;
  }

   /**
   * committer of the commit record
   * @return committer
  **/
  @javax.annotation.Nonnull
  public String getCommitter() {
    return committer;
  }


  public void setCommitter(String committer) {
    this.committer = committer;
  }


  public CommitRecordCreation message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * message of the commit record
   * @return message
  **/
  @javax.annotation.Nonnull
  public String getMessage() {
    return message;
  }


  public void setMessage(String message) {
    this.message = message;
  }


  public CommitRecordCreation metarangeId(String metarangeId) {
    
    this.metarangeId = metarangeId;
    return this;
  }

   /**
   * metarange_id of the commit record
   * @return metarangeId
  **/
  @javax.annotation.Nonnull
  public String getMetarangeId() {
    return metarangeId;
  }


  public void setMetarangeId(String metarangeId) {
    this.metarangeId = metarangeId;
  }


  public CommitRecordCreation creationDate(Long creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * Unix Epoch in seconds
   * @return creationDate
  **/
  @javax.annotation.Nonnull
  public Long getCreationDate() {
    return creationDate;
  }


  public void setCreationDate(Long creationDate) {
    this.creationDate = creationDate;
  }


  public CommitRecordCreation parents(List<String> parents) {
    
    this.parents = parents;
    return this;
  }

  public CommitRecordCreation addParentsItem(String parentsItem) {
    if (this.parents == null) {
      this.parents = new ArrayList<>();
    }
    this.parents.add(parentsItem);
    return this;
  }

   /**
   * parents of the commit record
   * @return parents
  **/
  @javax.annotation.Nonnull
  public List<String> getParents() {
    return parents;
  }


  public void setParents(List<String> parents) {
    this.parents = parents;
  }


  public CommitRecordCreation metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public CommitRecordCreation putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * metadata of the commit record
   * @return metadata
  **/
  @javax.annotation.Nullable
  public Map<String, String> getMetadata() {
    return metadata;
  }


  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public CommitRecordCreation generation(Long generation) {
    
    this.generation = generation;
    return this;
  }

   /**
   * generation of the commit record
   * @return generation
  **/
  @javax.annotation.Nonnull
  public Long getGeneration() {
    return generation;
  }


  public void setGeneration(Long generation) {
    this.generation = generation;
  }


  public CommitRecordCreation force(Boolean force) {
    
    this.force = force;
    return this;
  }

   /**
   * Get force
   * @return force
  **/
  @javax.annotation.Nullable
  public Boolean getForce() {
    return force;
  }


  public void setForce(Boolean force) {
    this.force = force;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the CommitRecordCreation instance itself
   */
  public CommitRecordCreation putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommitRecordCreation commitRecordCreation = (CommitRecordCreation) o;
    return Objects.equals(this.commitId, commitRecordCreation.commitId) &&
        Objects.equals(this.version, commitRecordCreation.version) &&
        Objects.equals(this.committer, commitRecordCreation.committer) &&
        Objects.equals(this.message, commitRecordCreation.message) &&
        Objects.equals(this.metarangeId, commitRecordCreation.metarangeId) &&
        Objects.equals(this.creationDate, commitRecordCreation.creationDate) &&
        Objects.equals(this.parents, commitRecordCreation.parents) &&
        Objects.equals(this.metadata, commitRecordCreation.metadata) &&
        Objects.equals(this.generation, commitRecordCreation.generation) &&
        Objects.equals(this.force, commitRecordCreation.force)&&
        Objects.equals(this.additionalProperties, commitRecordCreation.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(commitId, version, committer, message, metarangeId, creationDate, parents, metadata, generation, force, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommitRecordCreation {\n");
    sb.append("    commitId: ").append(toIndentedString(commitId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    committer: ").append(toIndentedString(committer)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    metarangeId: ").append(toIndentedString(metarangeId)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    parents: ").append(toIndentedString(parents)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    generation: ").append(toIndentedString(generation)).append("\n");
    sb.append("    force: ").append(toIndentedString(force)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("commit_id");
    openapiFields.add("version");
    openapiFields.add("committer");
    openapiFields.add("message");
    openapiFields.add("metarange_id");
    openapiFields.add("creation_date");
    openapiFields.add("parents");
    openapiFields.add("metadata");
    openapiFields.add("generation");
    openapiFields.add("force");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("commit_id");
    openapiRequiredFields.add("version");
    openapiRequiredFields.add("committer");
    openapiRequiredFields.add("message");
    openapiRequiredFields.add("metarange_id");
    openapiRequiredFields.add("creation_date");
    openapiRequiredFields.add("parents");
    openapiRequiredFields.add("generation");
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to CommitRecordCreation
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!CommitRecordCreation.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in CommitRecordCreation is not found in the empty JSON string", CommitRecordCreation.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CommitRecordCreation.openapiRequiredFields) {
        if (jsonElement.getAsJsonObject().get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if (!jsonObj.get("commit_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `commit_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("commit_id").toString()));
      }
      if (!jsonObj.get("committer").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `committer` to be a primitive type in the JSON string but got `%s`", jsonObj.get("committer").toString()));
      }
      if (!jsonObj.get("message").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get("message").toString()));
      }
      if (!jsonObj.get("metarange_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `metarange_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("metarange_id").toString()));
      }
      // ensure the required json array is present
      if (jsonObj.get("parents") == null) {
        throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
      } else if (!jsonObj.get("parents").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `parents` to be an array in the JSON string but got `%s`", jsonObj.get("parents").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CommitRecordCreation.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CommitRecordCreation' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CommitRecordCreation> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CommitRecordCreation.class));

       return (TypeAdapter<T>) new TypeAdapter<CommitRecordCreation>() {
           @Override
           public void write(JsonWriter out, CommitRecordCreation value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additional properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public CommitRecordCreation read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             JsonObject jsonObj = jsonElement.getAsJsonObject();
             // store additional fields in the deserialized instance
             CommitRecordCreation instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CommitRecordCreation given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CommitRecordCreation
  * @throws IOException if the JSON string is invalid with respect to CommitRecordCreation
  */
  public static CommitRecordCreation fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CommitRecordCreation.class);
  }

 /**
  * Convert an instance of CommitRecordCreation to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

