/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.sdk;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.sdk.ApiCallback;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.ApiException;
import io.lakefs.clients.sdk.ApiResponse;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.Pair;
import io.lakefs.clients.sdk.model.ACL;
import io.lakefs.clients.sdk.model.AuthenticationToken;
import io.lakefs.clients.sdk.model.Credentials;
import io.lakefs.clients.sdk.model.CredentialsList;
import io.lakefs.clients.sdk.model.CredentialsWithSecret;
import io.lakefs.clients.sdk.model.CurrentUser;
import io.lakefs.clients.sdk.model.ExternalPrincipal;
import io.lakefs.clients.sdk.model.ExternalPrincipalCreation;
import io.lakefs.clients.sdk.model.ExternalPrincipalList;
import io.lakefs.clients.sdk.model.Group;
import io.lakefs.clients.sdk.model.GroupCreation;
import io.lakefs.clients.sdk.model.GroupList;
import io.lakefs.clients.sdk.model.LoginInformation;
import io.lakefs.clients.sdk.model.Policy;
import io.lakefs.clients.sdk.model.PolicyList;
import io.lakefs.clients.sdk.model.User;
import io.lakefs.clients.sdk.model.UserCreation;
import io.lakefs.clients.sdk.model.UserList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AuthApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call addGroupMembershipCall(String groupId, String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/members/{userId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString())).replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addGroupMembershipValidateBeforeCall(String groupId, String userId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling addGroupMembership(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling addGroupMembership(Async)");
        }
        return this.addGroupMembershipCall(groupId, userId, _callback);
    }

    private ApiResponse<Void> addGroupMembershipWithHttpInfo(String groupId, String userId) throws ApiException {
        Call localVarCall = this.addGroupMembershipValidateBeforeCall(groupId, userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call addGroupMembershipAsync(String groupId, String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.addGroupMembershipValidateBeforeCall(groupId, userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIaddGroupMembershipRequest addGroupMembership(String groupId, String userId) {
        return new APIaddGroupMembershipRequest(groupId, userId);
    }

    private Call attachPolicyToGroupCall(String groupId, String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/policies/{policyId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString())).replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call attachPolicyToGroupValidateBeforeCall(String groupId, String policyId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling attachPolicyToGroup(Async)");
        }
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling attachPolicyToGroup(Async)");
        }
        return this.attachPolicyToGroupCall(groupId, policyId, _callback);
    }

    private ApiResponse<Void> attachPolicyToGroupWithHttpInfo(String groupId, String policyId) throws ApiException {
        Call localVarCall = this.attachPolicyToGroupValidateBeforeCall(groupId, policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call attachPolicyToGroupAsync(String groupId, String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.attachPolicyToGroupValidateBeforeCall(groupId, policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIattachPolicyToGroupRequest attachPolicyToGroup(String groupId, String policyId) {
        return new APIattachPolicyToGroupRequest(groupId, policyId);
    }

    private Call attachPolicyToUserCall(String userId, String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/policies/{policyId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString())).replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call attachPolicyToUserValidateBeforeCall(String userId, String policyId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling attachPolicyToUser(Async)");
        }
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling attachPolicyToUser(Async)");
        }
        return this.attachPolicyToUserCall(userId, policyId, _callback);
    }

    private ApiResponse<Void> attachPolicyToUserWithHttpInfo(String userId, String policyId) throws ApiException {
        Call localVarCall = this.attachPolicyToUserValidateBeforeCall(userId, policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call attachPolicyToUserAsync(String userId, String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.attachPolicyToUserValidateBeforeCall(userId, policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIattachPolicyToUserRequest attachPolicyToUser(String userId, String policyId) {
        return new APIattachPolicyToUserRequest(userId, policyId);
    }

    private Call createCredentialsCall(String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/credentials".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCredentialsValidateBeforeCall(String userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createCredentials(Async)");
        }
        return this.createCredentialsCall(userId, _callback);
    }

    private ApiResponse<CredentialsWithSecret> createCredentialsWithHttpInfo(String userId) throws ApiException {
        Call localVarCall = this.createCredentialsValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createCredentialsAsync(String userId, ApiCallback<CredentialsWithSecret> _callback) throws ApiException {
        Call localVarCall = this.createCredentialsValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateCredentialsRequest createCredentials(String userId) {
        return new APIcreateCredentialsRequest(userId);
    }

    private Call createGroupCall(GroupCreation groupCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupCreation localVarPostBody = groupCreation;
        String localVarPath = "/auth/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGroupValidateBeforeCall(GroupCreation groupCreation, ApiCallback _callback) throws ApiException {
        return this.createGroupCall(groupCreation, _callback);
    }

    private ApiResponse<Group> createGroupWithHttpInfo(GroupCreation groupCreation) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(groupCreation, null);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createGroupAsync(GroupCreation groupCreation, ApiCallback<Group> _callback) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(groupCreation, _callback);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateGroupRequest createGroup() {
        return new APIcreateGroupRequest();
    }

    private Call createPolicyCall(Policy policy, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Policy localVarPostBody = policy;
        String localVarPath = "/auth/policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPolicyValidateBeforeCall(Policy policy, ApiCallback _callback) throws ApiException {
        if (policy == null) {
            throw new ApiException("Missing the required parameter 'policy' when calling createPolicy(Async)");
        }
        return this.createPolicyCall(policy, _callback);
    }

    private ApiResponse<Policy> createPolicyWithHttpInfo(Policy policy) throws ApiException {
        Call localVarCall = this.createPolicyValidateBeforeCall(policy, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createPolicyAsync(Policy policy, ApiCallback<Policy> _callback) throws ApiException {
        Call localVarCall = this.createPolicyValidateBeforeCall(policy, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreatePolicyRequest createPolicy(Policy policy) {
        return new APIcreatePolicyRequest(policy);
    }

    private Call createUserCall(UserCreation userCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UserCreation localVarPostBody = userCreation;
        String localVarPath = "/auth/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserValidateBeforeCall(UserCreation userCreation, ApiCallback _callback) throws ApiException {
        return this.createUserCall(userCreation, _callback);
    }

    private ApiResponse<User> createUserWithHttpInfo(UserCreation userCreation) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(userCreation, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createUserAsync(UserCreation userCreation, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(userCreation, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateUserRequest createUser() {
        return new APIcreateUserRequest();
    }

    private Call createUserExternalPrincipalCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExternalPrincipalCreation localVarPostBody = externalPrincipalCreation;
        String localVarPath = "/auth/users/{userId}/external/principals".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createUserExternalPrincipal(Async)");
        }
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling createUserExternalPrincipal(Async)");
        }
        return this.createUserExternalPrincipalCall(userId, principalId, externalPrincipalCreation, _callback);
    }

    private ApiResponse<Void> createUserExternalPrincipalWithHttpInfo(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation) throws ApiException {
        Call localVarCall = this.createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call createUserExternalPrincipalAsync(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcreateUserExternalPrincipalRequest createUserExternalPrincipal(String userId, String principalId) {
        return new APIcreateUserExternalPrincipalRequest(userId, principalId);
    }

    private Call deleteCredentialsCall(String userId, String accessKeyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/credentials/{accessKeyId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString())).replace("{accessKeyId}", this.localVarApiClient.escapeString(accessKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCredentialsValidateBeforeCall(String userId, String accessKeyId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteCredentials(Async)");
        }
        if (accessKeyId == null) {
            throw new ApiException("Missing the required parameter 'accessKeyId' when calling deleteCredentials(Async)");
        }
        return this.deleteCredentialsCall(userId, accessKeyId, _callback);
    }

    private ApiResponse<Void> deleteCredentialsWithHttpInfo(String userId, String accessKeyId) throws ApiException {
        Call localVarCall = this.deleteCredentialsValidateBeforeCall(userId, accessKeyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteCredentialsAsync(String userId, String accessKeyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCredentialsValidateBeforeCall(userId, accessKeyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteCredentialsRequest deleteCredentials(String userId, String accessKeyId) {
        return new APIdeleteCredentialsRequest(userId, accessKeyId);
    }

    private Call deleteGroupCall(String groupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupValidateBeforeCall(String groupId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroup(Async)");
        }
        return this.deleteGroupCall(groupId, _callback);
    }

    private ApiResponse<Void> deleteGroupWithHttpInfo(String groupId) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteGroupAsync(String groupId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteGroupRequest deleteGroup(String groupId) {
        return new APIdeleteGroupRequest(groupId);
    }

    private Call deleteGroupMembershipCall(String groupId, String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/members/{userId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString())).replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupMembershipValidateBeforeCall(String groupId, String userId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroupMembership(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteGroupMembership(Async)");
        }
        return this.deleteGroupMembershipCall(groupId, userId, _callback);
    }

    private ApiResponse<Void> deleteGroupMembershipWithHttpInfo(String groupId, String userId) throws ApiException {
        Call localVarCall = this.deleteGroupMembershipValidateBeforeCall(groupId, userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteGroupMembershipAsync(String groupId, String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupMembershipValidateBeforeCall(groupId, userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteGroupMembershipRequest deleteGroupMembership(String groupId, String userId) {
        return new APIdeleteGroupMembershipRequest(groupId, userId);
    }

    private Call deletePolicyCall(String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/policies/{policyId}".replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePolicyValidateBeforeCall(String policyId, ApiCallback _callback) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling deletePolicy(Async)");
        }
        return this.deletePolicyCall(policyId, _callback);
    }

    private ApiResponse<Void> deletePolicyWithHttpInfo(String policyId) throws ApiException {
        Call localVarCall = this.deletePolicyValidateBeforeCall(policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deletePolicyAsync(String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deletePolicyValidateBeforeCall(policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeletePolicyRequest deletePolicy(String policyId) {
        return new APIdeletePolicyRequest(policyId);
    }

    private Call deleteUserCall(String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserValidateBeforeCall(String userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUser(Async)");
        }
        return this.deleteUserCall(userId, _callback);
    }

    private ApiResponse<Void> deleteUserWithHttpInfo(String userId) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteUserAsync(String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteUserRequest deleteUser(String userId) {
        return new APIdeleteUserRequest(userId);
    }

    private Call deleteUserExternalPrincipalCall(String userId, String principalId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/external/principals".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUserExternalPrincipal(Async)");
        }
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling deleteUserExternalPrincipal(Async)");
        }
        return this.deleteUserExternalPrincipalCall(userId, principalId, _callback);
    }

    private ApiResponse<Void> deleteUserExternalPrincipalWithHttpInfo(String userId, String principalId) throws ApiException {
        Call localVarCall = this.deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteUserExternalPrincipalAsync(String userId, String principalId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdeleteUserExternalPrincipalRequest deleteUserExternalPrincipal(String userId, String principalId) {
        return new APIdeleteUserExternalPrincipalRequest(userId, principalId);
    }

    private Call detachPolicyFromGroupCall(String groupId, String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/policies/{policyId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString())).replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call detachPolicyFromGroupValidateBeforeCall(String groupId, String policyId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling detachPolicyFromGroup(Async)");
        }
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling detachPolicyFromGroup(Async)");
        }
        return this.detachPolicyFromGroupCall(groupId, policyId, _callback);
    }

    private ApiResponse<Void> detachPolicyFromGroupWithHttpInfo(String groupId, String policyId) throws ApiException {
        Call localVarCall = this.detachPolicyFromGroupValidateBeforeCall(groupId, policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call detachPolicyFromGroupAsync(String groupId, String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.detachPolicyFromGroupValidateBeforeCall(groupId, policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdetachPolicyFromGroupRequest detachPolicyFromGroup(String groupId, String policyId) {
        return new APIdetachPolicyFromGroupRequest(groupId, policyId);
    }

    private Call detachPolicyFromUserCall(String userId, String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/policies/{policyId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString())).replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call detachPolicyFromUserValidateBeforeCall(String userId, String policyId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling detachPolicyFromUser(Async)");
        }
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling detachPolicyFromUser(Async)");
        }
        return this.detachPolicyFromUserCall(userId, policyId, _callback);
    }

    private ApiResponse<Void> detachPolicyFromUserWithHttpInfo(String userId, String policyId) throws ApiException {
        Call localVarCall = this.detachPolicyFromUserValidateBeforeCall(userId, policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call detachPolicyFromUserAsync(String userId, String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.detachPolicyFromUserValidateBeforeCall(userId, policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIdetachPolicyFromUserRequest detachPolicyFromUser(String userId, String policyId) {
        return new APIdetachPolicyFromUserRequest(userId, policyId);
    }

    private Call getCredentialsCall(String userId, String accessKeyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/credentials/{accessKeyId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString())).replace("{accessKeyId}", this.localVarApiClient.escapeString(accessKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCredentialsValidateBeforeCall(String userId, String accessKeyId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getCredentials(Async)");
        }
        if (accessKeyId == null) {
            throw new ApiException("Missing the required parameter 'accessKeyId' when calling getCredentials(Async)");
        }
        return this.getCredentialsCall(userId, accessKeyId, _callback);
    }

    private ApiResponse<Credentials> getCredentialsWithHttpInfo(String userId, String accessKeyId) throws ApiException {
        Call localVarCall = this.getCredentialsValidateBeforeCall(userId, accessKeyId, null);
        Type localVarReturnType = new TypeToken<Credentials>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCredentialsAsync(String userId, String accessKeyId, ApiCallback<Credentials> _callback) throws ApiException {
        Call localVarCall = this.getCredentialsValidateBeforeCall(userId, accessKeyId, _callback);
        Type localVarReturnType = new TypeToken<Credentials>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetCredentialsRequest getCredentials(String userId, String accessKeyId) {
        return new APIgetCredentialsRequest(userId, accessKeyId);
    }

    private Call getCurrentUserCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCurrentUserValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getCurrentUserCall(_callback);
    }

    private ApiResponse<CurrentUser> getCurrentUserWithHttpInfo() throws ApiException {
        Call localVarCall = this.getCurrentUserValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CurrentUser>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCurrentUserAsync(ApiCallback<CurrentUser> _callback) throws ApiException {
        Call localVarCall = this.getCurrentUserValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CurrentUser>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetCurrentUserRequest getCurrentUser() {
        return new APIgetCurrentUserRequest();
    }

    private Call getExternalPrincipalCall(String principalId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/external/principals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExternalPrincipalValidateBeforeCall(String principalId, ApiCallback _callback) throws ApiException {
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling getExternalPrincipal(Async)");
        }
        return this.getExternalPrincipalCall(principalId, _callback);
    }

    private ApiResponse<ExternalPrincipal> getExternalPrincipalWithHttpInfo(String principalId) throws ApiException {
        Call localVarCall = this.getExternalPrincipalValidateBeforeCall(principalId, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getExternalPrincipalAsync(String principalId, ApiCallback<ExternalPrincipal> _callback) throws ApiException {
        Call localVarCall = this.getExternalPrincipalValidateBeforeCall(principalId, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetExternalPrincipalRequest getExternalPrincipal(String principalId) {
        return new APIgetExternalPrincipalRequest(principalId);
    }

    private Call getGroupCall(String groupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupValidateBeforeCall(String groupId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroup(Async)");
        }
        return this.getGroupCall(groupId, _callback);
    }

    private ApiResponse<Group> getGroupWithHttpInfo(String groupId) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getGroupAsync(String groupId, ApiCallback<Group> _callback) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetGroupRequest getGroup(String groupId) {
        return new APIgetGroupRequest(groupId);
    }

    private Call getGroupACLCall(String groupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/acl".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupACLValidateBeforeCall(String groupId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroupACL(Async)");
        }
        return this.getGroupACLCall(groupId, _callback);
    }

    private ApiResponse<ACL> getGroupACLWithHttpInfo(String groupId) throws ApiException {
        Call localVarCall = this.getGroupACLValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<ACL>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getGroupACLAsync(String groupId, ApiCallback<ACL> _callback) throws ApiException {
        Call localVarCall = this.getGroupACLValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<ACL>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetGroupACLRequest getGroupACL(String groupId) {
        return new APIgetGroupACLRequest(groupId);
    }

    private Call getPolicyCall(String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/policies/{policyId}".replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPolicyValidateBeforeCall(String policyId, ApiCallback _callback) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling getPolicy(Async)");
        }
        return this.getPolicyCall(policyId, _callback);
    }

    private ApiResponse<Policy> getPolicyWithHttpInfo(String policyId) throws ApiException {
        Call localVarCall = this.getPolicyValidateBeforeCall(policyId, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPolicyAsync(String policyId, ApiCallback<Policy> _callback) throws ApiException {
        Call localVarCall = this.getPolicyValidateBeforeCall(policyId, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetPolicyRequest getPolicy(String policyId) {
        return new APIgetPolicyRequest(policyId);
    }

    private Call getUserCall(String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserValidateBeforeCall(String userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUser(Async)");
        }
        return this.getUserCall(userId, _callback);
    }

    private ApiResponse<User> getUserWithHttpInfo(String userId) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getUserAsync(String userId, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetUserRequest getUser(String userId) {
        return new APIgetUserRequest(userId);
    }

    private Call listGroupMembersCall(String groupId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/members".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listGroupMembersValidateBeforeCall(String groupId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling listGroupMembers(Async)");
        }
        return this.listGroupMembersCall(groupId, prefix, after, amount, _callback);
    }

    private ApiResponse<UserList> listGroupMembersWithHttpInfo(String groupId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listGroupMembersValidateBeforeCall(groupId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listGroupMembersAsync(String groupId, String prefix, String after, Integer amount, ApiCallback<UserList> _callback) throws ApiException {
        Call localVarCall = this.listGroupMembersValidateBeforeCall(groupId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistGroupMembersRequest listGroupMembers(String groupId) {
        return new APIlistGroupMembersRequest(groupId);
    }

    private Call listGroupPoliciesCall(String groupId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/policies".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listGroupPoliciesValidateBeforeCall(String groupId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling listGroupPolicies(Async)");
        }
        return this.listGroupPoliciesCall(groupId, prefix, after, amount, _callback);
    }

    private ApiResponse<PolicyList> listGroupPoliciesWithHttpInfo(String groupId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listGroupPoliciesValidateBeforeCall(groupId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listGroupPoliciesAsync(String groupId, String prefix, String after, Integer amount, ApiCallback<PolicyList> _callback) throws ApiException {
        Call localVarCall = this.listGroupPoliciesValidateBeforeCall(groupId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistGroupPoliciesRequest listGroupPolicies(String groupId) {
        return new APIlistGroupPoliciesRequest(groupId);
    }

    private Call listGroupsCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listGroupsValidateBeforeCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        return this.listGroupsCall(prefix, after, amount, _callback);
    }

    private ApiResponse<GroupList> listGroupsWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listGroupsValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listGroupsAsync(String prefix, String after, Integer amount, ApiCallback<GroupList> _callback) throws ApiException {
        Call localVarCall = this.listGroupsValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistGroupsRequest listGroups() {
        return new APIlistGroupsRequest();
    }

    private Call listPoliciesCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPoliciesValidateBeforeCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        return this.listPoliciesCall(prefix, after, amount, _callback);
    }

    private ApiResponse<PolicyList> listPoliciesWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listPoliciesValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listPoliciesAsync(String prefix, String after, Integer amount, ApiCallback<PolicyList> _callback) throws ApiException {
        Call localVarCall = this.listPoliciesValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistPoliciesRequest listPolicies() {
        return new APIlistPoliciesRequest();
    }

    private Call listUserCredentialsCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/credentials".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserCredentialsValidateBeforeCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserCredentials(Async)");
        }
        return this.listUserCredentialsCall(userId, prefix, after, amount, _callback);
    }

    private ApiResponse<CredentialsList> listUserCredentialsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUserCredentialsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<CredentialsList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUserCredentialsAsync(String userId, String prefix, String after, Integer amount, ApiCallback<CredentialsList> _callback) throws ApiException {
        Call localVarCall = this.listUserCredentialsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<CredentialsList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserCredentialsRequest listUserCredentials(String userId) {
        return new APIlistUserCredentialsRequest(userId);
    }

    private Call listUserExternalPrincipalsCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/external/principals/ls".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserExternalPrincipalsValidateBeforeCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserExternalPrincipals(Async)");
        }
        return this.listUserExternalPrincipalsCall(userId, prefix, after, amount, _callback);
    }

    private ApiResponse<ExternalPrincipalList> listUserExternalPrincipalsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUserExternalPrincipalsAsync(String userId, String prefix, String after, Integer amount, ApiCallback<ExternalPrincipalList> _callback) throws ApiException {
        Call localVarCall = this.listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserExternalPrincipalsRequest listUserExternalPrincipals(String userId) {
        return new APIlistUserExternalPrincipalsRequest(userId);
    }

    private Call listUserGroupsCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/groups".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserGroupsValidateBeforeCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserGroups(Async)");
        }
        return this.listUserGroupsCall(userId, prefix, after, amount, _callback);
    }

    private ApiResponse<GroupList> listUserGroupsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUserGroupsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUserGroupsAsync(String userId, String prefix, String after, Integer amount, ApiCallback<GroupList> _callback) throws ApiException {
        Call localVarCall = this.listUserGroupsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserGroupsRequest listUserGroups(String userId) {
        return new APIlistUserGroupsRequest(userId);
    }

    private Call listUserPoliciesCall(String userId, String prefix, String after, Integer amount, Boolean effective, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/policies".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (effective != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("effective", effective));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserPoliciesValidateBeforeCall(String userId, String prefix, String after, Integer amount, Boolean effective, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserPolicies(Async)");
        }
        return this.listUserPoliciesCall(userId, prefix, after, amount, effective, _callback);
    }

    private ApiResponse<PolicyList> listUserPoliciesWithHttpInfo(String userId, String prefix, String after, Integer amount, Boolean effective) throws ApiException {
        Call localVarCall = this.listUserPoliciesValidateBeforeCall(userId, prefix, after, amount, effective, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUserPoliciesAsync(String userId, String prefix, String after, Integer amount, Boolean effective, ApiCallback<PolicyList> _callback) throws ApiException {
        Call localVarCall = this.listUserPoliciesValidateBeforeCall(userId, prefix, after, amount, effective, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUserPoliciesRequest listUserPolicies(String userId) {
        return new APIlistUserPoliciesRequest(userId);
    }

    private Call listUsersCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUsersValidateBeforeCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        return this.listUsersCall(prefix, after, amount, _callback);
    }

    private ApiResponse<UserList> listUsersWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUsersValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listUsersAsync(String prefix, String after, Integer amount, ApiCallback<UserList> _callback) throws ApiException {
        Call localVarCall = this.listUsersValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistUsersRequest listUsers() {
        return new APIlistUsersRequest();
    }

    private Call loginCall(LoginInformation loginInformation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        LoginInformation localVarPostBody = loginInformation;
        String localVarPath = "/auth/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call loginValidateBeforeCall(LoginInformation loginInformation, ApiCallback _callback) throws ApiException {
        return this.loginCall(loginInformation, _callback);
    }

    private ApiResponse<AuthenticationToken> loginWithHttpInfo(LoginInformation loginInformation) throws ApiException {
        Call localVarCall = this.loginValidateBeforeCall(loginInformation, null);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call loginAsync(LoginInformation loginInformation, ApiCallback<AuthenticationToken> _callback) throws ApiException {
        Call localVarCall = this.loginValidateBeforeCall(loginInformation, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIloginRequest login() {
        return new APIloginRequest();
    }

    private Call setGroupACLCall(String groupId, ACL ACL2, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ACL localVarPostBody = ACL2;
        String localVarPath = "/auth/groups/{groupId}/acl".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setGroupACLValidateBeforeCall(String groupId, ACL ACL2, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling setGroupACL(Async)");
        }
        if (ACL2 == null) {
            throw new ApiException("Missing the required parameter 'ACL' when calling setGroupACL(Async)");
        }
        return this.setGroupACLCall(groupId, ACL2, _callback);
    }

    private ApiResponse<Void> setGroupACLWithHttpInfo(String groupId, ACL ACL2) throws ApiException {
        Call localVarCall = this.setGroupACLValidateBeforeCall(groupId, ACL2, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call setGroupACLAsync(String groupId, ACL ACL2, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setGroupACLValidateBeforeCall(groupId, ACL2, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsetGroupACLRequest setGroupACL(String groupId, ACL ACL2) {
        return new APIsetGroupACLRequest(groupId, ACL2);
    }

    private Call updatePolicyCall(String policyId, Policy policy, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Policy localVarPostBody = policy;
        String localVarPath = "/auth/policies/{policyId}".replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePolicyValidateBeforeCall(String policyId, Policy policy, ApiCallback _callback) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling updatePolicy(Async)");
        }
        if (policy == null) {
            throw new ApiException("Missing the required parameter 'policy' when calling updatePolicy(Async)");
        }
        return this.updatePolicyCall(policyId, policy, _callback);
    }

    private ApiResponse<Policy> updatePolicyWithHttpInfo(String policyId, Policy policy) throws ApiException {
        Call localVarCall = this.updatePolicyValidateBeforeCall(policyId, policy, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updatePolicyAsync(String policyId, Policy policy, ApiCallback<Policy> _callback) throws ApiException {
        Call localVarCall = this.updatePolicyValidateBeforeCall(policyId, policy, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIupdatePolicyRequest updatePolicy(String policyId, Policy policy) {
        return new APIupdatePolicyRequest(policyId, policy);
    }

    public class APIupdatePolicyRequest {
        private final String policyId;
        private final Policy policy;

        private APIupdatePolicyRequest(String policyId, Policy policy) {
            this.policyId = policyId;
            this.policy = policy;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.updatePolicyCall(this.policyId, this.policy, _callback);
        }

        public Policy execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.updatePolicyWithHttpInfo(this.policyId, this.policy);
            return (Policy)localVarResp.getData();
        }

        public ApiResponse<Policy> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.updatePolicyWithHttpInfo(this.policyId, this.policy);
        }

        public Call executeAsync(ApiCallback<Policy> _callback) throws ApiException {
            return AuthApi.this.updatePolicyAsync(this.policyId, this.policy, _callback);
        }
    }

    public class APIsetGroupACLRequest {
        private final String groupId;
        private final ACL ACL;

        private APIsetGroupACLRequest(String groupId, ACL ACL2) {
            this.groupId = groupId;
            this.ACL = ACL2;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.setGroupACLCall(this.groupId, this.ACL, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.setGroupACLWithHttpInfo(this.groupId, this.ACL);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.setGroupACLWithHttpInfo(this.groupId, this.ACL);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.setGroupACLAsync(this.groupId, this.ACL, _callback);
        }
    }

    public class APIloginRequest {
        private LoginInformation loginInformation;

        private APIloginRequest() {
        }

        public APIloginRequest loginInformation(LoginInformation loginInformation) {
            this.loginInformation = loginInformation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.loginCall(this.loginInformation, _callback);
        }

        public AuthenticationToken execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.loginWithHttpInfo(this.loginInformation);
            return (AuthenticationToken)localVarResp.getData();
        }

        public ApiResponse<AuthenticationToken> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.loginWithHttpInfo(this.loginInformation);
        }

        public Call executeAsync(ApiCallback<AuthenticationToken> _callback) throws ApiException {
            return AuthApi.this.loginAsync(this.loginInformation, _callback);
        }
    }

    public class APIlistUsersRequest {
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUsersRequest() {
        }

        public APIlistUsersRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistUsersRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistUsersRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listUsersCall(this.prefix, this.after, this.amount, _callback);
        }

        public UserList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listUsersWithHttpInfo(this.prefix, this.after, this.amount);
            return (UserList)localVarResp.getData();
        }

        public ApiResponse<UserList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listUsersWithHttpInfo(this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<UserList> _callback) throws ApiException {
            return AuthApi.this.listUsersAsync(this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIlistUserPoliciesRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;
        private Boolean effective;

        private APIlistUserPoliciesRequest(String userId) {
            this.userId = userId;
        }

        public APIlistUserPoliciesRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistUserPoliciesRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistUserPoliciesRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public APIlistUserPoliciesRequest effective(Boolean effective) {
            this.effective = effective;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listUserPoliciesCall(this.userId, this.prefix, this.after, this.amount, this.effective, _callback);
        }

        public PolicyList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listUserPoliciesWithHttpInfo(this.userId, this.prefix, this.after, this.amount, this.effective);
            return (PolicyList)localVarResp.getData();
        }

        public ApiResponse<PolicyList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listUserPoliciesWithHttpInfo(this.userId, this.prefix, this.after, this.amount, this.effective);
        }

        public Call executeAsync(ApiCallback<PolicyList> _callback) throws ApiException {
            return AuthApi.this.listUserPoliciesAsync(this.userId, this.prefix, this.after, this.amount, this.effective, _callback);
        }
    }

    public class APIlistUserGroupsRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUserGroupsRequest(String userId) {
            this.userId = userId;
        }

        public APIlistUserGroupsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistUserGroupsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistUserGroupsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listUserGroupsCall(this.userId, this.prefix, this.after, this.amount, _callback);
        }

        public GroupList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listUserGroupsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
            return (GroupList)localVarResp.getData();
        }

        public ApiResponse<GroupList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listUserGroupsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<GroupList> _callback) throws ApiException {
            return AuthApi.this.listUserGroupsAsync(this.userId, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIlistUserExternalPrincipalsRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUserExternalPrincipalsRequest(String userId) {
            this.userId = userId;
        }

        public APIlistUserExternalPrincipalsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistUserExternalPrincipalsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistUserExternalPrincipalsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listUserExternalPrincipalsCall(this.userId, this.prefix, this.after, this.amount, _callback);
        }

        public ExternalPrincipalList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listUserExternalPrincipalsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
            return (ExternalPrincipalList)localVarResp.getData();
        }

        public ApiResponse<ExternalPrincipalList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listUserExternalPrincipalsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<ExternalPrincipalList> _callback) throws ApiException {
            return AuthApi.this.listUserExternalPrincipalsAsync(this.userId, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIlistUserCredentialsRequest {
        private final String userId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistUserCredentialsRequest(String userId) {
            this.userId = userId;
        }

        public APIlistUserCredentialsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistUserCredentialsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistUserCredentialsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listUserCredentialsCall(this.userId, this.prefix, this.after, this.amount, _callback);
        }

        public CredentialsList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listUserCredentialsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
            return (CredentialsList)localVarResp.getData();
        }

        public ApiResponse<CredentialsList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listUserCredentialsWithHttpInfo(this.userId, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<CredentialsList> _callback) throws ApiException {
            return AuthApi.this.listUserCredentialsAsync(this.userId, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIlistPoliciesRequest {
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistPoliciesRequest() {
        }

        public APIlistPoliciesRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistPoliciesRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistPoliciesRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listPoliciesCall(this.prefix, this.after, this.amount, _callback);
        }

        public PolicyList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listPoliciesWithHttpInfo(this.prefix, this.after, this.amount);
            return (PolicyList)localVarResp.getData();
        }

        public ApiResponse<PolicyList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listPoliciesWithHttpInfo(this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<PolicyList> _callback) throws ApiException {
            return AuthApi.this.listPoliciesAsync(this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIlistGroupsRequest {
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistGroupsRequest() {
        }

        public APIlistGroupsRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistGroupsRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistGroupsRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listGroupsCall(this.prefix, this.after, this.amount, _callback);
        }

        public GroupList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listGroupsWithHttpInfo(this.prefix, this.after, this.amount);
            return (GroupList)localVarResp.getData();
        }

        public ApiResponse<GroupList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listGroupsWithHttpInfo(this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<GroupList> _callback) throws ApiException {
            return AuthApi.this.listGroupsAsync(this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIlistGroupPoliciesRequest {
        private final String groupId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistGroupPoliciesRequest(String groupId) {
            this.groupId = groupId;
        }

        public APIlistGroupPoliciesRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistGroupPoliciesRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistGroupPoliciesRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listGroupPoliciesCall(this.groupId, this.prefix, this.after, this.amount, _callback);
        }

        public PolicyList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listGroupPoliciesWithHttpInfo(this.groupId, this.prefix, this.after, this.amount);
            return (PolicyList)localVarResp.getData();
        }

        public ApiResponse<PolicyList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listGroupPoliciesWithHttpInfo(this.groupId, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<PolicyList> _callback) throws ApiException {
            return AuthApi.this.listGroupPoliciesAsync(this.groupId, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIlistGroupMembersRequest {
        private final String groupId;
        private String prefix;
        private String after;
        private Integer amount;

        private APIlistGroupMembersRequest(String groupId) {
            this.groupId = groupId;
        }

        public APIlistGroupMembersRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public APIlistGroupMembersRequest after(String after) {
            this.after = after;
            return this;
        }

        public APIlistGroupMembersRequest amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.listGroupMembersCall(this.groupId, this.prefix, this.after, this.amount, _callback);
        }

        public UserList execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.listGroupMembersWithHttpInfo(this.groupId, this.prefix, this.after, this.amount);
            return (UserList)localVarResp.getData();
        }

        public ApiResponse<UserList> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.listGroupMembersWithHttpInfo(this.groupId, this.prefix, this.after, this.amount);
        }

        public Call executeAsync(ApiCallback<UserList> _callback) throws ApiException {
            return AuthApi.this.listGroupMembersAsync(this.groupId, this.prefix, this.after, this.amount, _callback);
        }
    }

    public class APIgetUserRequest {
        private final String userId;

        private APIgetUserRequest(String userId) {
            this.userId = userId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.getUserCall(this.userId, _callback);
        }

        public User execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.getUserWithHttpInfo(this.userId);
            return (User)localVarResp.getData();
        }

        public ApiResponse<User> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.getUserWithHttpInfo(this.userId);
        }

        public Call executeAsync(ApiCallback<User> _callback) throws ApiException {
            return AuthApi.this.getUserAsync(this.userId, _callback);
        }
    }

    public class APIgetPolicyRequest {
        private final String policyId;

        private APIgetPolicyRequest(String policyId) {
            this.policyId = policyId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.getPolicyCall(this.policyId, _callback);
        }

        public Policy execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.getPolicyWithHttpInfo(this.policyId);
            return (Policy)localVarResp.getData();
        }

        public ApiResponse<Policy> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.getPolicyWithHttpInfo(this.policyId);
        }

        public Call executeAsync(ApiCallback<Policy> _callback) throws ApiException {
            return AuthApi.this.getPolicyAsync(this.policyId, _callback);
        }
    }

    public class APIgetGroupACLRequest {
        private final String groupId;

        private APIgetGroupACLRequest(String groupId) {
            this.groupId = groupId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.getGroupACLCall(this.groupId, _callback);
        }

        public ACL execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.getGroupACLWithHttpInfo(this.groupId);
            return (ACL)localVarResp.getData();
        }

        public ApiResponse<ACL> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.getGroupACLWithHttpInfo(this.groupId);
        }

        public Call executeAsync(ApiCallback<ACL> _callback) throws ApiException {
            return AuthApi.this.getGroupACLAsync(this.groupId, _callback);
        }
    }

    public class APIgetGroupRequest {
        private final String groupId;

        private APIgetGroupRequest(String groupId) {
            this.groupId = groupId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.getGroupCall(this.groupId, _callback);
        }

        public Group execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.getGroupWithHttpInfo(this.groupId);
            return (Group)localVarResp.getData();
        }

        public ApiResponse<Group> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.getGroupWithHttpInfo(this.groupId);
        }

        public Call executeAsync(ApiCallback<Group> _callback) throws ApiException {
            return AuthApi.this.getGroupAsync(this.groupId, _callback);
        }
    }

    public class APIgetExternalPrincipalRequest {
        private final String principalId;

        private APIgetExternalPrincipalRequest(String principalId) {
            this.principalId = principalId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.getExternalPrincipalCall(this.principalId, _callback);
        }

        public ExternalPrincipal execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.getExternalPrincipalWithHttpInfo(this.principalId);
            return (ExternalPrincipal)localVarResp.getData();
        }

        public ApiResponse<ExternalPrincipal> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.getExternalPrincipalWithHttpInfo(this.principalId);
        }

        public Call executeAsync(ApiCallback<ExternalPrincipal> _callback) throws ApiException {
            return AuthApi.this.getExternalPrincipalAsync(this.principalId, _callback);
        }
    }

    public class APIgetCurrentUserRequest {
        private APIgetCurrentUserRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.getCurrentUserCall(_callback);
        }

        public CurrentUser execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.getCurrentUserWithHttpInfo();
            return (CurrentUser)localVarResp.getData();
        }

        public ApiResponse<CurrentUser> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.getCurrentUserWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<CurrentUser> _callback) throws ApiException {
            return AuthApi.this.getCurrentUserAsync(_callback);
        }
    }

    public class APIgetCredentialsRequest {
        private final String userId;
        private final String accessKeyId;

        private APIgetCredentialsRequest(String userId, String accessKeyId) {
            this.userId = userId;
            this.accessKeyId = accessKeyId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.getCredentialsCall(this.userId, this.accessKeyId, _callback);
        }

        public Credentials execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.getCredentialsWithHttpInfo(this.userId, this.accessKeyId);
            return (Credentials)localVarResp.getData();
        }

        public ApiResponse<Credentials> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.getCredentialsWithHttpInfo(this.userId, this.accessKeyId);
        }

        public Call executeAsync(ApiCallback<Credentials> _callback) throws ApiException {
            return AuthApi.this.getCredentialsAsync(this.userId, this.accessKeyId, _callback);
        }
    }

    public class APIdetachPolicyFromUserRequest {
        private final String userId;
        private final String policyId;

        private APIdetachPolicyFromUserRequest(String userId, String policyId) {
            this.userId = userId;
            this.policyId = policyId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.detachPolicyFromUserCall(this.userId, this.policyId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.detachPolicyFromUserWithHttpInfo(this.userId, this.policyId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.detachPolicyFromUserWithHttpInfo(this.userId, this.policyId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.detachPolicyFromUserAsync(this.userId, this.policyId, _callback);
        }
    }

    public class APIdetachPolicyFromGroupRequest {
        private final String groupId;
        private final String policyId;

        private APIdetachPolicyFromGroupRequest(String groupId, String policyId) {
            this.groupId = groupId;
            this.policyId = policyId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.detachPolicyFromGroupCall(this.groupId, this.policyId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.detachPolicyFromGroupWithHttpInfo(this.groupId, this.policyId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.detachPolicyFromGroupWithHttpInfo(this.groupId, this.policyId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.detachPolicyFromGroupAsync(this.groupId, this.policyId, _callback);
        }
    }

    public class APIdeleteUserExternalPrincipalRequest {
        private final String userId;
        private final String principalId;

        private APIdeleteUserExternalPrincipalRequest(String userId, String principalId) {
            this.userId = userId;
            this.principalId = principalId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.deleteUserExternalPrincipalCall(this.userId, this.principalId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.deleteUserExternalPrincipalWithHttpInfo(this.userId, this.principalId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.deleteUserExternalPrincipalWithHttpInfo(this.userId, this.principalId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.deleteUserExternalPrincipalAsync(this.userId, this.principalId, _callback);
        }
    }

    public class APIdeleteUserRequest {
        private final String userId;

        private APIdeleteUserRequest(String userId) {
            this.userId = userId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.deleteUserCall(this.userId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.deleteUserWithHttpInfo(this.userId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.deleteUserWithHttpInfo(this.userId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.deleteUserAsync(this.userId, _callback);
        }
    }

    public class APIdeletePolicyRequest {
        private final String policyId;

        private APIdeletePolicyRequest(String policyId) {
            this.policyId = policyId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.deletePolicyCall(this.policyId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.deletePolicyWithHttpInfo(this.policyId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.deletePolicyWithHttpInfo(this.policyId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.deletePolicyAsync(this.policyId, _callback);
        }
    }

    public class APIdeleteGroupMembershipRequest {
        private final String groupId;
        private final String userId;

        private APIdeleteGroupMembershipRequest(String groupId, String userId) {
            this.groupId = groupId;
            this.userId = userId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.deleteGroupMembershipCall(this.groupId, this.userId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.deleteGroupMembershipWithHttpInfo(this.groupId, this.userId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.deleteGroupMembershipWithHttpInfo(this.groupId, this.userId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.deleteGroupMembershipAsync(this.groupId, this.userId, _callback);
        }
    }

    public class APIdeleteGroupRequest {
        private final String groupId;

        private APIdeleteGroupRequest(String groupId) {
            this.groupId = groupId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.deleteGroupCall(this.groupId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.deleteGroupWithHttpInfo(this.groupId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.deleteGroupWithHttpInfo(this.groupId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.deleteGroupAsync(this.groupId, _callback);
        }
    }

    public class APIdeleteCredentialsRequest {
        private final String userId;
        private final String accessKeyId;

        private APIdeleteCredentialsRequest(String userId, String accessKeyId) {
            this.userId = userId;
            this.accessKeyId = accessKeyId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.deleteCredentialsCall(this.userId, this.accessKeyId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.deleteCredentialsWithHttpInfo(this.userId, this.accessKeyId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.deleteCredentialsWithHttpInfo(this.userId, this.accessKeyId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.deleteCredentialsAsync(this.userId, this.accessKeyId, _callback);
        }
    }

    public class APIcreateUserExternalPrincipalRequest {
        private final String userId;
        private final String principalId;
        private ExternalPrincipalCreation externalPrincipalCreation;

        private APIcreateUserExternalPrincipalRequest(String userId, String principalId) {
            this.userId = userId;
            this.principalId = principalId;
        }

        public APIcreateUserExternalPrincipalRequest externalPrincipalCreation(ExternalPrincipalCreation externalPrincipalCreation) {
            this.externalPrincipalCreation = externalPrincipalCreation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.createUserExternalPrincipalCall(this.userId, this.principalId, this.externalPrincipalCreation, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.createUserExternalPrincipalWithHttpInfo(this.userId, this.principalId, this.externalPrincipalCreation);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.createUserExternalPrincipalWithHttpInfo(this.userId, this.principalId, this.externalPrincipalCreation);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.createUserExternalPrincipalAsync(this.userId, this.principalId, this.externalPrincipalCreation, _callback);
        }
    }

    public class APIcreateUserRequest {
        private UserCreation userCreation;

        private APIcreateUserRequest() {
        }

        public APIcreateUserRequest userCreation(UserCreation userCreation) {
            this.userCreation = userCreation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.createUserCall(this.userCreation, _callback);
        }

        public User execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.createUserWithHttpInfo(this.userCreation);
            return (User)localVarResp.getData();
        }

        public ApiResponse<User> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.createUserWithHttpInfo(this.userCreation);
        }

        public Call executeAsync(ApiCallback<User> _callback) throws ApiException {
            return AuthApi.this.createUserAsync(this.userCreation, _callback);
        }
    }

    public class APIcreatePolicyRequest {
        private final Policy policy;

        private APIcreatePolicyRequest(Policy policy) {
            this.policy = policy;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.createPolicyCall(this.policy, _callback);
        }

        public Policy execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.createPolicyWithHttpInfo(this.policy);
            return (Policy)localVarResp.getData();
        }

        public ApiResponse<Policy> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.createPolicyWithHttpInfo(this.policy);
        }

        public Call executeAsync(ApiCallback<Policy> _callback) throws ApiException {
            return AuthApi.this.createPolicyAsync(this.policy, _callback);
        }
    }

    public class APIcreateGroupRequest {
        private GroupCreation groupCreation;

        private APIcreateGroupRequest() {
        }

        public APIcreateGroupRequest groupCreation(GroupCreation groupCreation) {
            this.groupCreation = groupCreation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.createGroupCall(this.groupCreation, _callback);
        }

        public Group execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.createGroupWithHttpInfo(this.groupCreation);
            return (Group)localVarResp.getData();
        }

        public ApiResponse<Group> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.createGroupWithHttpInfo(this.groupCreation);
        }

        public Call executeAsync(ApiCallback<Group> _callback) throws ApiException {
            return AuthApi.this.createGroupAsync(this.groupCreation, _callback);
        }
    }

    public class APIcreateCredentialsRequest {
        private final String userId;

        private APIcreateCredentialsRequest(String userId) {
            this.userId = userId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.createCredentialsCall(this.userId, _callback);
        }

        public CredentialsWithSecret execute() throws ApiException {
            ApiResponse localVarResp = AuthApi.this.createCredentialsWithHttpInfo(this.userId);
            return (CredentialsWithSecret)localVarResp.getData();
        }

        public ApiResponse<CredentialsWithSecret> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.createCredentialsWithHttpInfo(this.userId);
        }

        public Call executeAsync(ApiCallback<CredentialsWithSecret> _callback) throws ApiException {
            return AuthApi.this.createCredentialsAsync(this.userId, _callback);
        }
    }

    public class APIattachPolicyToUserRequest {
        private final String userId;
        private final String policyId;

        private APIattachPolicyToUserRequest(String userId, String policyId) {
            this.userId = userId;
            this.policyId = policyId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.attachPolicyToUserCall(this.userId, this.policyId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.attachPolicyToUserWithHttpInfo(this.userId, this.policyId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.attachPolicyToUserWithHttpInfo(this.userId, this.policyId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.attachPolicyToUserAsync(this.userId, this.policyId, _callback);
        }
    }

    public class APIattachPolicyToGroupRequest {
        private final String groupId;
        private final String policyId;

        private APIattachPolicyToGroupRequest(String groupId, String policyId) {
            this.groupId = groupId;
            this.policyId = policyId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.attachPolicyToGroupCall(this.groupId, this.policyId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.attachPolicyToGroupWithHttpInfo(this.groupId, this.policyId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.attachPolicyToGroupWithHttpInfo(this.groupId, this.policyId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.attachPolicyToGroupAsync(this.groupId, this.policyId, _callback);
        }
    }

    public class APIaddGroupMembershipRequest {
        private final String groupId;
        private final String userId;

        private APIaddGroupMembershipRequest(String groupId, String userId) {
            this.groupId = groupId;
            this.userId = userId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AuthApi.this.addGroupMembershipCall(this.groupId, this.userId, _callback);
        }

        public void execute() throws ApiException {
            AuthApi.this.addGroupMembershipWithHttpInfo(this.groupId, this.userId);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return AuthApi.this.addGroupMembershipWithHttpInfo(this.groupId, this.userId);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return AuthApi.this.addGroupMembershipAsync(this.groupId, this.userId, _callback);
        }
    }
}

